/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.efesto.common.api.identifiers.LocalUri;
import org.kie.efesto.common.api.identifiers.ModelLocalUriId;
import org.kie.efesto.common.api.io.IndexFile;
import org.kie.efesto.common.api.model.GeneratedResources;
import org.kie.efesto.common.api.utils.JSONUtils;
import org.kie.efesto.runtimemanager.api.exceptions.EfestoRuntimeManagerException;
import org.kie.efesto.runtimemanager.api.exceptions.KieRuntimeServiceException;
import org.kie.memorycompiler.KieMemoryCompiler;
import org.kie.pmml.api.PMMLContext;
import org.kie.pmml.api.runtime.PMMLListener;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.model.KiePMMLModelFactory;
import org.kie.pmml.commons.utils.PMMLLoaderUtils;

class PMMLLoaderUtilsTest {
    private static final String basePath = "testmod";
    private static final String MODEL_NAME = "TestMod";
    private static final String FILE_NAME = "FileName";
    private static KieMemoryCompiler.MemoryCompilerClassLoader memoryCompilerClassLoader;
    private static Map<String, GeneratedResources> generatedResourcesMap;

    PMMLLoaderUtilsTest() {
    }

    @BeforeAll
    static void setUp() {
        memoryCompilerClassLoader = new KieMemoryCompiler.MemoryCompilerClassLoader(Thread.currentThread().getContextClassLoader());
        Map indexFileMap = IndexFile.findIndexFilesFromClassLoader((ClassLoader)memoryCompilerClassLoader, Collections.singleton("pmml"));
        generatedResourcesMap = new HashMap<String, GeneratedResources>();
        indexFileMap.forEach((model, indexFile) -> {
            try {
                GeneratedResources generatedResources = JSONUtils.getGeneratedResourcesObject((IndexFile)indexFile);
                generatedResourcesMap.put((String)model, generatedResources);
            }
            catch (Exception e) {
                throw new EfestoRuntimeManagerException("Failed to read IndexFile content : " + indexFile.getAbsolutePath(), (Throwable)e);
            }
        });
    }

    @Test
    void loadKiePMMLModelFactory() {
        KiePMMLModelFactory retrieved = PMMLLoaderUtils.loadKiePMMLModelFactory((ModelLocalUriId)new ModelLocalUriId(LocalUri.parse((String)"/pmml/testmod")), (PMMLContext)this.getPMMLContext(FILE_NAME, MODEL_NAME));
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((List)retrieved.getKiePMMLModels()).hasSize(1);
        KiePMMLModel kiePmmlModel = (KiePMMLModel)retrieved.getKiePMMLModels().get(0);
        Assertions.assertThat((String)kiePmmlModel.getName()).isEqualTo(MODEL_NAME);
    }

    @Test
    void loadNotExistingKiePMMLModelFactory() {
        try {
            PMMLLoaderUtils.loadKiePMMLModelFactory((ModelLocalUriId)new ModelLocalUriId(LocalUri.parse((String)"/notpmml/testmod")), (PMMLContext)this.getPMMLContext(FILE_NAME, MODEL_NAME));
            Assertions.fail((String)"Expecting KieRuntimeServiceException");
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).isInstanceOf(KieRuntimeServiceException.class);
        }
    }

    private PMMLContext getPMMLContext(String fileName, final String modelName, Set<PMMLListener> listeners) {
        return new PMMLContext<PMMLListener>(){

            public String getName() {
                return modelName;
            }

            public Object get(String identifier) {
                return null;
            }

            public void set(String identifier, Object value) {
            }

            public void remove(String identifier) {
            }

            public boolean has(String identifier) {
                return false;
            }

            public Class<?> loadClass(String className) throws ClassNotFoundException {
                return memoryCompilerClassLoader.loadClass(className);
            }

            public Map<String, GeneratedResources> getGeneratedResourcesMap() {
                return generatedResourcesMap;
            }
        };
    }

    private PMMLContext getPMMLContext(String fileName, String modelName) {
        return this.getPMMLContext(fileName, modelName, Collections.emptySet());
    }
}

