/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model.predicates;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.pmml.api.enums.ARRAY_TYPE;
import org.kie.pmml.api.enums.IN_NOTIN;
import org.kie.pmml.commons.model.predicates.KiePMMLSimpleSetPredicate;

public class KiePMMLSimpleSetPredicateTest {
    private final String SIMPLE_SET_PREDICATE_NAME = "SIMPLESETPREDICATENAME";

    @Test
    void evaluateStringIn() {
        ARRAY_TYPE arrayType = ARRAY_TYPE.STRING;
        List<Object> values = this.getObjects(arrayType, 4);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicate = this.getKiePMMLSimpleSetPredicate(values, arrayType, IN_NOTIN.IN);
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("FAKE", "NOT");
        Assertions.assertThat((boolean)kiePMMLSimpleSetPredicate.evaluate(inputData)).isFalse();
        inputData.put("SIMPLESETPREDICATENAME", "NOT");
        Assertions.assertThat((boolean)kiePMMLSimpleSetPredicate.evaluate(inputData)).isFalse();
        inputData.put("SIMPLESETPREDICATENAME", values.get(0));
        Assertions.assertThat((boolean)kiePMMLSimpleSetPredicate.evaluate(inputData)).isTrue();
    }

    @Test
    void evaluateStringNotIn() {
        ARRAY_TYPE arrayType = ARRAY_TYPE.STRING;
        List<Object> values = this.getObjects(arrayType, 4);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicate = this.getKiePMMLSimpleSetPredicate(values, arrayType, IN_NOTIN.NOT_IN);
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("FAKE", "NOT");
        Assertions.assertThat((boolean)kiePMMLSimpleSetPredicate.evaluate(inputData)).isFalse();
        inputData.put("SIMPLESETPREDICATENAME", values.get(0));
        Assertions.assertThat((boolean)kiePMMLSimpleSetPredicate.evaluate(inputData)).isFalse();
        inputData.put("SIMPLESETPREDICATENAME", "NOT");
        Assertions.assertThat((boolean)kiePMMLSimpleSetPredicate.evaluate(inputData)).isTrue();
    }

    @Test
    void evaluateIntIn() {
        ARRAY_TYPE arrayType = ARRAY_TYPE.INT;
        List<Object> values = this.getObjects(arrayType, 4);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicate = this.getKiePMMLSimpleSetPredicate(values, arrayType, IN_NOTIN.IN);
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("FAKE", "234");
        Assertions.assertThat((boolean)kiePMMLSimpleSetPredicate.evaluate(inputData)).isFalse();
        inputData.put("SIMPLESETPREDICATENAME", "432");
        Assertions.assertThat((boolean)kiePMMLSimpleSetPredicate.evaluate(inputData)).isFalse();
        inputData.put("SIMPLESETPREDICATENAME", values.get(0));
        Assertions.assertThat((boolean)kiePMMLSimpleSetPredicate.evaluate(inputData)).isTrue();
    }

    @Test
    void evaluateIntNotIn() {
        ARRAY_TYPE arrayType = ARRAY_TYPE.INT;
        List<Object> values = this.getObjects(arrayType, 4);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicate = this.getKiePMMLSimpleSetPredicate(values, arrayType, IN_NOTIN.NOT_IN);
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("FAKE", "234");
        Assertions.assertThat((boolean)kiePMMLSimpleSetPredicate.evaluate(inputData)).isFalse();
        inputData.put("SIMPLESETPREDICATENAME", values.get(0));
        Assertions.assertThat((boolean)kiePMMLSimpleSetPredicate.evaluate(inputData)).isFalse();
        inputData.put("SIMPLESETPREDICATENAME", "432");
        Assertions.assertThat((boolean)kiePMMLSimpleSetPredicate.evaluate(inputData)).isTrue();
    }

    @Test
    void evaluateRealIn() {
        ARRAY_TYPE arrayType = ARRAY_TYPE.REAL;
        List<Object> values = this.getObjects(arrayType, 4);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicate = this.getKiePMMLSimpleSetPredicate(values, arrayType, IN_NOTIN.IN);
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("FAKE", "23.4");
        Assertions.assertThat((boolean)kiePMMLSimpleSetPredicate.evaluate(inputData)).isFalse();
        inputData.put("SIMPLESETPREDICATENAME", "4.32");
        Assertions.assertThat((boolean)kiePMMLSimpleSetPredicate.evaluate(inputData)).isFalse();
        inputData.put("SIMPLESETPREDICATENAME", values.get(0));
        Assertions.assertThat((boolean)kiePMMLSimpleSetPredicate.evaluate(inputData)).isTrue();
    }

    @Test
    void evaluateRealNotIn() {
        ARRAY_TYPE arrayType = ARRAY_TYPE.REAL;
        List<Object> values = this.getObjects(arrayType, 4);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicate = this.getKiePMMLSimpleSetPredicate(values, arrayType, IN_NOTIN.NOT_IN);
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("FAKE", "23.4");
        Assertions.assertThat((boolean)kiePMMLSimpleSetPredicate.evaluate(inputData)).isFalse();
        inputData.put("SIMPLESETPREDICATENAME", values.get(0));
        Assertions.assertThat((boolean)kiePMMLSimpleSetPredicate.evaluate(inputData)).isFalse();
        inputData.put("SIMPLESETPREDICATENAME", "4.32");
        Assertions.assertThat((boolean)kiePMMLSimpleSetPredicate.evaluate(inputData)).isTrue();
    }

    @Test
    void evaluationStringIn() {
        ARRAY_TYPE arrayType = ARRAY_TYPE.STRING;
        List<Object> values = this.getObjects(arrayType, 1);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicate = this.getKiePMMLSimpleSetPredicate(values, arrayType, IN_NOTIN.IN);
        Assertions.assertThat((boolean)kiePMMLSimpleSetPredicate.evaluation((Object)"NOT")).isFalse();
        Assertions.assertThat((boolean)kiePMMLSimpleSetPredicate.evaluation(values.get(0))).isTrue();
    }

    @Test
    void evaluationStringNotIn() {
        ARRAY_TYPE arrayType = ARRAY_TYPE.STRING;
        List<Object> values = this.getObjects(arrayType, 1);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicate = this.getKiePMMLSimpleSetPredicate(values, arrayType, IN_NOTIN.NOT_IN);
        Assertions.assertThat((boolean)kiePMMLSimpleSetPredicate.evaluation(values.get(0))).isFalse();
        Assertions.assertThat((boolean)kiePMMLSimpleSetPredicate.evaluation((Object)"NOT")).isTrue();
    }

    @Test
    void evaluationIntIn() {
        ARRAY_TYPE arrayType = ARRAY_TYPE.INT;
        List<Object> values = this.getObjects(arrayType, 1);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicate = this.getKiePMMLSimpleSetPredicate(values, arrayType, IN_NOTIN.IN);
        Assertions.assertThat((boolean)kiePMMLSimpleSetPredicate.evaluation((Object)"234")).isFalse();
        Assertions.assertThat((boolean)kiePMMLSimpleSetPredicate.evaluation(values.get(0))).isTrue();
    }

    @Test
    void evaluationIntNotIn() {
        ARRAY_TYPE arrayType = ARRAY_TYPE.INT;
        List<Object> values = this.getObjects(arrayType, 1);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicate = this.getKiePMMLSimpleSetPredicate(values, arrayType, IN_NOTIN.NOT_IN);
        Assertions.assertThat((boolean)kiePMMLSimpleSetPredicate.evaluation(values.get(0))).isFalse();
        Assertions.assertThat((boolean)kiePMMLSimpleSetPredicate.evaluation((Object)"234")).isTrue();
    }

    @Test
    void evaluationRealIn() {
        ARRAY_TYPE arrayType = ARRAY_TYPE.REAL;
        List<Object> values = this.getObjects(arrayType, 1);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicate = this.getKiePMMLSimpleSetPredicate(values, arrayType, IN_NOTIN.IN);
        Assertions.assertThat((boolean)kiePMMLSimpleSetPredicate.evaluation((Object)"23.4")).isFalse();
        Assertions.assertThat((boolean)kiePMMLSimpleSetPredicate.evaluation(values.get(0))).isTrue();
    }

    @Test
    void evaluationRealNotIn() {
        ARRAY_TYPE arrayType = ARRAY_TYPE.REAL;
        List<Object> values = this.getObjects(arrayType, 1);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicate = this.getKiePMMLSimpleSetPredicate(values, arrayType, IN_NOTIN.NOT_IN);
        Assertions.assertThat((boolean)kiePMMLSimpleSetPredicate.evaluation(values.get(0))).isFalse();
        Assertions.assertThat((boolean)kiePMMLSimpleSetPredicate.evaluation((Object)"23.4")).isTrue();
    }

    private KiePMMLSimpleSetPredicate getKiePMMLSimpleSetPredicate(List<Object> values, ARRAY_TYPE arrayType, IN_NOTIN inNotIn) {
        return (KiePMMLSimpleSetPredicate)KiePMMLSimpleSetPredicate.builder((String)"SIMPLESETPREDICATENAME", Collections.emptyList(), (ARRAY_TYPE)arrayType, (IN_NOTIN)inNotIn).withValues(values).build();
    }

    private List<Object> getObjects(ARRAY_TYPE arrayType, int size) {
        return IntStream.range(0, size).mapToObj(index -> {
            switch (arrayType) {
                case INT: {
                    return Integer.valueOf(new Random().nextInt(40));
                }
                case REAL: {
                    return Double.valueOf(new Random().nextDouble());
                }
                case STRING: {
                    return UUID.randomUUID().toString();
                }
            }
            return null;
        }).collect(Collectors.toList());
    }
}

