/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.runtime.PMMLRuntimeContext;
import org.kie.pmml.commons.model.KiePMMLModelWithSources;
import org.kie.pmml.commons.testingutility.PMMLRuntimeContextTest;

public class KiePMMLModelWithSourcesTest {
    private static final String FILE_NAME = "fileName";
    private static final String MODEL_NAME = "MODEL_NAME";
    private static final String PACKAGE_NAME = "PACKAGE_NAME";
    private static final Map<String, String> SOURCES_MAP = new HashMap<String, String>();
    private KiePMMLModelWithSources kiePMMLModelWithSources;

    @BeforeEach
    public void setup() {
        this.kiePMMLModelWithSources = new KiePMMLModelWithSources(FILE_NAME, MODEL_NAME, PACKAGE_NAME, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), SOURCES_MAP, false);
    }

    @Test
    void evaluate() {
        AssertionsForClassTypes.assertThatExceptionOfType(KiePMMLException.class).isThrownBy(() -> this.kiePMMLModelWithSources.evaluate(Collections.EMPTY_MAP, (PMMLRuntimeContext)new PMMLRuntimeContextTest()));
    }

    @Test
    void getSourcesMap() {
        Assertions.assertThat((Map)this.kiePMMLModelWithSources.getSourcesMap()).isEqualTo(SOURCES_MAP);
    }

    @Test
    void addToGetSourcesMap() {
        AssertionsForClassTypes.assertThatExceptionOfType(UnsupportedOperationException.class).isThrownBy(() -> {
            Map retrieved = this.kiePMMLModelWithSources.getSourcesMap();
            retrieved.put("KEY", "VALUE");
        });
    }

    @Test
    void addSourceMap() {
        Map retrieved = this.kiePMMLModelWithSources.getSourcesMap();
        Assertions.assertThat((Map)retrieved).isEmpty();
        this.kiePMMLModelWithSources.addSourceMap("KEY", "VALUE");
        retrieved = this.kiePMMLModelWithSources.getSourcesMap();
        Assertions.assertThat((Map)retrieved).containsKey((Object)"KEY");
        Assertions.assertThat((String)((String)retrieved.get("KEY"))).isEqualTo("VALUE");
    }
}

