/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model.expressions;

import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.pmml.commons.CommonTestingUtility;
import org.kie.pmml.commons.model.ProcessingDTO;
import org.kie.pmml.commons.model.expressions.KiePMMLNormDiscrete;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;

public class KiePMMLNormDiscreteTest {
    @Test
    void evaluateMissingValue() {
        String fieldName = "fieldName";
        String fieldValue = "fieldValue";
        Double mapMissingTo = 1.0;
        KiePMMLNormDiscrete kiePMMLNormContinuous = this.getKiePMMLNormDiscrete(fieldName, fieldValue, mapMissingTo);
        ProcessingDTO processingDTO = CommonTestingUtility.getProcessingDTO(Collections.emptyList());
        Object retrieved = kiePMMLNormContinuous.evaluate(processingDTO);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)mapMissingTo);
    }

    @Test
    void evaluateSameValue() {
        String fieldName = "fieldName";
        String fieldValue = "fieldValue";
        Number mapMissingTo = null;
        KiePMMLNormDiscrete kiePMMLNormContinuous = this.getKiePMMLNormDiscrete(fieldName, fieldValue, mapMissingTo);
        ProcessingDTO processingDTO = CommonTestingUtility.getProcessingDTO(Collections.singletonList(new KiePMMLNameValue(fieldName, (Object)fieldValue)));
        Object retrieved = kiePMMLNormContinuous.evaluate(processingDTO);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)1.0);
    }

    @Test
    void evaluateDifferentValue() {
        String fieldName = "fieldName";
        String fieldValue = "fieldValue";
        Number mapMissingTo = null;
        KiePMMLNormDiscrete kiePMMLNormContinuous = this.getKiePMMLNormDiscrete(fieldName, fieldValue, mapMissingTo);
        ProcessingDTO processingDTO = CommonTestingUtility.getProcessingDTO(Collections.singletonList(new KiePMMLNameValue(fieldName, (Object)"anotherValue")));
        Object retrieved = kiePMMLNormContinuous.evaluate(processingDTO);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)0.0);
    }

    private KiePMMLNormDiscrete getKiePMMLNormDiscrete(String name, String value, Number mapMissingTo) {
        return new KiePMMLNormDiscrete(name, Collections.emptyList(), value, mapMissingTo);
    }
}

