/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.transformations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.enums.OP_TYPE;
import org.kie.pmml.commons.CommonTestingUtility;
import org.kie.pmml.commons.model.ProcessingDTO;
import org.kie.pmml.commons.model.expressions.KiePMMLApply;
import org.kie.pmml.commons.model.expressions.KiePMMLConstant;
import org.kie.pmml.commons.model.expressions.KiePMMLExpression;
import org.kie.pmml.commons.model.expressions.KiePMMLFieldRef;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;
import org.kie.pmml.commons.transformations.KiePMMLDefineFunction;
import org.kie.pmml.commons.transformations.KiePMMLParameterField;

public class KiePMMLDefineFunctionTest {
    private static final String CUSTOM_FUNCTION = "CUSTOM_FUNCTION";
    private static final String PARAM_1 = "PARAM_1";
    private static final String PARAM_2 = "PARAM_2";
    private static final Double value1 = 100.0;
    private static final Double value2 = 5.0;

    @Test
    void evaluateNoParamValues() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            KiePMMLParameterField parameterField1 = (KiePMMLParameterField)KiePMMLParameterField.builder((String)PARAM_1, Collections.emptyList()).build();
            KiePMMLParameterField parameterField2 = (KiePMMLParameterField)KiePMMLParameterField.builder((String)PARAM_2, Collections.emptyList()).build();
            KiePMMLDefineFunction defineFunction = new KiePMMLDefineFunction(CUSTOM_FUNCTION, Collections.emptyList(), null, OP_TYPE.CONTINUOUS, Arrays.asList(parameterField1, parameterField2), null);
            ProcessingDTO processingDTO = CommonTestingUtility.getProcessingDTO(Collections.emptyList());
            defineFunction.evaluate(processingDTO, null);
        });
    }

    @Test
    void evaluateEmptyParamValues() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            KiePMMLParameterField parameterField1 = (KiePMMLParameterField)KiePMMLParameterField.builder((String)PARAM_1, Collections.emptyList()).build();
            KiePMMLParameterField parameterField2 = (KiePMMLParameterField)KiePMMLParameterField.builder((String)PARAM_2, Collections.emptyList()).build();
            KiePMMLDefineFunction defineFunction = new KiePMMLDefineFunction(CUSTOM_FUNCTION, Collections.emptyList(), null, OP_TYPE.CONTINUOUS, Arrays.asList(parameterField1, parameterField2), null);
            ProcessingDTO processingDTO = CommonTestingUtility.getProcessingDTO(Collections.emptyList());
            defineFunction.evaluate(processingDTO, Collections.emptyList());
        });
    }

    @Test
    void evaluateFromConstant() {
        KiePMMLConstant kiePMMLConstant1 = new KiePMMLConstant(PARAM_1, Collections.emptyList(), (Object)value1, null);
        KiePMMLDefineFunction defineFunction = new KiePMMLDefineFunction(CUSTOM_FUNCTION, Collections.emptyList(), null, OP_TYPE.CONTINUOUS, Collections.emptyList(), (KiePMMLExpression)kiePMMLConstant1);
        ProcessingDTO processingDTO = CommonTestingUtility.getProcessingDTO(Collections.emptyList());
        Object retrieved = defineFunction.evaluate(processingDTO, Collections.emptyList());
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)value1);
    }

    @Test
    void evaluateFromFieldRef() {
        KiePMMLFieldRef kiePMMLFieldRef = new KiePMMLFieldRef(PARAM_1, Collections.emptyList(), null);
        KiePMMLDefineFunction defineFunction = new KiePMMLDefineFunction(CUSTOM_FUNCTION, Collections.emptyList(), DATA_TYPE.DOUBLE, OP_TYPE.CONTINUOUS, Collections.singletonList((KiePMMLParameterField)KiePMMLParameterField.builder((String)PARAM_1, Collections.emptyList()).build()), (KiePMMLExpression)kiePMMLFieldRef);
        ProcessingDTO processingDTO = CommonTestingUtility.getProcessingDTO(new ArrayList<KiePMMLNameValue>());
        Object retrieved = defineFunction.evaluate(processingDTO, Collections.singletonList(value1));
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)value1);
    }

    @Test
    void evaluateFromApply() {
        KiePMMLFieldRef kiePMMLFieldRef1 = new KiePMMLFieldRef(PARAM_1, Collections.emptyList(), null);
        KiePMMLFieldRef kiePMMLFieldRef2 = new KiePMMLFieldRef(PARAM_2, Collections.emptyList(), null);
        KiePMMLApply kiePMMLApply = (KiePMMLApply)KiePMMLApply.builder((String)"NAME", Collections.emptyList(), (String)"/").withKiePMMLExpressions(Arrays.asList(kiePMMLFieldRef1, kiePMMLFieldRef2)).build();
        KiePMMLParameterField parameterField1 = (KiePMMLParameterField)KiePMMLParameterField.builder((String)PARAM_1, Collections.emptyList()).build();
        KiePMMLParameterField parameterField2 = (KiePMMLParameterField)KiePMMLParameterField.builder((String)PARAM_2, Collections.emptyList()).build();
        KiePMMLDefineFunction defineFunction = new KiePMMLDefineFunction(CUSTOM_FUNCTION, Collections.emptyList(), DATA_TYPE.DOUBLE, OP_TYPE.CONTINUOUS, Arrays.asList(parameterField1, parameterField2), (KiePMMLExpression)kiePMMLApply);
        ProcessingDTO processingDTO = CommonTestingUtility.getProcessingDTO(new ArrayList<KiePMMLNameValue>());
        Object retrieved = defineFunction.evaluate(processingDTO, Arrays.asList(value1, value2));
        Double expected = value1 / value2;
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)expected);
    }
}

