/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model;

import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.Test;
import org.kie.pmml.api.enums.CAST_INTEGER;
import org.kie.pmml.api.models.TargetField;
import org.kie.pmml.commons.model.KiePMMLTarget;

public class KiePMMLTargetTest {
    private static final String TARGET_NAME = "TARGET_NAME";

    @Test
    void modifyPrediction() {
        Object object = "STRING";
        TargetField targetField = new TargetField(Collections.emptyList(), null, "string", null, null, null, null, null);
        KiePMMLTarget kiePMMLTarget = (KiePMMLTarget)this.getBuilder(targetField).build();
        Assertions.assertThat((Object)kiePMMLTarget.modifyPrediction(object)).isEqualTo(object);
        object = 4.33;
        Assertions.assertThat((Object)kiePMMLTarget.modifyPrediction(object)).isEqualTo(object);
        targetField = new TargetField(Collections.emptyList(), null, "string", null, (Number)4.34, null, null, null);
        kiePMMLTarget = (KiePMMLTarget)this.getBuilder(targetField).build();
        object = "STRING";
        Assertions.assertThat((Object)kiePMMLTarget.modifyPrediction(object)).isEqualTo(object);
        object = 4.33;
        Assertions.assertThat((Object)kiePMMLTarget.modifyPrediction(object)).isEqualTo((Object)4.34);
    }

    @Test
    void applyMin() {
        TargetField targetField = new TargetField(Collections.emptyList(), null, "string", null, null, null, null, null);
        KiePMMLTarget kiePMMLTarget = (KiePMMLTarget)this.getBuilder(targetField).build();
        Assertions.assertThat((Double)kiePMMLTarget.applyMin(4.33)).isCloseTo(4.33, Offset.offset((Number)0.0));
        targetField = new TargetField(Collections.emptyList(), null, "string", null, (Number)4.34, null, null, null);
        kiePMMLTarget = (KiePMMLTarget)this.getBuilder(targetField).build();
        Assertions.assertThat((Double)kiePMMLTarget.applyMin(4.33)).isCloseTo(4.34, Offset.offset((Number)0.0));
        Assertions.assertThat((Double)kiePMMLTarget.applyMin(4.35)).isCloseTo(4.35, Offset.offset((Number)0.0));
    }

    @Test
    void applyMax() {
        TargetField targetField = new TargetField(Collections.emptyList(), null, "string", null, null, null, null, null);
        KiePMMLTarget kiePMMLTarget = (KiePMMLTarget)this.getBuilder(targetField).build();
        Assertions.assertThat((Double)kiePMMLTarget.applyMax(4.33)).isCloseTo(4.33, Offset.offset((Number)0.0));
        targetField = new TargetField(Collections.emptyList(), null, "string", null, null, (Number)4.34, null, null);
        kiePMMLTarget = (KiePMMLTarget)this.getBuilder(targetField).build();
        Assertions.assertThat((Double)kiePMMLTarget.applyMax(4.33)).isCloseTo(4.33, Offset.offset((Number)0.0));
        Assertions.assertThat((Double)kiePMMLTarget.applyMax(4.35)).isCloseTo(4.34, Offset.offset((Number)0.0));
    }

    @Test
    void applyRescaleFactor() {
        TargetField targetField = new TargetField(Collections.emptyList(), null, "string", null, null, null, null, null);
        KiePMMLTarget kiePMMLTarget = (KiePMMLTarget)this.getBuilder(targetField).build();
        Assertions.assertThat((Double)kiePMMLTarget.applyRescaleFactor(4.0)).isCloseTo(4.0, Offset.offset((Number)0.0));
        targetField = new TargetField(Collections.emptyList(), null, "string", null, null, null, null, (Number)2.0);
        kiePMMLTarget = (KiePMMLTarget)this.getBuilder(targetField).build();
        Assertions.assertThat((Double)kiePMMLTarget.applyRescaleFactor(4.0)).isCloseTo(8.0, Offset.offset((Number)0.0));
    }

    @Test
    void applyRescaleConstant() {
        TargetField targetField = new TargetField(Collections.emptyList(), null, "string", null, null, null, null, null);
        KiePMMLTarget kiePMMLTarget = (KiePMMLTarget)this.getBuilder(targetField).build();
        Assertions.assertThat((Double)kiePMMLTarget.applyRescaleConstant(6.0)).isCloseTo(6.0, Offset.offset((Number)0.0));
        targetField = new TargetField(Collections.emptyList(), null, "string", null, null, null, (Number)2.0, null);
        kiePMMLTarget = (KiePMMLTarget)this.getBuilder(targetField).build();
        Assertions.assertThat((Double)kiePMMLTarget.applyRescaleConstant(6.0)).isCloseTo(8.0, Offset.offset((Number)0.0));
    }

    @Test
    void applyCastInteger() {
        TargetField targetField = new TargetField(Collections.emptyList(), null, "string", null, null, null, null, null);
        KiePMMLTarget kiePMMLTarget = (KiePMMLTarget)this.getBuilder(targetField).build();
        Assertions.assertThat((double)((Double)kiePMMLTarget.applyCastInteger(2.718))).isCloseTo(2.718, Offset.offset((Number)0.0));
        targetField = new TargetField(Collections.emptyList(), null, "string", CAST_INTEGER.ROUND, null, null, null, null);
        kiePMMLTarget = (KiePMMLTarget)this.getBuilder(targetField).build();
        Assertions.assertThat((double)((Double)kiePMMLTarget.applyCastInteger(2.718))).isCloseTo(3.0, Offset.offset((Number)0.0));
    }

    private KiePMMLTarget.Builder getBuilder(TargetField targetField) {
        return KiePMMLTarget.builder((String)TARGET_NAME, Collections.emptyList(), (TargetField)targetField);
    }
}

