/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model.expressions;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.pmml.commons.CommonTestingUtility;
import org.kie.pmml.commons.model.ProcessingDTO;
import org.kie.pmml.commons.model.expressions.KiePMMLFieldColumnPair;
import org.kie.pmml.commons.model.expressions.KiePMMLInlineTable;
import org.kie.pmml.commons.model.expressions.KiePMMLMapValues;
import org.kie.pmml.commons.model.expressions.KiePMMLRow;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;

public class KiePMMLMapValuesTest {
    private static final KiePMMLInlineTable INLINE_TABLE;
    private static final List<KiePMMLFieldColumnPair> FIELDCOLUMNPAIRS;
    private static final String OUTPUTCOLUMN = "outputColumn";
    private static final String MAPMISSINGTO = "mapMissingTo";
    private static final String DEFAULTVALUE = "defaultValue";

    @Test
    void evaluateKeyNotFound() {
        KiePMMLMapValues kiePMMLMapValues = this.getKiePMMLMapValues();
        ProcessingDTO processingDTO = CommonTestingUtility.getProcessingDTO(Collections.emptyList());
        Assertions.assertThat((Object)kiePMMLMapValues.evaluate(processingDTO)).isEqualTo((Object)MAPMISSINGTO);
    }

    @Test
    void evaluateKeyFoundNotMatching() {
        KiePMMLMapValues kiePMMLMapValues = this.getKiePMMLMapValues();
        List<KiePMMLNameValue> kiePMMLNameValues = IntStream.range(0, 2).mapToObj(i -> new KiePMMLNameValue("FIELD-" + i, (Object)("NOT-VALUE-1-" + i))).collect(Collectors.toList());
        ProcessingDTO processingDTO = CommonTestingUtility.getProcessingDTO(kiePMMLNameValues);
        Assertions.assertThat((Object)kiePMMLMapValues.evaluate(processingDTO)).isEqualTo((Object)DEFAULTVALUE);
    }

    @Test
    void evaluateKeyFoundMatching() {
        KiePMMLMapValues kiePMMLMapValues = this.getKiePMMLMapValues();
        List<KiePMMLNameValue> kiePMMLNameValues = IntStream.range(0, 2).mapToObj(i -> new KiePMMLNameValue("FIELD-" + i, (Object)("VALUE-1-" + i))).collect(Collectors.toList());
        ProcessingDTO processingDTO = CommonTestingUtility.getProcessingDTO(kiePMMLNameValues);
        Object retrieved = kiePMMLMapValues.evaluate(processingDTO);
        Assertions.assertThat((Object)retrieved).isNotNull();
    }

    private KiePMMLMapValues getKiePMMLMapValues() {
        return (KiePMMLMapValues)KiePMMLMapValues.builder((String)"name", Collections.emptyList(), (String)OUTPUTCOLUMN).withMapMissingTo(MAPMISSINGTO).withDefaultValue(DEFAULTVALUE).withKiePMMLInlineTable(INLINE_TABLE).withKiePMMLFieldColumnPairs(FIELDCOLUMNPAIRS).build();
    }

    static {
        List rows = IntStream.range(0, 4).mapToObj(i -> {
            Map<String, Object> columnValues = IntStream.range(0, 3).boxed().collect(Collectors.toMap(j -> "KEY-" + i + "-" + j, j -> "VALUE-" + i + "-" + j));
            return new KiePMMLRow(columnValues);
        }).collect(Collectors.toList());
        INLINE_TABLE = new KiePMMLInlineTable("name", Collections.emptyList(), rows);
        FIELDCOLUMNPAIRS = IntStream.range(0, 2).mapToObj(i -> new KiePMMLFieldColumnPair("FIELD-" + i, Collections.emptyList(), "VALUE-1-" + i)).collect(Collectors.toList());
    }
}

