/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import org.dmg.pmml.DerivedField;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLExpressionFactory;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;

public class KiePMMLDerivedFieldFactory {
    static final String KIE_PMML_DERIVED_FIELD_TEMPLATE_JAVA = "KiePMMLDerivedFieldTemplate.tmpl";
    static final String KIE_PMML_DERIVED_FIELD_TEMPLATE = "KiePMMLDerivedFieldTemplate";
    static final String GETKIEPMMLDERIVEDFIELD = "getKiePMMLDerivedField";
    static final String DERIVED_FIELD = "derivedField";
    static final ClassOrInterfaceDeclaration DERIVED_FIELD_TEMPLATE;

    private KiePMMLDerivedFieldFactory() {
    }

    static BlockStmt getDerivedFieldVariableDeclaration(String variableName, DerivedField derivedField) {
        MethodDeclaration methodDeclaration = ((MethodDeclaration)DERIVED_FIELD_TEMPLATE.getMethodsByName(GETKIEPMMLDERIVEDFIELD).get(0)).clone();
        BlockStmt derivedFieldBody = (BlockStmt)methodDeclaration.getBody().orElseThrow(() -> new KiePMMLException(String.format("Missing body in %s", methodDeclaration)));
        VariableDeclarator variableDeclarator = CommonCodegenUtils.getVariableDeclarator(derivedFieldBody, DERIVED_FIELD).orElseThrow(() -> new KiePMMLException(String.format("Missing expected variable '%s' in body %s", DERIVED_FIELD, derivedFieldBody)));
        variableDeclarator.setName(variableName);
        BlockStmt toReturn = new BlockStmt();
        String nestedVariableName = String.format("%s_%s", variableName, 0);
        BlockStmt toAdd = KiePMMLExpressionFactory.getKiePMMLExpression(nestedVariableName, derivedField.getExpression());
        toAdd.getStatements().forEach(arg_0 -> ((BlockStmt)toReturn).addStatement(arg_0));
        MethodCallExpr initializer = ((Expression)variableDeclarator.getInitializer().orElseThrow(() -> new KiePMMLException(String.format("Missing '%s' initializer in %s", DERIVED_FIELD, derivedFieldBody)))).asMethodCallExpr();
        MethodCallExpr builder = CommonCodegenUtils.getChainedMethodCallExprFrom("builder", initializer);
        Expression dataTypeExpression = CommonCodegenUtils.getExpressionForDataType(derivedField.getDataType());
        Expression opTypeExpression = CommonCodegenUtils.getExpressionForOpType(derivedField.getOpType());
        builder.setArgument(0, (Expression)new StringLiteralExpr(derivedField.getName().getValue()));
        builder.setArgument(2, dataTypeExpression);
        builder.setArgument(3, opTypeExpression);
        builder.setArgument(4, (Expression)new NameExpr(nestedVariableName));
        CommonCodegenUtils.getChainedMethodCallExprFrom("withDisplayName", initializer).setArgument(0, CommonCodegenUtils.getExpressionForObject(derivedField.getDisplayName()));
        derivedFieldBody.getStatements().forEach(arg_0 -> ((BlockStmt)toReturn).addStatement(arg_0));
        return toReturn;
    }

    static {
        CompilationUnit cloneCU = JavaParserUtils.getFromFileName(KIE_PMML_DERIVED_FIELD_TEMPLATE_JAVA);
        DERIVED_FIELD_TEMPLATE = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(KIE_PMML_DERIVED_FIELD_TEMPLATE).orElseThrow(() -> new KiePMMLException("Main class not found: KiePMMLDerivedFieldTemplate"));
        ((MethodDeclaration)DERIVED_FIELD_TEMPLATE.getMethodsByName(GETKIEPMMLDERIVEDFIELD).get(0)).clone();
    }
}

