/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.OpType;
import org.junit.jupiter.api.Test;
import org.kie.pmml.commons.model.expressions.KiePMMLApply;
import org.kie.pmml.commons.model.expressions.KiePMMLConstant;
import org.kie.pmml.commons.model.expressions.KiePMMLFieldRef;
import org.kie.pmml.commons.transformations.KiePMMLDerivedField;
import org.kie.pmml.compiler.api.CommonTestingUtils;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLDerivedFieldFactory;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.test.util.filesystem.FileUtils;

public class KiePMMLDerivedFieldFactoryTest {
    private static final String CUSTOM_FUNCTION = "CUSTOM_FUNCTION";
    private static final String PARAM_1 = "PARAM_1";
    private static final String PARAM_2 = "PARAM_2";
    private static final Double value1 = 100.0;
    private static final String TEST_01_SOURCE = "KiePMMLDerivedFieldFactoryTest_01.txt";
    private static final String TEST_02_SOURCE = "KiePMMLDerivedFieldFactoryTest_02.txt";
    private static final String TEST_03_SOURCE = "KiePMMLDerivedFieldFactoryTest_03.txt";

    @Test
    void getDerivedFieldVariableDeclarationWithConstant() throws IOException {
        String variableName = "variableName";
        Constant constant = new Constant();
        constant.setValue((Object)value1);
        DerivedField derivedField = new DerivedField();
        derivedField.setName(FieldName.create((String)PARAM_1));
        derivedField.setDataType(DataType.DOUBLE);
        derivedField.setOpType(OpType.CONTINUOUS);
        derivedField.setExpression((Expression)constant);
        String dataType = CommonTestingUtils.getDATA_TYPEString((DataType)derivedField.getDataType());
        String opType = CommonTestingUtils.getOP_TYPEString((OpType)derivedField.getOpType());
        BlockStmt retrieved = KiePMMLDerivedFieldFactory.getDerivedFieldVariableDeclaration((String)"variableName", (DerivedField)derivedField);
        String text = FileUtils.getFileContent((String)TEST_01_SOURCE);
        BlockStmt expected = JavaParserUtils.parseBlock((String)String.format(text, constant.getValue(), "variableName", derivedField.getName().getValue(), dataType, opType));
        Assertions.assertThat((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved)).isTrue();
        List<Class<?>> imports = Arrays.asList(KiePMMLConstant.class, KiePMMLDerivedField.class, Collections.class);
        CodegenTestUtils.commonValidateCompilationWithImports(retrieved, imports);
    }

    @Test
    void getDerivedFieldVariableDeclarationWithFieldRef() throws IOException {
        String variableName = "variableName";
        FieldRef fieldRef = new FieldRef();
        fieldRef.setField(FieldName.create((String)"FIELD_REF"));
        DerivedField derivedField = new DerivedField();
        derivedField.setName(FieldName.create((String)PARAM_1));
        derivedField.setDataType(DataType.DOUBLE);
        derivedField.setOpType(OpType.CONTINUOUS);
        derivedField.setExpression((Expression)fieldRef);
        String dataType = CommonTestingUtils.getDATA_TYPEString((DataType)derivedField.getDataType());
        String opType = CommonTestingUtils.getOP_TYPEString((OpType)derivedField.getOpType());
        BlockStmt retrieved = KiePMMLDerivedFieldFactory.getDerivedFieldVariableDeclaration((String)"variableName", (DerivedField)derivedField);
        String text = FileUtils.getFileContent((String)TEST_02_SOURCE);
        BlockStmt expected = JavaParserUtils.parseBlock((String)String.format(text, fieldRef.getField().getValue(), "variableName", derivedField.getName().getValue(), dataType, opType));
        Assertions.assertThat((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved)).isTrue();
        List<Class<?>> imports = Arrays.asList(KiePMMLFieldRef.class, KiePMMLDerivedField.class, Collections.class);
        CodegenTestUtils.commonValidateCompilationWithImports(retrieved, imports);
    }

    @Test
    void getDerivedFieldVariableDeclarationWithApply() throws IOException {
        String variableName = "variableName";
        Constant constant = new Constant();
        constant.setValue((Object)value1);
        FieldRef fieldRef = new FieldRef();
        fieldRef.setField(FieldName.create((String)"FIELD_REF"));
        Apply apply = new Apply();
        apply.setFunction("/");
        apply.addExpressions(new Expression[]{constant, fieldRef});
        DerivedField derivedField = new DerivedField();
        derivedField.setName(FieldName.create((String)PARAM_1));
        derivedField.setDataType(DataType.DOUBLE);
        derivedField.setOpType(OpType.CONTINUOUS);
        derivedField.setExpression((Expression)apply);
        String dataType = CommonTestingUtils.getDATA_TYPEString((DataType)derivedField.getDataType());
        String opType = CommonTestingUtils.getOP_TYPEString((OpType)derivedField.getOpType());
        BlockStmt retrieved = KiePMMLDerivedFieldFactory.getDerivedFieldVariableDeclaration((String)"variableName", (DerivedField)derivedField);
        String text = FileUtils.getFileContent((String)TEST_03_SOURCE);
        BlockStmt expected = JavaParserUtils.parseBlock((String)String.format(text, constant.getValue(), fieldRef.getField().getValue(), apply.getFunction(), apply.getInvalidValueTreatment().value(), "variableName", derivedField.getName().getValue(), dataType, opType));
        Assertions.assertThat((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved)).isTrue();
        List<Class<?>> imports = Arrays.asList(KiePMMLConstant.class, KiePMMLFieldRef.class, KiePMMLApply.class, KiePMMLDerivedField.class, Arrays.class, Collections.class);
        CodegenTestUtils.commonValidateCompilationWithImports(retrieved, imports);
    }
}

