/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.DiscretizeBin;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Interval;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.pmml.commons.model.expressions.KiePMMLDiscretize;
import org.kie.pmml.commons.model.expressions.KiePMMLDiscretizeBin;
import org.kie.pmml.commons.model.expressions.KiePMMLInterval;
import org.kie.pmml.compiler.api.CommonTestingUtils;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLDiscretizeFactory;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.test.util.filesystem.FileUtils;

public class KiePMMLDiscretizeFactoryTest {
    private static final String NAME = "name";
    private static final String MAP_MISSING_TO = "mapMissingTo";
    private static final String DEFAULTVALUE = "defaultValue";
    private static final DataType dataType = DataType.INTEGER;
    private static final String TEST_01_SOURCE = "KiePMMLDiscretizeFactoryTest_01.txt";
    private static DiscretizeBin discretizeBin1;
    private static DiscretizeBin discretizeBin2;
    private static List<DiscretizeBin> discretizeBins;

    @BeforeAll
    public static void setup() {
        discretizeBin1 = KiePMMLDiscretizeFactoryTest.getDiscretizeBin(KiePMMLDiscretizeFactoryTest.getInterval(null, 20, Interval.Closure.OPEN_OPEN), "discretizeBin1");
        discretizeBin2 = KiePMMLDiscretizeFactoryTest.getDiscretizeBin(KiePMMLDiscretizeFactoryTest.getInterval(21, 30, Interval.Closure.OPEN_CLOSED), "discretizeBin2");
        discretizeBins = Arrays.asList(discretizeBin1, discretizeBin2);
    }

    @Test
    void getDiscretizeVariableDeclaration() throws IOException {
        String variableName = "variableName";
        Discretize discretize = new Discretize();
        discretize.setField(FieldName.create((String)NAME));
        discretize.setDataType(dataType);
        discretize.setMapMissingTo((Object)MAP_MISSING_TO);
        discretize.setDefaultValue((Object)DEFAULTVALUE);
        discretize.addDiscretizeBins(discretizeBins.toArray(new DiscretizeBin[0]));
        BlockStmt retrieved = KiePMMLDiscretizeFactory.getDiscretizeVariableDeclaration((String)variableName, (Discretize)discretize);
        String dataTypeString = CommonTestingUtils.getDATA_TYPEString((DataType)discretize.getDataType());
        String text = FileUtils.getFileContent((String)TEST_01_SOURCE);
        BlockStmt expected = JavaParserUtils.parseBlock((String)String.format(text, variableName, NAME, MAP_MISSING_TO, DEFAULTVALUE, dataTypeString));
        Assertions.assertThat((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved)).isTrue();
        List<Class<?>> imports = Arrays.asList(Arrays.class, Collections.class, KiePMMLDiscretize.class, KiePMMLDiscretizeBin.class, KiePMMLInterval.class);
        CodegenTestUtils.commonValidateCompilationWithImports(retrieved, imports);
    }

    private static Interval getInterval(Number leftMargin, Number rightMargin, Interval.Closure closure) {
        Interval toReturn = new Interval();
        toReturn.setLeftMargin(leftMargin);
        toReturn.setRightMargin(rightMargin);
        toReturn.setClosure(closure);
        return toReturn;
    }

    private static DiscretizeBin getDiscretizeBin(Interval interval, String binValue) {
        DiscretizeBin toReturn = new DiscretizeBin();
        toReturn.setBinValue((Object)binValue);
        toReturn.setInterval(interval);
        return toReturn;
    }
}

