/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.dmg.pmml.DataField;
import org.dmg.pmml.Interval;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.Value;
import org.junit.jupiter.api.Test;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.commons.model.KiePMMLMiningField;
import org.kie.pmml.commons.model.expressions.KiePMMLInterval;
import org.kie.pmml.compiler.api.testutils.PMMLModelTestUtils;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLMiningFieldFactory;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.test.util.filesystem.FileUtils;

public class KiePMMLMiningFieldFactoryTest {
    private static final String TEST_01_SOURCE = "KiePMMLMiningFieldFactoryTest_01.txt";
    private static final String TEST_02_SOURCE = "KiePMMLMiningFieldFactoryTest_02.txt";
    private static final String TEST_03_SOURCE = "KiePMMLMiningFieldFactoryTest_03.txt";
    private static final String VARIABLE_NAME = "variableName";

    @Test
    void getMiningFieldVariableDeclarationNoAllowedValuesNoIntervals() throws IOException {
        DataField dataField = PMMLModelTestUtils.getRandomDataField();
        dataField.getValues().clear();
        dataField.getIntervals().clear();
        MiningField miningField = new MiningField();
        miningField.setName(dataField.getName());
        miningField.setUsageType(MiningField.UsageType.TARGET);
        BlockStmt retrieved = KiePMMLMiningFieldFactory.getMiningFieldVariableDeclaration((String)VARIABLE_NAME, (MiningField)miningField, Collections.singletonList(dataField));
        String dataTypeString = DATA_TYPE.class.getName() + "." + DATA_TYPE.byName((String)dataField.getDataType().value()).name();
        String text = FileUtils.getFileContent((String)TEST_01_SOURCE);
        BlockStmt expected = JavaParserUtils.parseBlock((String)String.format(text, VARIABLE_NAME, miningField.getName().getValue(), dataTypeString));
        Assertions.assertThat((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved)).isTrue();
        List<Class<?>> imports = Arrays.asList(Arrays.class, Collections.class, KiePMMLInterval.class, KiePMMLMiningField.class, DATA_TYPE.class);
        CodegenTestUtils.commonValidateCompilationWithImports(retrieved, imports);
    }

    @Test
    void getMiningFieldVariableDeclarationWithAllowedValuesNoIntervals() throws IOException {
        DataField dataField = PMMLModelTestUtils.getRandomDataField();
        dataField.getIntervals().clear();
        MiningField miningField = new MiningField();
        miningField.setName(dataField.getName());
        miningField.setUsageType(MiningField.UsageType.TARGET);
        BlockStmt retrieved = KiePMMLMiningFieldFactory.getMiningFieldVariableDeclaration((String)VARIABLE_NAME, (MiningField)miningField, Collections.singletonList(dataField));
        String dataTypeString = DATA_TYPE.class.getName() + "." + DATA_TYPE.byName((String)dataField.getDataType().value()).name();
        String text = FileUtils.getFileContent((String)TEST_02_SOURCE);
        BlockStmt expected = JavaParserUtils.parseBlock((String)String.format(text, VARIABLE_NAME, miningField.getName().getValue(), dataTypeString, ((Value)dataField.getValues().get(0)).getValue(), ((Value)dataField.getValues().get(1)).getValue(), ((Value)dataField.getValues().get(2)).getValue()));
        Assertions.assertThat((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved)).isTrue();
        List<Class<?>> imports = Arrays.asList(Arrays.class, Collections.class, KiePMMLInterval.class, KiePMMLMiningField.class, DATA_TYPE.class);
        CodegenTestUtils.commonValidateCompilationWithImports(retrieved, imports);
    }

    @Test
    void getMiningFieldVariableDeclarationWithAllowedValuesAndIntervals() throws IOException {
        DataField dataField = PMMLModelTestUtils.getRandomDataField();
        MiningField miningField = new MiningField();
        miningField.setName(dataField.getName());
        miningField.setUsageType(MiningField.UsageType.TARGET);
        BlockStmt retrieved = KiePMMLMiningFieldFactory.getMiningFieldVariableDeclaration((String)VARIABLE_NAME, (MiningField)miningField, Collections.singletonList(dataField));
        String dataTypeString = DATA_TYPE.class.getName() + "." + DATA_TYPE.byName((String)dataField.getDataType().value()).name();
        String text = FileUtils.getFileContent((String)TEST_03_SOURCE);
        BlockStmt expected = JavaParserUtils.parseBlock((String)String.format(text, VARIABLE_NAME, miningField.getName().getValue(), dataTypeString, ((Value)dataField.getValues().get(0)).getValue(), ((Value)dataField.getValues().get(1)).getValue(), ((Value)dataField.getValues().get(2)).getValue(), ((Interval)dataField.getIntervals().get(0)).getLeftMargin(), ((Interval)dataField.getIntervals().get(0)).getRightMargin(), ((Interval)dataField.getIntervals().get(0)).getClosure().name(), ((Interval)dataField.getIntervals().get(1)).getLeftMargin(), ((Interval)dataField.getIntervals().get(1)).getRightMargin(), ((Interval)dataField.getIntervals().get(1)).getClosure().name(), ((Interval)dataField.getIntervals().get(2)).getLeftMargin(), ((Interval)dataField.getIntervals().get(2)).getRightMargin(), ((Interval)dataField.getIntervals().get(2)).getClosure().name()));
        Assertions.assertThat((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved)).isTrue();
        List<Class<?>> imports = Arrays.asList(Arrays.class, Collections.class, KiePMMLInterval.class, KiePMMLMiningField.class, DATA_TYPE.class);
        CodegenTestUtils.commonValidateCompilationWithImports(retrieved, imports);
    }
}

