/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.SimplePredicate;
import org.junit.jupiter.api.Test;
import org.kie.pmml.api.enums.OPERATOR;
import org.kie.pmml.commons.model.predicates.KiePMMLSimplePredicate;
import org.kie.pmml.compiler.api.CommonTestingUtils;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLSimplePredicateFactory;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.test.util.filesystem.FileUtils;

public class KiePMMLSimplePredicateFactoryTest {
    private static final String TEST_01_SOURCE = "KiePMMLSimplePredicateFactoryTest_01.txt";

    @Test
    void getSimplePredicateVariableDeclaration() throws IOException {
        String variableName = "variableName";
        SimplePredicate simplePredicate = new SimplePredicate();
        simplePredicate.setField(FieldName.create((String)"CUSTOM_FIELD"));
        simplePredicate.setValue((Object)"235.435");
        simplePredicate.setOperator(SimplePredicate.Operator.EQUAL);
        String operatorString = OPERATOR.class.getName() + "." + OPERATOR.byName((String)simplePredicate.getOperator().value());
        DataField dataField = new DataField();
        dataField.setName(simplePredicate.getField());
        dataField.setDataType(DataType.DOUBLE);
        DataDictionary dataDictionary = new DataDictionary();
        dataDictionary.addDataFields(new DataField[]{dataField});
        BlockStmt retrieved = KiePMMLSimplePredicateFactory.getSimplePredicateVariableDeclaration((String)variableName, (SimplePredicate)simplePredicate, (List)CommonTestingUtils.getFieldsFromDataDictionary((DataDictionary)dataDictionary));
        String text = FileUtils.getFileContent((String)TEST_01_SOURCE);
        BlockStmt expected = JavaParserUtils.parseBlock((String)String.format(text, variableName, simplePredicate.getField().getValue(), operatorString, simplePredicate.getValue()));
        Assertions.assertThat((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved)).isTrue();
        List<Class<?>> imports = Arrays.asList(KiePMMLSimplePredicate.class, Collections.class);
        CodegenTestUtils.commonValidateCompilationWithImports(retrieved, imports);
    }
}

