/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.dmg.pmml.Target;
import org.junit.jupiter.api.Test;
import org.kie.pmml.api.enums.CAST_INTEGER;
import org.kie.pmml.api.enums.OP_TYPE;
import org.kie.pmml.api.models.TargetField;
import org.kie.pmml.api.models.TargetValue;
import org.kie.pmml.commons.model.KiePMMLTarget;
import org.kie.pmml.commons.model.KiePMMLTargetValue;
import org.kie.pmml.compiler.api.testutils.PMMLModelTestUtils;
import org.kie.pmml.compiler.api.utils.ModelUtils;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLTargetFactory;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.test.util.filesystem.FileUtils;

public class KiePMMLTargetFactoryTest {
    private static final String TEST_01_SOURCE = "KiePMMLTargetFactoryTest_01.txt";

    @Test
    void getKiePMMLTargetValueVariableInitializer() throws IOException {
        TargetField kieTargetField = ModelUtils.convertToKieTargetField((Target)PMMLModelTestUtils.getRandomTarget());
        MethodCallExpr retrieved = KiePMMLTargetFactory.getKiePMMLTargetVariableInitializer((TargetField)kieTargetField);
        String text = FileUtils.getFileContent((String)TEST_01_SOURCE);
        List kieTargetValues = kieTargetField.getTargetValues();
        String opType = OP_TYPE.class.getCanonicalName() + "." + kieTargetField.getOpType().toString();
        String castInteger = CAST_INTEGER.class.getCanonicalName() + "." + kieTargetField.getCastInteger().toString();
        Expression expected = JavaParserUtils.parseExpression((String)String.format(text, kieTargetField.getName(), ((TargetValue)kieTargetValues.get(0)).getValue(), ((TargetValue)kieTargetValues.get(0)).getDisplayValue(), ((TargetValue)kieTargetValues.get(0)).getPriorProbability(), ((TargetValue)kieTargetValues.get(0)).getDefaultValue(), ((TargetValue)kieTargetValues.get(1)).getValue(), ((TargetValue)kieTargetValues.get(1)).getDisplayValue(), ((TargetValue)kieTargetValues.get(1)).getPriorProbability(), ((TargetValue)kieTargetValues.get(1)).getDefaultValue(), ((TargetValue)kieTargetValues.get(2)).getValue(), ((TargetValue)kieTargetValues.get(2)).getDisplayValue(), ((TargetValue)kieTargetValues.get(2)).getPriorProbability(), ((TargetValue)kieTargetValues.get(2)).getDefaultValue(), opType, kieTargetField.getField(), castInteger, kieTargetField.getMin(), kieTargetField.getMax(), kieTargetField.getRescaleConstant(), kieTargetField.getRescaleFactor()));
        Assertions.assertThat((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved)).isTrue();
        List<Class<?>> imports = Arrays.asList(Arrays.class, Collections.class, KiePMMLTarget.class, KiePMMLTargetValue.class, TargetField.class, TargetValue.class);
        CodegenTestUtils.commonValidateCompilationWithImports((Expression)retrieved, imports);
    }
}

