/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.factories;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.dmg.pmml.LocalTransformations;
import org.junit.jupiter.api.Test;
import org.kie.pmml.commons.transformations.KiePMMLDerivedField;
import org.kie.pmml.commons.transformations.KiePMMLLocalTransformations;
import org.kie.pmml.compiler.api.testutils.PMMLModelTestUtils;
import org.kie.pmml.compiler.commons.factories.InstanceFactoriesTestCommon;
import org.kie.pmml.compiler.commons.factories.KiePMMLLocalTransformationsInstanceFactory;

public class KiePMMLLocalTransformationsInstanceFactoryTest {
    @Test
    void getKiePMMLLocalTransformations() {
        LocalTransformations toConvert = PMMLModelTestUtils.getRandomLocalTransformations();
        KiePMMLLocalTransformations retrieved = KiePMMLLocalTransformationsInstanceFactory.getKiePMMLLocalTransformations((LocalTransformations)toConvert, Collections.emptyList());
        Assertions.assertThat((Object)retrieved).isNotNull();
        List derivedFields = toConvert.getDerivedFields();
        List derivedFieldsToVerify = retrieved.getDerivedFields();
        Assertions.assertThat((List)derivedFieldsToVerify).hasSameSizeAs((Iterable)derivedFields);
        derivedFields.forEach(derivedFieldSource -> {
            Optional<KiePMMLDerivedField> derivedFieldToVerify = derivedFieldsToVerify.stream().filter(param -> param.getName().equals(derivedFieldSource.getName().getValue())).findFirst();
            Assertions.assertThat(derivedFieldToVerify).isPresent();
            InstanceFactoriesTestCommon.commonVerifyKiePMMLDerivedField(derivedFieldToVerify.get(), derivedFieldSource);
        });
    }
}

