/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.clustering.model;

import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.junit.Test;
import org.kie.pmml.api.utils.EnumUtils;
import org.kie.pmml.models.clustering.model.KiePMMLClusteringField;
import org.kie.pmml.models.clustering.model.KiePMMLCompareFunction;

public class KiePMMLCompareFunctionTest {
    private static final Offset<Double> DOUBLE_OFFSET = Offset.offset((Number)1.0E-9);
    private static final double TEST_X = 2.0;
    private static final double TEST_Y = 1.0;
    private static final double TEST_SIMILARITY_SCALE = 1.0;
    private static final KiePMMLClusteringField TEST_FIELD = new KiePMMLClusteringField("test", Double.valueOf(1.0), Boolean.valueOf(true), KiePMMLCompareFunction.ABS_DIFF, Double.valueOf(1.0));

    @Test
    public void testNames() {
        Assertions.assertThat((Comparable)((KiePMMLCompareFunction)EnumUtils.enumByName(KiePMMLCompareFunction.class, (String)"absDiff"))).isEqualTo((Object)KiePMMLCompareFunction.ABS_DIFF);
        Assertions.assertThat((Comparable)((KiePMMLCompareFunction)EnumUtils.enumByName(KiePMMLCompareFunction.class, (String)"gaussSim"))).isEqualTo((Object)KiePMMLCompareFunction.GAUSS_SIM);
        Assertions.assertThat((Comparable)((KiePMMLCompareFunction)EnumUtils.enumByName(KiePMMLCompareFunction.class, (String)"delta"))).isEqualTo((Object)KiePMMLCompareFunction.DELTA);
        Assertions.assertThat((Comparable)((KiePMMLCompareFunction)EnumUtils.enumByName(KiePMMLCompareFunction.class, (String)"equal"))).isEqualTo((Object)KiePMMLCompareFunction.EQUAL);
        Assertions.assertThat((Comparable)((KiePMMLCompareFunction)EnumUtils.enumByName(KiePMMLCompareFunction.class, (String)"table"))).isEqualTo((Object)KiePMMLCompareFunction.TABLE);
    }

    @Test
    public void testApply() {
        Assertions.assertThat((double)KiePMMLCompareFunction.ABS_DIFF.apply(TEST_FIELD, 2.0, 1.0)).isEqualTo(KiePMMLCompareFunction.absDiff((double)2.0, (double)1.0), DOUBLE_OFFSET);
        Assertions.assertThat((double)KiePMMLCompareFunction.GAUSS_SIM.apply(TEST_FIELD, 2.0, 1.0)).isEqualTo(KiePMMLCompareFunction.gaussSim((double)2.0, (double)1.0, (double)1.0), DOUBLE_OFFSET);
        Assertions.assertThat((double)KiePMMLCompareFunction.DELTA.apply(TEST_FIELD, 2.0, 1.0)).isEqualTo(KiePMMLCompareFunction.delta((double)2.0, (double)1.0), DOUBLE_OFFSET);
        Assertions.assertThat((double)KiePMMLCompareFunction.EQUAL.apply(TEST_FIELD, 2.0, 1.0)).isEqualTo(KiePMMLCompareFunction.equal((double)2.0, (double)1.0), DOUBLE_OFFSET);
        Assertions.assertThatThrownBy(() -> KiePMMLCompareFunction.TABLE.apply(TEST_FIELD, 2.0, 1.0)).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    public void testAbsDiff() {
        Assertions.assertThat((double)KiePMMLCompareFunction.absDiff((double)10.0, (double)25.0)).isEqualTo(15.0, DOUBLE_OFFSET);
        Assertions.assertThat((double)KiePMMLCompareFunction.absDiff((double)25.0, (double)10.0)).isEqualTo(15.0, DOUBLE_OFFSET);
    }

    @Test
    public void testGaussSim() {
        Assertions.assertThat((double)KiePMMLCompareFunction.gaussSim((double)4.0, (double)2.0, (double)1.0)).isEqualTo(0.0625, DOUBLE_OFFSET);
        Assertions.assertThat((double)KiePMMLCompareFunction.gaussSim((double)3.0, (double)2.0, (double)Math.sqrt(2.0))).isEqualTo(1.0 / Math.sqrt(2.0), DOUBLE_OFFSET);
    }

    @Test
    public void testDelta() {
        Assertions.assertThat((double)KiePMMLCompareFunction.delta((double)10.0, (double)25.0)).isEqualTo(1.0, DOUBLE_OFFSET);
        Assertions.assertThat((double)KiePMMLCompareFunction.delta((double)25.0, (double)10.0)).isEqualTo(1.0, DOUBLE_OFFSET);
        Assertions.assertThat((double)KiePMMLCompareFunction.delta((double)10.0, (double)10.0)).isEqualTo(0.0, DOUBLE_OFFSET);
    }

    @Test
    public void testEqual() {
        Assertions.assertThat((double)KiePMMLCompareFunction.equal((double)10.0, (double)25.0)).isEqualTo(0.0, DOUBLE_OFFSET);
        Assertions.assertThat((double)KiePMMLCompareFunction.equal((double)25.0, (double)10.0)).isEqualTo(0.0, DOUBLE_OFFSET);
        Assertions.assertThat((double)KiePMMLCompareFunction.equal((double)10.0, (double)10.0)).isEqualTo(1.0, DOUBLE_OFFSET);
    }
}

