/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.drools.core.command.impl.CommandFactoryServiceImpl;
import org.kie.api.KieBase;
import org.kie.api.command.BatchExecutionCommand;
import org.kie.api.command.Command;
import org.kie.api.definition.type.FactType;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.pmml.PMML4Result;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.pmml.commons.exceptions.KiePMMLException;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.evaluator.api.exceptions.KiePMMLModelException;
import org.kie.pmml.models.drools.executor.KiePMMLStatusHolder;
import org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLSessionUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLSessionUtils.class.getName());
    private static final CommandFactoryServiceImpl COMMAND_FACTORY_SERVICE = new CommandFactoryServiceImpl();
    private final StatelessKieSession kieSession;
    private final String modelName;
    private final String packageName;
    private final List<Command> commands;

    private KiePMMLSessionUtils(KieBase knowledgeBase, String modelName, PMML4Result pmml4Result) {
        this.modelName = modelName;
        this.packageName = KiePMMLModelUtils.getSanitizedPackageName((String)modelName);
        this.kieSession = this.getKieSession(knowledgeBase);
        this.commands = new ArrayList<Command>();
        this.commands.add(COMMAND_FACTORY_SERVICE.newInsert((Object)new KiePMMLStatusHolder()));
        this.commands.add(COMMAND_FACTORY_SERVICE.newInsert((Object)pmml4Result));
        this.commands.add(COMMAND_FACTORY_SERVICE.newSetGlobal("$pmml4Result", (Object)pmml4Result));
    }

    public static Builder builder(KieBase knowledgeBase, String modelName, PMML4Result pmml4Result) {
        return new Builder(knowledgeBase, modelName, pmml4Result);
    }

    private StatelessKieSession getKieSession(KieBase knowledgeBase) {
        try {
            StatelessKieSession toReturn = knowledgeBase.newStatelessKieSession();
            if (toReturn == null) {
                throw new KiePMMLException("Failed to create KieSession for model " + this.modelName);
            }
            return toReturn;
        }
        catch (Throwable t) {
            throw new KiePMMLException("Failed to create KieSession for model " + this.modelName, t);
        }
    }

    public void fireAllRules() {
        BatchExecutionCommand batchExecutionCommand = COMMAND_FACTORY_SERVICE.newBatchExecution(this.commands);
        this.kieSession.execute((Command)batchExecutionCommand);
    }

    private void addObjectsToSession(Map<String, Object> unwrappedInputParams, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap) {
        for (Map.Entry<String, Object> entry : unwrappedInputParams.entrySet()) {
            if (!fieldTypeMap.containsKey(entry.getKey())) {
                throw new KiePMMLModelException(String.format("Field %s not mapped to generated type", entry.getKey()));
            }
            try {
                String generatedTypeName = fieldTypeMap.get(entry.getKey()).getGeneratedType();
                FactType factType = this.kieSession.getKieBase().getFactType(this.packageName, generatedTypeName);
                Object toAdd = factType.newInstance();
                factType.set(toAdd, "value", entry.getValue());
                this.commands.add(COMMAND_FACTORY_SERVICE.newInsert(toAdd));
            }
            catch (Exception e) {
                throw new KiePMMLModelException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void insertObjectInSession(Object toInsert, String globalName) {
        this.commands.add(COMMAND_FACTORY_SERVICE.newInsert(toInsert));
        this.commands.add(COMMAND_FACTORY_SERVICE.newSetGlobal(globalName, toInsert));
    }

    public static class Builder {
        private KiePMMLSessionUtils toBuild;

        private Builder(KieBase knowledgeBase, String modelName, PMML4Result pmml4Result) {
            this.toBuild = new KiePMMLSessionUtils(knowledgeBase, modelName, pmml4Result);
        }

        public Builder withAgendaEventListener(AgendaEventListener agendaEventListener) {
            this.toBuild.kieSession.addEventListener(agendaEventListener);
            return this;
        }

        public Builder withObjectsInSession(Map<String, Object> unwrappedInputParams, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap) {
            this.toBuild.addObjectsToSession(unwrappedInputParams, fieldTypeMap);
            return this;
        }

        public Builder withOutputFieldsMap(Map<String, Object> outputFieldsMap) {
            this.toBuild.insertObjectInSession(outputFieldsMap, "$outputFieldsMap");
            return this;
        }

        public KiePMMLSessionUtils build() {
            return this.toBuild;
        }
    }
}

