/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.ast.factories;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Array;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.commons.enums.ResultCode;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsRule;
import org.kie.pmml.models.drools.ast.factories.KiePMMLSimpleSetPredicateASTFactory;
import org.kie.pmml.models.drools.ast.factories.PredicateASTFactoryData;
import org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType;
import org.kie.pmml.models.drools.utils.KiePMMLASTTestUtils;

public class KiePMMLSimpleSetPredicateASTFactoryTest {
    @Test
    public void declareRuleFromSimpleSetPredicateIsInFinalLeaf() {
        HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
        List<String> values = Arrays.asList("-5", "0.5", "1", "10");
        SimpleSetPredicate simpleSetPredicate = KiePMMLASTTestUtils.getSimpleSetPredicate("input1", Array.Type.REAL, values, SimpleSetPredicate.BooleanOperator.IS_IN, fieldTypeMap);
        String parentPath = "_classA";
        String currentRule = "_classA_classB";
        String result = "classB";
        String declaredType = ((KiePMMLOriginalTypeGeneratedType)fieldTypeMap.get("input1")).getGeneratedType();
        ArrayList<KiePMMLDroolsRule> rules = new ArrayList<KiePMMLDroolsRule>();
        PredicateASTFactoryData predicateASTFactoryData = KiePMMLASTTestUtils.getPredicateASTFactoryData((Predicate)simpleSetPredicate, Collections.emptyList(), rules, parentPath, currentRule, fieldTypeMap);
        KiePMMLSimpleSetPredicateASTFactory.factory((PredicateASTFactoryData)predicateASTFactoryData).declareRuleFromSimpleSetPredicate((Object)result, true);
        Assert.assertEquals((long)1L, (long)rules.size());
        KiePMMLDroolsRule retrieved = (KiePMMLDroolsRule)rules.get(0);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)currentRule, (Object)retrieved.getName());
        Assert.assertEquals((Object)"DONE", (Object)retrieved.getStatusToSet());
        Assert.assertEquals((Object)String.format("status == \"%s\"", parentPath), (Object)retrieved.getStatusConstraint());
        Assert.assertEquals((Object)ResultCode.OK, (Object)retrieved.getResultCode());
        Assert.assertEquals((Object)result, (Object)retrieved.getResult());
        Assert.assertNotNull((Object)retrieved.getInConstraints());
        Map inConstraints = retrieved.getInConstraints();
        Assert.assertEquals((long)1L, (long)inConstraints.size());
        Assert.assertTrue((boolean)inConstraints.containsKey(declaredType));
        List retrievedValues = (List)inConstraints.get(declaredType);
        List<String> originalPredicateValues = Arrays.asList(((String)simpleSetPredicate.getArray().getValue()).split(" "));
        Assert.assertEquals((long)originalPredicateValues.size(), (long)retrievedValues.size());
        retrievedValues.forEach(retrievedValue -> Assert.assertTrue((boolean)originalPredicateValues.contains(retrievedValue)));
    }

    @Test
    public void declareRuleFromSimpleSetPredicateIsInNotFinalLeaf() {
        HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
        List<String> values = Arrays.asList("-5", "0.5", "1", "10");
        SimpleSetPredicate simpleSetPredicate = KiePMMLASTTestUtils.getSimpleSetPredicate("input1", Array.Type.REAL, values, SimpleSetPredicate.BooleanOperator.IS_IN, fieldTypeMap);
        String parentPath = "_classA";
        String currentRule = "_classA_classB";
        String result = "classB";
        String declaredType = ((KiePMMLOriginalTypeGeneratedType)fieldTypeMap.get("input1")).getGeneratedType();
        ArrayList<KiePMMLDroolsRule> rules = new ArrayList<KiePMMLDroolsRule>();
        PredicateASTFactoryData predicateASTFactoryData = KiePMMLASTTestUtils.getPredicateASTFactoryData((Predicate)simpleSetPredicate, Collections.emptyList(), rules, parentPath, currentRule, fieldTypeMap);
        KiePMMLSimpleSetPredicateASTFactory.factory((PredicateASTFactoryData)predicateASTFactoryData).declareRuleFromSimpleSetPredicate((Object)result, false);
        Assert.assertEquals((long)1L, (long)rules.size());
        KiePMMLDroolsRule retrieved = (KiePMMLDroolsRule)rules.get(0);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)currentRule, (Object)retrieved.getName());
        Assert.assertEquals((Object)currentRule, (Object)retrieved.getStatusToSet());
        Assert.assertEquals((Object)String.format("status == \"%s\"", parentPath), (Object)retrieved.getStatusConstraint());
        Assert.assertNull((Object)retrieved.getResultCode());
        Assert.assertNull((Object)retrieved.getResult());
        Assert.assertNotNull((Object)retrieved.getInConstraints());
        Map inConstraints = retrieved.getInConstraints();
        Assert.assertEquals((long)1L, (long)inConstraints.size());
        Assert.assertTrue((boolean)inConstraints.containsKey(declaredType));
        List retrievedValues = (List)inConstraints.get(declaredType);
        List<String> originalPredicateValues = Arrays.asList(((String)simpleSetPredicate.getArray().getValue()).split(" "));
        Assert.assertEquals((long)originalPredicateValues.size(), (long)retrievedValues.size());
        retrievedValues.forEach(retrievedValue -> Assert.assertTrue((boolean)originalPredicateValues.contains(retrievedValue)));
    }

    @Test
    public void declareRuleFromSimpleSetPredicateIsNotInFinalLeaf() {
        HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
        List<String> values = Arrays.asList("3", "8.5");
        SimpleSetPredicate simpleSetPredicate = KiePMMLASTTestUtils.getSimpleSetPredicate("input2", Array.Type.REAL, values, SimpleSetPredicate.BooleanOperator.IS_NOT_IN, fieldTypeMap);
        String parentPath = "_classA";
        String currentRule = "_classA_classC";
        String result = "classC";
        String declaredType = ((KiePMMLOriginalTypeGeneratedType)fieldTypeMap.get("input2")).getGeneratedType();
        ArrayList<KiePMMLDroolsRule> rules = new ArrayList<KiePMMLDroolsRule>();
        String statusToSet = "DONE";
        PredicateASTFactoryData predicateASTFactoryData = KiePMMLASTTestUtils.getPredicateASTFactoryData((Predicate)simpleSetPredicate, Collections.emptyList(), rules, parentPath, currentRule, fieldTypeMap);
        KiePMMLSimpleSetPredicateASTFactory.factory((PredicateASTFactoryData)predicateASTFactoryData).declareRuleFromSimpleSetPredicate((Object)result, true);
        Assert.assertEquals((long)1L, (long)rules.size());
        KiePMMLDroolsRule retrieved = (KiePMMLDroolsRule)rules.get(0);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)currentRule, (Object)retrieved.getName());
        Assert.assertEquals((Object)statusToSet, (Object)retrieved.getStatusToSet());
        Assert.assertEquals((Object)String.format("status == \"%s\"", parentPath), (Object)retrieved.getStatusConstraint());
        Assert.assertEquals((Object)ResultCode.OK, (Object)retrieved.getResultCode());
        Assert.assertEquals((Object)result, (Object)retrieved.getResult());
        Assert.assertNotNull((Object)retrieved.getNotInConstraints());
        Map notInConstraints = retrieved.getNotInConstraints();
        Assert.assertEquals((long)1L, (long)notInConstraints.size());
        Assert.assertTrue((boolean)notInConstraints.containsKey(declaredType));
        List retrievedValues = (List)notInConstraints.get(declaredType);
        List<String> originalPredicateValues = Arrays.asList(((String)simpleSetPredicate.getArray().getValue()).split(" "));
        Assert.assertEquals((long)originalPredicateValues.size(), (long)retrievedValues.size());
        retrievedValues.forEach(retrievedValue -> Assert.assertTrue((boolean)originalPredicateValues.contains(retrievedValue)));
    }

    @Test
    public void declareRuleFromSimpleSetPredicateIsNotInNotFinalLeaf() {
        HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
        List<String> values = Arrays.asList("3", "8.5");
        SimpleSetPredicate simpleSetPredicate = KiePMMLASTTestUtils.getSimpleSetPredicate("input2", Array.Type.REAL, values, SimpleSetPredicate.BooleanOperator.IS_NOT_IN, fieldTypeMap);
        String parentPath = "_classA";
        String currentRule = "_classA_classC";
        String result = "classC";
        String declaredType = ((KiePMMLOriginalTypeGeneratedType)fieldTypeMap.get("input2")).getGeneratedType();
        ArrayList<KiePMMLDroolsRule> rules = new ArrayList<KiePMMLDroolsRule>();
        PredicateASTFactoryData predicateASTFactoryData = KiePMMLASTTestUtils.getPredicateASTFactoryData((Predicate)simpleSetPredicate, Collections.emptyList(), rules, parentPath, currentRule, fieldTypeMap);
        KiePMMLSimpleSetPredicateASTFactory.factory((PredicateASTFactoryData)predicateASTFactoryData).declareRuleFromSimpleSetPredicate((Object)result, false);
        Assert.assertEquals((long)1L, (long)rules.size());
        KiePMMLDroolsRule retrieved = (KiePMMLDroolsRule)rules.get(0);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)currentRule, (Object)retrieved.getName());
        Assert.assertEquals((Object)currentRule, (Object)retrieved.getStatusToSet());
        Assert.assertEquals((Object)String.format("status == \"%s\"", parentPath), (Object)retrieved.getStatusConstraint());
        Assert.assertNull((Object)retrieved.getResultCode());
        Assert.assertNull((Object)retrieved.getResult());
        Assert.assertNotNull((Object)retrieved.getNotInConstraints());
        Map notInConstraints = retrieved.getNotInConstraints();
        Assert.assertEquals((long)1L, (long)notInConstraints.size());
        Assert.assertTrue((boolean)notInConstraints.containsKey(declaredType));
        List retrievedValues = (List)notInConstraints.get(declaredType);
        List<String> originalPredicateValues = Arrays.asList(((String)simpleSetPredicate.getArray().getValue()).split(" "));
        Assert.assertEquals((long)originalPredicateValues.size(), (long)retrievedValues.size());
        retrievedValues.forEach(retrievedValue -> Assert.assertTrue((boolean)originalPredicateValues.contains(retrievedValue)));
    }
}

