/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Array;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.TransformationDictionary;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsRule;
import org.kie.pmml.models.drools.ast.factories.KiePMMLDataDictionaryASTFactory;
import org.kie.pmml.models.drools.ast.factories.KiePMMLDerivedFieldASTFactory;
import org.kie.pmml.models.drools.ast.factories.PredicateASTFactoryData;
import org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType;

public class KiePMMLASTTestUtils {
    public static PredicateASTFactoryData getPredicateASTFactoryData(Predicate predicate, List<KiePMMLOutputField> outputFields, List<KiePMMLDroolsRule> rules, String parentPath, String currentRule, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap) {
        return new PredicateASTFactoryData(predicate, outputFields, rules, parentPath, currentRule, fieldTypeMap);
    }

    public static Map<String, KiePMMLOriginalTypeGeneratedType> getFieldTypeMap(DataDictionary dataDictionary, TransformationDictionary transformationDictionary, LocalTransformations localTransformations) {
        HashMap<String, KiePMMLOriginalTypeGeneratedType> toReturn = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
        KiePMMLDerivedFieldASTFactory kiePMMLDerivedFieldASTFactory = KiePMMLDerivedFieldASTFactory.factory(toReturn);
        if (transformationDictionary != null && transformationDictionary.getDerivedFields() != null) {
            kiePMMLDerivedFieldASTFactory.declareTypes(transformationDictionary.getDerivedFields());
        }
        if (localTransformations != null && localTransformations.getDerivedFields() != null) {
            kiePMMLDerivedFieldASTFactory.declareTypes(localTransformations.getDerivedFields());
        }
        KiePMMLDataDictionaryASTFactory.factory(toReturn).declareTypes(dataDictionary);
        return toReturn;
    }

    public static DataField getTypeDataField() {
        DataField toReturn = new DataField();
        toReturn.setOpType(OpType.CONTINUOUS);
        toReturn.setDataType(DataType.DATE);
        toReturn.setName(FieldName.create((String)"dataField"));
        return toReturn;
    }

    public static DataField getDottedTypeDataField() {
        DataField toReturn = new DataField();
        toReturn.setOpType(OpType.CONTINUOUS);
        toReturn.setDataType(DataType.BOOLEAN);
        toReturn.setName(FieldName.create((String)"dotted.field"));
        return toReturn;
    }

    public static SimplePredicate getSimplePredicate(String predicateName, DataType dataType, Object value, SimplePredicate.Operator operator, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap) {
        FieldName fieldName = FieldName.create((String)predicateName);
        fieldTypeMap.put(fieldName.getValue(), new KiePMMLOriginalTypeGeneratedType(dataType.value(), KiePMMLModelUtils.getSanitizedClassName((String)fieldName.getValue().toUpperCase())));
        SimplePredicate toReturn = new SimplePredicate();
        toReturn.setField(fieldName);
        toReturn.setOperator(operator);
        toReturn.setValue(value);
        return toReturn;
    }

    public static SimpleSetPredicate getSimpleSetPredicate(String predicateName, Array.Type arrayType, List<String> values, SimpleSetPredicate.BooleanOperator booleanOperator, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap) {
        FieldName fieldName = FieldName.create((String)predicateName);
        fieldTypeMap.put(fieldName.getValue(), new KiePMMLOriginalTypeGeneratedType(arrayType.value(), KiePMMLModelUtils.getSanitizedClassName((String)fieldName.getValue().toUpperCase())));
        SimpleSetPredicate toReturn = new SimpleSetPredicate();
        toReturn.setField(fieldName);
        toReturn.setBooleanOperator(booleanOperator);
        String arrayString = String.join((CharSequence)" ", values);
        Array array = new Array(arrayType, (Object)arrayString);
        array.setN(Integer.valueOf(values.size()));
        toReturn.setArray(array);
        return toReturn;
    }
}

