/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.commons.factories;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.drools.compiler.lang.api.CEDescrBuilder;
import org.drools.compiler.lang.api.DescrFactory;
import org.drools.compiler.lang.api.PackageDescrBuilder;
import org.drools.compiler.lang.api.RuleDescrBuilder;
import org.drools.compiler.lang.descr.AndDescr;
import org.drools.compiler.lang.descr.ConditionalBranchDescr;
import org.drools.compiler.lang.descr.ExistsDescr;
import org.drools.compiler.lang.descr.ExprConstraintDescr;
import org.drools.compiler.lang.descr.NotDescr;
import org.drools.compiler.lang.descr.OrDescr;
import org.drools.compiler.lang.descr.PatternDescr;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.pmml.commons.exceptions.KiePMMLException;
import org.kie.pmml.commons.model.enums.BOOLEAN_OPERATOR;
import org.kie.pmml.commons.model.enums.OPERATOR;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsRule;
import org.kie.pmml.models.drools.ast.KiePMMLFieldOperatorValue;
import org.kie.pmml.models.drools.commons.factories.KiePMMLDescrLhsFactory;
import org.kie.pmml.models.drools.executor.KiePMMLStatusHolder;
import org.kie.pmml.models.drools.tuples.KiePMMLOperatorValue;

public class KiePMMLDescrLhsFactoryTest {
    private static final String PACKAGE_NAME = "package";
    private static final String CURRENT_RULE = "currentRule";
    private CEDescrBuilder<RuleDescrBuilder, AndDescr> lhsBuilder;

    @Before
    public void setUp() throws Exception {
        PackageDescrBuilder builder = DescrFactory.newPackage().name(PACKAGE_NAME);
        RuleDescrBuilder ruleBuilder = builder.newRule().name(CURRENT_RULE);
        this.lhsBuilder = ruleBuilder.lhs();
    }

    @Test
    public void declareLhs() {
        String name = "NAME";
        String statusToSet = "STATUS_TO_SET";
        KiePMMLDroolsRule rule = KiePMMLDroolsRule.builder((String)name, (String)statusToSet, Collections.emptyList()).build();
        KiePMMLDescrLhsFactory.factory(this.lhsBuilder).declareLhs(rule);
        Assert.assertNotNull((Object)this.lhsBuilder.getDescr());
        Assert.assertNotNull((Object)((AndDescr)this.lhsBuilder.getDescr()).getDescrs());
        Assert.assertEquals((long)1L, (long)((AndDescr)this.lhsBuilder.getDescr()).getDescrs().size());
        Assert.assertTrue((boolean)(((AndDescr)this.lhsBuilder.getDescr()).getDescrs().get(0) instanceof PatternDescr));
        PatternDescr patternDescr = (PatternDescr)((AndDescr)this.lhsBuilder.getDescr()).getDescrs().get(0);
        Assert.assertEquals((Object)KiePMMLStatusHolder.class.getSimpleName(), (Object)patternDescr.getObjectType());
        Assert.assertEquals((Object)"$statusHolder", (Object)patternDescr.getIdentifier());
        Assert.assertTrue((boolean)(patternDescr.getConstraint() instanceof AndDescr));
        AndDescr andDescr = (AndDescr)patternDescr.getConstraint();
        Assert.assertTrue((boolean)andDescr.getDescrs().isEmpty());
    }

    @Test
    public void declareConstraintAnd() {
        String temperatureField = "TEMPERATURE";
        String humidityField = "HUMIDITY";
        List<KiePMMLFieldOperatorValue> kiePMMLOperatorValues = Arrays.asList(new KiePMMLFieldOperatorValue(temperatureField, BOOLEAN_OPERATOR.AND, Collections.singletonList(new KiePMMLOperatorValue(OPERATOR.LESS_THAN, (Object)35)), null), new KiePMMLFieldOperatorValue(humidityField, BOOLEAN_OPERATOR.OR, Collections.singletonList(new KiePMMLOperatorValue(OPERATOR.GREATER_THAN, (Object)85)), null));
        KiePMMLDescrLhsFactory.factory(this.lhsBuilder).declareConstraintsAndOr(kiePMMLOperatorValues, this.lhsBuilder.and());
        Assert.assertNotNull((Object)this.lhsBuilder.getDescr());
        Assert.assertEquals((long)1L, (long)((AndDescr)this.lhsBuilder.getDescr()).getDescrs().size());
        Assert.assertTrue((boolean)(((AndDescr)this.lhsBuilder.getDescr()).getDescrs().get(0) instanceof AndDescr));
        AndDescr baseAndDescr = (AndDescr)((AndDescr)this.lhsBuilder.getDescr()).getDescrs().get(0);
        List descrs = baseAndDescr.getDescrs();
        Assert.assertNotNull((Object)descrs);
        Assert.assertEquals((long)2L, (long)descrs.size());
        Assert.assertTrue((boolean)(descrs.get(0) instanceof PatternDescr));
        PatternDescr patternDescr = (PatternDescr)descrs.get(0);
        Assert.assertEquals((Object)temperatureField, (Object)patternDescr.getObjectType());
        Assert.assertNull((Object)patternDescr.getIdentifier());
        Assert.assertTrue((boolean)(patternDescr.getConstraint() instanceof AndDescr));
        AndDescr andDescr = (AndDescr)patternDescr.getConstraint();
        Assert.assertEquals((long)1L, (long)andDescr.getDescrs().size());
        Assert.assertTrue((boolean)(andDescr.getDescrs().get(0) instanceof ExprConstraintDescr));
        ExprConstraintDescr exprConstraintDescr = (ExprConstraintDescr)andDescr.getDescrs().get(0);
        Assert.assertFalse((boolean)exprConstraintDescr.isNegated());
        Assert.assertEquals((Object)ExprConstraintDescr.Type.NAMED, (Object)exprConstraintDescr.getType());
        String expected = "value < 35";
        Assert.assertEquals((Object)expected, (Object)exprConstraintDescr.getExpression());
        Assert.assertTrue((boolean)(descrs.get(1) instanceof PatternDescr));
        patternDescr = (PatternDescr)descrs.get(1);
        Assert.assertEquals((Object)humidityField, (Object)patternDescr.getObjectType());
        Assert.assertNull((Object)patternDescr.getIdentifier());
        Assert.assertTrue((boolean)(patternDescr.getConstraint() instanceof AndDescr));
        andDescr = (AndDescr)patternDescr.getConstraint();
        Assert.assertEquals((long)1L, (long)andDescr.getDescrs().size());
        Assert.assertTrue((boolean)(andDescr.getDescrs().get(0) instanceof ExprConstraintDescr));
        exprConstraintDescr = (ExprConstraintDescr)andDescr.getDescrs().get(0);
        Assert.assertFalse((boolean)exprConstraintDescr.isNegated());
        Assert.assertEquals((Object)ExprConstraintDescr.Type.NAMED, (Object)exprConstraintDescr.getType());
        expected = "value > 85";
        Assert.assertEquals((Object)expected, (Object)exprConstraintDescr.getExpression());
    }

    @Test
    public void declareNestedConstraintAnd() {
        String temperatureField = "TEMPERATURE";
        String humidityField = "HUMIDITY";
        List<KiePMMLFieldOperatorValue> nestedKiePMMLFieldOperatorValues = Arrays.asList(new KiePMMLFieldOperatorValue(humidityField, BOOLEAN_OPERATOR.OR, Collections.singletonList(new KiePMMLOperatorValue(OPERATOR.LESS_THAN, (Object)56)), null), new KiePMMLFieldOperatorValue(humidityField, BOOLEAN_OPERATOR.OR, Collections.singletonList(new KiePMMLOperatorValue(OPERATOR.GREATER_THAN, (Object)91)), null));
        List<KiePMMLFieldOperatorValue> kiePMMLOperatorValues = Collections.singletonList(new KiePMMLFieldOperatorValue(temperatureField, BOOLEAN_OPERATOR.AND, Collections.singletonList(new KiePMMLOperatorValue(OPERATOR.LESS_THAN, (Object)35)), nestedKiePMMLFieldOperatorValues));
        KiePMMLDescrLhsFactory.factory(this.lhsBuilder).declareConstraintsAndOr(kiePMMLOperatorValues, this.lhsBuilder.and());
        Assert.assertNotNull((Object)this.lhsBuilder.getDescr());
        Assert.assertEquals((long)1L, (long)((AndDescr)this.lhsBuilder.getDescr()).getDescrs().size());
        Assert.assertTrue((boolean)(((AndDescr)this.lhsBuilder.getDescr()).getDescrs().get(0) instanceof AndDescr));
        AndDescr baseAndDescr = (AndDescr)((AndDescr)this.lhsBuilder.getDescr()).getDescrs().get(0);
        List descrs = baseAndDescr.getDescrs();
        Assert.assertNotNull((Object)descrs);
        Assert.assertEquals((long)2L, (long)descrs.size());
        Assert.assertTrue((boolean)(descrs.get(0) instanceof PatternDescr));
        PatternDescr patternDescr = (PatternDescr)descrs.get(0);
        Assert.assertEquals((Object)temperatureField, (Object)patternDescr.getObjectType());
        Assert.assertNull((Object)patternDescr.getIdentifier());
        Assert.assertTrue((boolean)(patternDescr.getConstraint() instanceof AndDescr));
        AndDescr andDescr = (AndDescr)patternDescr.getConstraint();
        Assert.assertEquals((long)1L, (long)andDescr.getDescrs().size());
        Assert.assertTrue((boolean)(andDescr.getDescrs().get(0) instanceof ExprConstraintDescr));
        ExprConstraintDescr exprConstraintDescr = (ExprConstraintDescr)andDescr.getDescrs().get(0);
        Assert.assertFalse((boolean)exprConstraintDescr.isNegated());
        Assert.assertEquals((Object)ExprConstraintDescr.Type.NAMED, (Object)exprConstraintDescr.getType());
        String expected = "value < 35";
        Assert.assertEquals((Object)expected, (Object)exprConstraintDescr.getExpression());
        Assert.assertTrue((boolean)(descrs.get(1) instanceof AndDescr));
        AndDescr nestedAndDescr = (AndDescr)descrs.get(1);
        Assert.assertEquals((long)2L, (long)nestedAndDescr.getDescrs().size());
        List nestedDescrs = nestedAndDescr.getDescrs();
        Assert.assertTrue((boolean)(nestedDescrs.get(0) instanceof PatternDescr));
        patternDescr = (PatternDescr)nestedDescrs.get(0);
        Assert.assertEquals((Object)humidityField, (Object)patternDescr.getObjectType());
        Assert.assertNull((Object)patternDescr.getIdentifier());
        Assert.assertTrue((boolean)(patternDescr.getConstraint() instanceof AndDescr));
        andDescr = (AndDescr)patternDescr.getConstraint();
        Assert.assertEquals((long)1L, (long)andDescr.getDescrs().size());
        Assert.assertTrue((boolean)(andDescr.getDescrs().get(0) instanceof ExprConstraintDescr));
        exprConstraintDescr = (ExprConstraintDescr)andDescr.getDescrs().get(0);
        Assert.assertFalse((boolean)exprConstraintDescr.isNegated());
        Assert.assertEquals((Object)ExprConstraintDescr.Type.NAMED, (Object)exprConstraintDescr.getType());
        expected = "value < 56";
        Assert.assertEquals((Object)expected, (Object)exprConstraintDescr.getExpression());
        Assert.assertTrue((boolean)(nestedDescrs.get(1) instanceof PatternDescr));
        patternDescr = (PatternDescr)nestedDescrs.get(1);
        Assert.assertEquals((Object)humidityField, (Object)patternDescr.getObjectType());
        Assert.assertNull((Object)patternDescr.getIdentifier());
        Assert.assertTrue((boolean)(patternDescr.getConstraint() instanceof AndDescr));
        andDescr = (AndDescr)patternDescr.getConstraint();
        Assert.assertEquals((long)1L, (long)andDescr.getDescrs().size());
        Assert.assertTrue((boolean)(andDescr.getDescrs().get(0) instanceof ExprConstraintDescr));
        exprConstraintDescr = (ExprConstraintDescr)andDescr.getDescrs().get(0);
        Assert.assertFalse((boolean)exprConstraintDescr.isNegated());
        Assert.assertEquals((Object)ExprConstraintDescr.Type.NAMED, (Object)exprConstraintDescr.getType());
        expected = "value > 91";
        Assert.assertEquals((Object)expected, (Object)exprConstraintDescr.getExpression());
    }

    @Test
    public void declareConstraintsOr() {
        String temperatureField = "TEMPERATURE";
        String humidityField = "HUMIDITY";
        List<KiePMMLFieldOperatorValue> kiePMMLOperatorValues = Arrays.asList(new KiePMMLFieldOperatorValue(temperatureField, BOOLEAN_OPERATOR.AND, Collections.singletonList(new KiePMMLOperatorValue(OPERATOR.LESS_THAN, (Object)35)), null), new KiePMMLFieldOperatorValue(humidityField, BOOLEAN_OPERATOR.OR, Collections.singletonList(new KiePMMLOperatorValue(OPERATOR.GREATER_THAN, (Object)85)), null));
        KiePMMLDescrLhsFactory.factory(this.lhsBuilder).declareConstraintsAndOr(kiePMMLOperatorValues, this.lhsBuilder.or());
        Assert.assertNotNull((Object)this.lhsBuilder.getDescr());
        Assert.assertEquals((long)1L, (long)((AndDescr)this.lhsBuilder.getDescr()).getDescrs().size());
        Assert.assertTrue((boolean)(((AndDescr)this.lhsBuilder.getDescr()).getDescrs().get(0) instanceof OrDescr));
        OrDescr baseOrDescr = (OrDescr)((AndDescr)this.lhsBuilder.getDescr()).getDescrs().get(0);
        List descrs = baseOrDescr.getDescrs();
        Assert.assertNotNull((Object)descrs);
        Assert.assertEquals((long)2L, (long)descrs.size());
        Assert.assertTrue((boolean)(descrs.get(0) instanceof PatternDescr));
        PatternDescr patternDescr = (PatternDescr)descrs.get(0);
        Assert.assertEquals((Object)temperatureField, (Object)patternDescr.getObjectType());
        Assert.assertNull((Object)patternDescr.getIdentifier());
        Assert.assertTrue((boolean)(patternDescr.getConstraint() instanceof AndDescr));
        AndDescr andDescr = (AndDescr)patternDescr.getConstraint();
        Assert.assertEquals((long)1L, (long)andDescr.getDescrs().size());
        Assert.assertTrue((boolean)(andDescr.getDescrs().get(0) instanceof ExprConstraintDescr));
        ExprConstraintDescr exprConstraintDescr = (ExprConstraintDescr)andDescr.getDescrs().get(0);
        Assert.assertFalse((boolean)exprConstraintDescr.isNegated());
        Assert.assertEquals((Object)ExprConstraintDescr.Type.NAMED, (Object)exprConstraintDescr.getType());
        String expected = "value < 35";
        Assert.assertEquals((Object)expected, (Object)exprConstraintDescr.getExpression());
        Assert.assertTrue((boolean)(descrs.get(1) instanceof PatternDescr));
        patternDescr = (PatternDescr)descrs.get(1);
        Assert.assertEquals((Object)humidityField, (Object)patternDescr.getObjectType());
        Assert.assertNull((Object)patternDescr.getIdentifier());
        Assert.assertTrue((boolean)(patternDescr.getConstraint() instanceof AndDescr));
        andDescr = (AndDescr)patternDescr.getConstraint();
        Assert.assertEquals((long)1L, (long)andDescr.getDescrs().size());
        Assert.assertTrue((boolean)(andDescr.getDescrs().get(0) instanceof ExprConstraintDescr));
        exprConstraintDescr = (ExprConstraintDescr)andDescr.getDescrs().get(0);
        Assert.assertFalse((boolean)exprConstraintDescr.isNegated());
        Assert.assertEquals((Object)ExprConstraintDescr.Type.NAMED, (Object)exprConstraintDescr.getType());
        expected = "value > 85";
        Assert.assertEquals((Object)expected, (Object)exprConstraintDescr.getExpression());
    }

    @Test(expected=KiePMMLException.class)
    public void declareConstraintsXorWrongInput() {
        String temperatureField = "TEMPERATURE";
        String humidityField = "HUMIDITY";
        List<KiePMMLFieldOperatorValue> xorConstraints = Arrays.asList(new KiePMMLFieldOperatorValue(temperatureField, BOOLEAN_OPERATOR.OR, Collections.singletonList(new KiePMMLOperatorValue(OPERATOR.LESS_THAN, (Object)35)), null), new KiePMMLFieldOperatorValue(temperatureField, BOOLEAN_OPERATOR.OR, Collections.singletonList(new KiePMMLOperatorValue(OPERATOR.GREATER_THAN, (Object)85)), null), new KiePMMLFieldOperatorValue(humidityField, BOOLEAN_OPERATOR.OR, Collections.singletonList(new KiePMMLOperatorValue(OPERATOR.LESS_THAN, (Object)56)), null), new KiePMMLFieldOperatorValue(humidityField, BOOLEAN_OPERATOR.OR, Collections.singletonList(new KiePMMLOperatorValue(OPERATOR.GREATER_THAN, (Object)91)), null));
        KiePMMLDescrLhsFactory.factory(this.lhsBuilder).declareConstraintsXor(xorConstraints);
    }

    @Test
    public void declareConstraintsXor() {
        String temperatureField = "TEMPERATURE";
        List<KiePMMLFieldOperatorValue> xorConstraints = Arrays.asList(new KiePMMLFieldOperatorValue(temperatureField, BOOLEAN_OPERATOR.OR, Collections.singletonList(new KiePMMLOperatorValue(OPERATOR.LESS_THAN, (Object)35)), null), new KiePMMLFieldOperatorValue(temperatureField, BOOLEAN_OPERATOR.OR, Collections.singletonList(new KiePMMLOperatorValue(OPERATOR.GREATER_THAN, (Object)85)), null));
        KiePMMLDescrLhsFactory.factory(this.lhsBuilder).declareConstraintsXor(xorConstraints);
        Assert.assertNotNull((Object)this.lhsBuilder.getDescr());
        Assert.assertNotNull((Object)((AndDescr)this.lhsBuilder.getDescr()).getDescrs());
        Assert.assertEquals((long)1L, (long)((AndDescr)this.lhsBuilder.getDescr()).getDescrs().size());
        Assert.assertTrue((boolean)(((AndDescr)this.lhsBuilder.getDescr()).getDescrs().get(0) instanceof AndDescr));
        AndDescr rootAndDescr = (AndDescr)((AndDescr)this.lhsBuilder.getDescr()).getDescrs().get(0);
        Assert.assertEquals((long)2L, (long)rootAndDescr.getDescrs().size());
        Assert.assertTrue((boolean)(rootAndDescr.getDescrs().get(0) instanceof NotDescr));
        Assert.assertTrue((boolean)(rootAndDescr.getDescrs().get(1) instanceof ExistsDescr));
        NotDescr notDescr = (NotDescr)rootAndDescr.getDescrs().get(0);
        Assert.assertEquals((long)1L, (long)notDescr.getDescrs().size());
        Assert.assertTrue((boolean)(notDescr.getDescrs().get(0) instanceof AndDescr));
        AndDescr notAndDescr = (AndDescr)notDescr.getDescrs().get(0);
        Assert.assertTrue((boolean)(notAndDescr.getDescrs().get(0) instanceof PatternDescr));
        Assert.assertTrue((boolean)(notAndDescr.getDescrs().get(1) instanceof PatternDescr));
        PatternDescr patternDescr = (PatternDescr)notAndDescr.getDescrs().get(0);
        Assert.assertEquals((Object)temperatureField, (Object)patternDescr.getObjectType());
        Assert.assertNull((Object)patternDescr.getIdentifier());
        Assert.assertTrue((boolean)(patternDescr.getConstraint() instanceof AndDescr));
        AndDescr andDescr = (AndDescr)patternDescr.getConstraint();
        Assert.assertEquals((long)1L, (long)andDescr.getDescrs().size());
        Assert.assertTrue((boolean)(andDescr.getDescrs().get(0) instanceof ExprConstraintDescr));
        ExprConstraintDescr exprConstraintDescr = (ExprConstraintDescr)andDescr.getDescrs().get(0);
        Assert.assertFalse((boolean)exprConstraintDescr.isNegated());
        Assert.assertEquals((Object)ExprConstraintDescr.Type.NAMED, (Object)exprConstraintDescr.getType());
        String expected = "value < 35";
        Assert.assertEquals((Object)expected, (Object)exprConstraintDescr.getExpression());
        patternDescr = (PatternDescr)notAndDescr.getDescrs().get(1);
        Assert.assertEquals((Object)temperatureField, (Object)patternDescr.getObjectType());
        Assert.assertNull((Object)patternDescr.getIdentifier());
        Assert.assertTrue((boolean)(patternDescr.getConstraint() instanceof AndDescr));
        andDescr = (AndDescr)patternDescr.getConstraint();
        Assert.assertEquals((long)1L, (long)andDescr.getDescrs().size());
        Assert.assertTrue((boolean)(andDescr.getDescrs().get(0) instanceof ExprConstraintDescr));
        exprConstraintDescr = (ExprConstraintDescr)andDescr.getDescrs().get(0);
        Assert.assertFalse((boolean)exprConstraintDescr.isNegated());
        Assert.assertEquals((Object)ExprConstraintDescr.Type.NAMED, (Object)exprConstraintDescr.getType());
        expected = "value > 85";
        Assert.assertEquals((Object)expected, (Object)exprConstraintDescr.getExpression());
        ExistsDescr existsDescr = (ExistsDescr)rootAndDescr.getDescrs().get(1);
        Assert.assertEquals((long)1L, (long)existsDescr.getDescrs().size());
        Assert.assertTrue((boolean)(existsDescr.getDescrs().get(0) instanceof OrDescr));
        OrDescr existsOrDescr = (OrDescr)existsDescr.getDescrs().get(0);
        Assert.assertEquals((long)2L, (long)existsOrDescr.getDescrs().size());
        Assert.assertTrue((boolean)(existsOrDescr.getDescrs().get(0) instanceof PatternDescr));
        Assert.assertTrue((boolean)(existsOrDescr.getDescrs().get(1) instanceof OrDescr));
        patternDescr = (PatternDescr)existsOrDescr.getDescrs().get(0);
        Assert.assertEquals((Object)temperatureField, (Object)patternDescr.getObjectType());
        Assert.assertNull((Object)patternDescr.getIdentifier());
        Assert.assertTrue((boolean)(patternDescr.getConstraint() instanceof AndDescr));
        andDescr = (AndDescr)patternDescr.getConstraint();
        Assert.assertEquals((long)1L, (long)andDescr.getDescrs().size());
        Assert.assertTrue((boolean)(andDescr.getDescrs().get(0) instanceof ExprConstraintDescr));
        exprConstraintDescr = (ExprConstraintDescr)andDescr.getDescrs().get(0);
        Assert.assertFalse((boolean)exprConstraintDescr.isNegated());
        Assert.assertEquals((Object)ExprConstraintDescr.Type.NAMED, (Object)exprConstraintDescr.getType());
        expected = "value < 35";
        Assert.assertEquals((Object)expected, (Object)exprConstraintDescr.getExpression());
        OrDescr nestedOrDescr = (OrDescr)existsOrDescr.getDescrs().get(1);
        Assert.assertEquals((long)1L, (long)nestedOrDescr.getDescrs().size());
        Assert.assertTrue((boolean)(nestedOrDescr.getDescrs().get(0) instanceof PatternDescr));
        patternDescr = (PatternDescr)nestedOrDescr.getDescrs().get(0);
        Assert.assertEquals((Object)temperatureField, (Object)patternDescr.getObjectType());
        Assert.assertNull((Object)patternDescr.getIdentifier());
        Assert.assertTrue((boolean)(patternDescr.getConstraint() instanceof AndDescr));
        andDescr = (AndDescr)patternDescr.getConstraint();
        Assert.assertEquals((long)1L, (long)andDescr.getDescrs().size());
        Assert.assertTrue((boolean)(andDescr.getDescrs().get(0) instanceof ExprConstraintDescr));
        exprConstraintDescr = (ExprConstraintDescr)andDescr.getDescrs().get(0);
        Assert.assertFalse((boolean)exprConstraintDescr.isNegated());
        Assert.assertEquals((Object)ExprConstraintDescr.Type.NAMED, (Object)exprConstraintDescr.getType());
        expected = "value > 85";
        Assert.assertEquals((Object)expected, (Object)exprConstraintDescr.getExpression());
    }

    @Test
    public void commonDeclarePatternWithConstraint() {
        String patternType = "TEMPERATURE";
        String constraintsString = "value < 35";
        CEDescrBuilder existsBuilder = this.lhsBuilder.not().exists();
        KiePMMLDescrLhsFactory.factory(this.lhsBuilder).commonDeclarePatternWithConstraint(existsBuilder, patternType, constraintsString);
        Assert.assertNotNull((Object)existsBuilder.getDescr());
        List descrs = ((ExistsDescr)existsBuilder.getDescr()).getDescrs();
        Assert.assertNotNull((Object)descrs);
        Assert.assertEquals((long)1L, (long)descrs.size());
        Assert.assertTrue((boolean)(descrs.get(0) instanceof PatternDescr));
        PatternDescr patternDescr = (PatternDescr)descrs.get(0);
        Assert.assertEquals((Object)patternType, (Object)patternDescr.getObjectType());
        Assert.assertNull((Object)patternDescr.getIdentifier());
        Assert.assertTrue((boolean)(patternDescr.getConstraint() instanceof AndDescr));
        AndDescr andDescr = (AndDescr)patternDescr.getConstraint();
        Assert.assertEquals((long)1L, (long)andDescr.getDescrs().size());
        Assert.assertTrue((boolean)(andDescr.getDescrs().get(0) instanceof ExprConstraintDescr));
        ExprConstraintDescr exprConstraintDescr = (ExprConstraintDescr)andDescr.getDescrs().get(0);
        Assert.assertFalse((boolean)exprConstraintDescr.isNegated());
        Assert.assertEquals((Object)ExprConstraintDescr.Type.NAMED, (Object)exprConstraintDescr.getType());
        Assert.assertEquals((Object)constraintsString, (Object)exprConstraintDescr.getExpression());
    }

    @Test
    public void declareConstraintIn() {
        List<Object> values = Arrays.asList("-5", "0.5", "1", "10");
        String patternType = "INPUT1";
        KiePMMLDescrLhsFactory.factory(this.lhsBuilder).declareConstraintIn(patternType, values);
        List descrs = ((AndDescr)this.lhsBuilder.getDescr()).getDescrs();
        Assert.assertNotNull((Object)descrs);
        Assert.assertEquals((long)1L, (long)descrs.size());
        Assert.assertTrue((boolean)(descrs.get(0) instanceof PatternDescr));
        PatternDescr patternDescr = (PatternDescr)descrs.get(0);
        Assert.assertEquals((Object)patternType, (Object)patternDescr.getObjectType());
        Assert.assertNull((Object)patternDescr.getIdentifier());
        Assert.assertTrue((boolean)(patternDescr.getConstraint() instanceof AndDescr));
        AndDescr andDescr = (AndDescr)patternDescr.getConstraint();
        Assert.assertEquals((long)1L, (long)andDescr.getDescrs().size());
        Assert.assertTrue((boolean)(andDescr.getDescrs().get(0) instanceof ExprConstraintDescr));
        ExprConstraintDescr exprConstraintDescr = (ExprConstraintDescr)andDescr.getDescrs().get(0);
        Assert.assertFalse((boolean)exprConstraintDescr.isNegated());
        Assert.assertEquals((Object)ExprConstraintDescr.Type.NAMED, (Object)exprConstraintDescr.getType());
        String expected = "value in (-5, 0.5, 1, 10)";
        Assert.assertEquals((Object)expected, (Object)exprConstraintDescr.getExpression());
    }

    @Test
    public void declareConstraintNotIn() {
        List<Object> values = Arrays.asList("3", "8.5");
        String patternType = "INPUT2";
        KiePMMLDescrLhsFactory.factory(this.lhsBuilder).declareConstraintNotIn(patternType, values);
        List descrs = ((AndDescr)this.lhsBuilder.getDescr()).getDescrs();
        Assert.assertNotNull((Object)descrs);
        Assert.assertEquals((long)1L, (long)descrs.size());
        Assert.assertTrue((boolean)(descrs.get(0) instanceof NotDescr));
        NotDescr notDescr = (NotDescr)descrs.get(0);
        Assert.assertEquals((long)1L, (long)notDescr.getDescrs().size());
        Assert.assertTrue((boolean)(notDescr.getDescrs().get(0) instanceof PatternDescr));
        PatternDescr patternDescr = (PatternDescr)notDescr.getDescrs().get(0);
        Assert.assertEquals((Object)patternType, (Object)patternDescr.getObjectType());
        Assert.assertNull((Object)patternDescr.getIdentifier());
        Assert.assertTrue((boolean)(patternDescr.getConstraint() instanceof AndDescr));
        AndDescr andDescr = (AndDescr)patternDescr.getConstraint();
        Assert.assertEquals((long)1L, (long)andDescr.getDescrs().size());
        Assert.assertTrue((boolean)(andDescr.getDescrs().get(0) instanceof ExprConstraintDescr));
        ExprConstraintDescr exprConstraintDescr = (ExprConstraintDescr)andDescr.getDescrs().get(0);
        Assert.assertFalse((boolean)exprConstraintDescr.isNegated());
        Assert.assertEquals((Object)ExprConstraintDescr.Type.NAMED, (Object)exprConstraintDescr.getType());
        String expected = "value in (3, 8.5)";
        Assert.assertEquals((Object)expected, (Object)exprConstraintDescr.getExpression());
    }

    @Test
    public void declareIfBreak() {
        String ifBreakField = "TEMPERATURE";
        String ifBreakOperator = "<";
        Integer ifBreakValue = 24;
        KiePMMLDescrLhsFactory.factory(this.lhsBuilder).declareIfBreak(ifBreakField, ifBreakOperator, (Object)ifBreakValue);
        Assert.assertNotNull((Object)this.lhsBuilder.getDescr());
        List descrs = ((AndDescr)this.lhsBuilder.getDescr()).getDescrs();
        Assert.assertNotNull((Object)descrs);
        Assert.assertEquals((long)2L, (long)descrs.size());
        Assert.assertTrue((boolean)(descrs.get(0) instanceof PatternDescr));
        Assert.assertTrue((boolean)(descrs.get(1) instanceof ConditionalBranchDescr));
        PatternDescr patternDescr = (PatternDescr)descrs.get(0);
        Assert.assertEquals((Object)ifBreakField, (Object)patternDescr.getObjectType());
        Assert.assertEquals((Object)"$inputField", (Object)patternDescr.getIdentifier());
        Assert.assertTrue((boolean)(patternDescr.getConstraint() instanceof AndDescr));
        ConditionalBranchDescr conditionalBranchDescr = (ConditionalBranchDescr)descrs.get(1);
        String expectedCondition = String.format("$inputField.getValue() %s %s", ifBreakOperator, ifBreakValue);
        Assert.assertEquals((Object)expectedCondition, (Object)conditionalBranchDescr.getCondition().getContent());
        Assert.assertTrue((boolean)conditionalBranchDescr.getConsequence().isBreaking());
        Assert.assertEquals((Object)"match", (Object)conditionalBranchDescr.getConsequence().getText());
    }

    @Test
    public void getInNotInConstraint() {
        List<Object> values = Arrays.asList("-5", "0.5", "1", "10");
        String retrieved = KiePMMLDescrLhsFactory.factory(this.lhsBuilder).getInNotInConstraint(values);
        String expected = "value in (-5, 0.5, 1, 10)";
        Assert.assertEquals((Object)expected, (Object)retrieved);
    }
}

