/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.commons.factories;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.drools.compiler.lang.DrlDumper;
import org.drools.compiler.lang.api.DescrFactory;
import org.drools.compiler.lang.api.PackageDescrBuilder;
import org.drools.compiler.lang.descr.AttributeDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.pmml.commons.model.enums.BOOLEAN_OPERATOR;
import org.kie.pmml.commons.model.enums.OPERATOR;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsRule;
import org.kie.pmml.models.drools.ast.KiePMMLFieldOperatorValue;
import org.kie.pmml.models.drools.commons.factories.KiePMMLDescrRulesFactory;
import org.kie.pmml.models.drools.tuples.KiePMMLOperatorValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLDescrRulesFactoryTest {
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLDescrRulesFactoryTest.class.getName());
    private static final String PACKAGE_NAME = "package";
    private PackageDescrBuilder builder;

    @Before
    public void setUp() throws Exception {
        this.builder = DescrFactory.newPackage().name(PACKAGE_NAME);
        Assert.assertNotNull((Object)this.builder.getDescr());
        Assert.assertEquals((Object)PACKAGE_NAME, (Object)((PackageDescr)this.builder.getDescr()).getName());
    }

    @Test
    public void declareRule() {
        String name = "NAME";
        String statusToSet = "STATUS_TO_SET";
        String patternType = "TEMPERATURE";
        String agendaGroup = "agendaGroup";
        String activationGroup = "activationGroup";
        List<KiePMMLFieldOperatorValue> orConstraints = Arrays.asList(new KiePMMLFieldOperatorValue(patternType, BOOLEAN_OPERATOR.OR, Collections.singletonList(new KiePMMLOperatorValue(OPERATOR.LESS_THAN, (Object)35)), null), new KiePMMLFieldOperatorValue(patternType, BOOLEAN_OPERATOR.AND, Collections.singletonList(new KiePMMLOperatorValue(OPERATOR.GREATER_THAN, (Object)85)), null));
        KiePMMLDroolsRule rule = KiePMMLDroolsRule.builder((String)name, (String)statusToSet, Collections.emptyList()).withAgendaGroup(agendaGroup).withActivationGroup(activationGroup).withOrConstraints(orConstraints).build();
        KiePMMLDescrRulesFactory.factory((PackageDescrBuilder)this.builder).declareRule(rule);
        Assert.assertNotNull((Object)((PackageDescr)this.builder.getDescr()).getRules());
        Assert.assertEquals((long)1L, (long)((PackageDescr)this.builder.getDescr()).getRules().size());
        RuleDescr retrieved = (RuleDescr)((PackageDescr)this.builder.getDescr()).getRules().get(0);
        Assert.assertEquals((Object)name, (Object)retrieved.getName());
        Assert.assertEquals((long)2L, (long)retrieved.getAttributes().size());
        Assert.assertTrue((boolean)retrieved.getAttributes().containsKey("agenda-group"));
        Assert.assertEquals((Object)agendaGroup, (Object)((AttributeDescr)retrieved.getAttributes().get("agenda-group")).getValue());
        Assert.assertTrue((boolean)retrieved.getAttributes().containsKey("activation-group"));
        Assert.assertEquals((Object)activationGroup, (Object)((AttributeDescr)retrieved.getAttributes().get("activation-group")).getValue());
        this.printGeneratedRules();
    }

    private void printGeneratedRules() {
        try {
            String string = new DrlDumper().dump((PackageDescr)this.builder.getDescr());
            logger.debug(string);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

