/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.provider;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.scorecard.Scorecard;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.lang.descr.CompositePackageDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.commons.mocks.HasClassLoaderMock;
import org.kie.pmml.compiler.testutils.TestUtils;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsAST;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsType;
import org.kie.pmml.models.drools.commons.implementations.HasKnowledgeBuilderMock;
import org.kie.pmml.models.drools.commons.model.KiePMMLDroolsModel;
import org.kie.pmml.models.drools.commons.model.KiePMMLDroolsModelWithSources;
import org.kie.pmml.models.drools.provider.DroolsModelProvider;
import org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType;

public class DroolsModelProviderTest {
    private static final String SOURCE_1 = "SimpleScorecardWithTransformations.pmml";
    private static final String PACKAGE_NAME = "PACKAGE_NAME";
    private static final Map<String, String> SOURCE_MAP = new HashMap<String, String>();
    private static PMML pmml;
    private static Scorecard scorecard;
    private static DroolsModelProvider<Scorecard, ? extends KiePMMLDroolsModel> droolsModelProvider;

    @BeforeClass
    public static void setup() throws Exception {
        pmml = TestUtils.loadFromFile((String)SOURCE_1);
        Assert.assertNotNull((Object)pmml);
        scorecard = (Scorecard)pmml.getModels().get(0);
        Assert.assertNotNull((Object)scorecard);
        droolsModelProvider = new DroolsModelProvider<Scorecard, KiePMMLDroolsModel>(){

            public KiePMMLDroolsModel getKiePMMLDroolsModel(DataDictionary dataDictionary, TransformationDictionary transformationDictionary, Scorecard model, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap, String packageName, HasClassLoader hasClassLoader) {
                return new KiePMMLDroolsModelTest(dataDictionary, transformationDictionary, model, fieldTypeMap);
            }

            public KiePMMLDroolsAST getKiePMMLDroolsAST(DataDictionary dataDictionary, Scorecard model, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap, List<KiePMMLDroolsType> types) {
                return new KiePMMLDroolsASTTest(dataDictionary, model, fieldTypeMap, types);
            }

            public Map<String, String> getKiePMMLDroolsModelSourcesMap(DataDictionary dataDictionary, TransformationDictionary transformationDictionary, Scorecard model, Map fieldTypeMap, String packageName) throws IOException {
                return SOURCE_MAP;
            }

            public PMML_MODEL getPMMLModelType() {
                return PMML_MODEL.SCORECARD_MODEL;
            }
        };
    }

    @Test
    public void getKiePMMLModelWithKnowledgeBuilder() {
        KnowledgeBuilderImpl knowledgeBuilder = new KnowledgeBuilderImpl();
        KiePMMLDroolsModel retrieved = droolsModelProvider.getKiePMMLModel(PACKAGE_NAME, pmml.getDataDictionary(), pmml.getTransformationDictionary(), (Model)scorecard, (HasClassLoader)new HasKnowledgeBuilderMock(knowledgeBuilder));
        Assert.assertNotNull((Object)retrieved);
        Assert.assertTrue((boolean)(retrieved instanceof KiePMMLDroolsModelTest));
        KiePMMLDroolsModelTest retrievedTest = (KiePMMLDroolsModelTest)retrieved;
        Assert.assertEquals((Object)pmml.getDataDictionary(), (Object)retrievedTest.dataDictionary);
        Assert.assertEquals((Object)pmml.getTransformationDictionary(), (Object)retrievedTest.transformationDictionary);
        Assert.assertEquals((Object)scorecard, (Object)retrievedTest.model);
        String expectedPackageName = KiePMMLModelUtils.getSanitizedPackageName((String)PACKAGE_NAME);
        Assert.assertEquals((Object)expectedPackageName, (Object)retrievedTest.getKModulePackageName());
        Assert.assertEquals((Object)PACKAGE_NAME, (Object)retrievedTest.getName());
        PackageDescr packageDescr = (PackageDescr)knowledgeBuilder.getPackageDescrs("packagename").get(0);
        Assert.assertTrue((boolean)(packageDescr instanceof CompositePackageDescr));
    }

    @Test(expected=KiePMMLException.class)
    public void getKiePMMLModelNoKnowledgeBuilder() {
        droolsModelProvider.getKiePMMLModel(PACKAGE_NAME, pmml.getDataDictionary(), pmml.getTransformationDictionary(), (Model)scorecard, (HasClassLoader)new HasClassLoaderMock());
    }

    @Test
    public void getKiePMMLModelWithSourcesWithKnowledgeBuilder() {
        KnowledgeBuilderImpl knowledgeBuilder = new KnowledgeBuilderImpl();
        KiePMMLDroolsModel retrieved = droolsModelProvider.getKiePMMLModelWithSources(PACKAGE_NAME, pmml.getDataDictionary(), pmml.getTransformationDictionary(), (Model)scorecard, (HasClassLoader)new HasKnowledgeBuilderMock(knowledgeBuilder));
        Assert.assertNotNull((Object)retrieved);
        Assert.assertTrue((boolean)(retrieved instanceof KiePMMLDroolsModelWithSources));
        KiePMMLDroolsModelWithSources retrievedWithSources = (KiePMMLDroolsModelWithSources)retrieved;
        Assert.assertEquals(SOURCE_MAP, (Object)retrievedWithSources.getSourcesMap());
        Assert.assertEquals((Object)PACKAGE_NAME, (Object)retrievedWithSources.getKModulePackageName());
        Assert.assertEquals((Object)scorecard.getModelName(), (Object)retrievedWithSources.getName());
        PackageDescr packageDescr = (PackageDescr)knowledgeBuilder.getPackageDescrs(PACKAGE_NAME).get(0);
        this.commonVerifyPackageDescr(packageDescr, PACKAGE_NAME);
        Assert.assertNotNull((Object)retrieved);
        String rootPath = "PACKAGE_NAME.";
        this.commonVerifyRulesSourcesMap(retrievedWithSources.getRulesSourcesMap(), packageDescr, "PACKAGE_NAME.");
    }

    @Test(expected=KiePMMLException.class)
    public void getKiePMMLModelWithSourcesWithException() {
        KnowledgeBuilderImpl knowledgeBuilder = new KnowledgeBuilderImpl();
        droolsModelProvider.getKiePMMLModelWithSources(PACKAGE_NAME, null, null, null, (HasClassLoader)new HasKnowledgeBuilderMock(knowledgeBuilder));
    }

    @Test(expected=KiePMMLException.class)
    public void getKiePMMLModelWithSourcesNoKnowledgeBuilder() {
        droolsModelProvider.getKiePMMLModelWithSources(PACKAGE_NAME, pmml.getDataDictionary(), pmml.getTransformationDictionary(), (Model)scorecard, (HasClassLoader)new HasClassLoaderMock());
    }

    @Test
    public void getPackageDescr() {
        KiePMMLDroolsAST kiePMMLDroolsAST = new KiePMMLDroolsAST(Collections.emptyList(), Collections.emptyList());
        PackageDescr retrieved = droolsModelProvider.getPackageDescr(kiePMMLDroolsAST, PACKAGE_NAME);
        this.commonVerifyPackageDescr(retrieved, PACKAGE_NAME);
    }

    @Test
    public void getKiePMMLDroolsASTCommon() {
        HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
        KiePMMLDroolsAST retrieved = droolsModelProvider.getKiePMMLDroolsASTCommon(pmml.getDataDictionary(), pmml.getTransformationDictionary(), (Model)scorecard, fieldTypeMap);
        this.commonVerifyKiePMMLDroolsAST(retrieved, fieldTypeMap);
        this.commonVerifyFieldTypeMap(fieldTypeMap, pmml.getDataDictionary().getDataFields(), pmml.getTransformationDictionary().getDerivedFields(), scorecard.getLocalTransformations().getDerivedFields());
    }

    @Test
    public void addTransformationsDerivedFields() {
        HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
        droolsModelProvider.addTransformationsDerivedFields(fieldTypeMap, pmml.getTransformationDictionary(), scorecard.getLocalTransformations());
        this.commonVerifyFieldTypeMap(fieldTypeMap, Collections.emptyList(), pmml.getTransformationDictionary().getDerivedFields(), scorecard.getLocalTransformations().getDerivedFields());
    }

    @Test
    public void getRulesSourceMap() {
        KnowledgeBuilderImpl knowledgeBuilder = new KnowledgeBuilderImpl();
        droolsModelProvider.getKiePMMLModelWithSources(PACKAGE_NAME, pmml.getDataDictionary(), pmml.getTransformationDictionary(), (Model)scorecard, (HasClassLoader)new HasKnowledgeBuilderMock(knowledgeBuilder));
        PackageDescr packageDescr = (PackageDescr)knowledgeBuilder.getPackageDescrs(PACKAGE_NAME).get(0);
        Map retrieved = droolsModelProvider.getRulesSourceMap(packageDescr);
        Assert.assertNotNull((Object)retrieved);
        String rootPath = "PACKAGE_NAME.";
        this.commonVerifyRulesSourcesMap(retrieved, packageDescr, "PACKAGE_NAME.");
    }

    @Test
    public void generateRulesFiles() {
        KnowledgeBuilderImpl knowledgeBuilder = new KnowledgeBuilderImpl();
        droolsModelProvider.getKiePMMLModelWithSources(PACKAGE_NAME, pmml.getDataDictionary(), pmml.getTransformationDictionary(), (Model)scorecard, (HasClassLoader)new HasKnowledgeBuilderMock(knowledgeBuilder));
        PackageDescr packageDescr = (PackageDescr)knowledgeBuilder.getPackageDescrs(PACKAGE_NAME).get(0);
        List retrieved = droolsModelProvider.generateRulesFiles(packageDescr);
        Assert.assertNotNull((Object)retrieved);
        String rootPath = "PACKAGE_NAME/";
        packageDescr.getTypeDeclarations().forEach(typeDeclarationDescr -> {
            String expectedPath = "PACKAGE_NAME/" + typeDeclarationDescr.getTypeName() + ".java";
            Assert.assertTrue((boolean)retrieved.stream().anyMatch(generatedFile -> generatedFile.getPath().equals(expectedPath)));
        });
        String pkgUUID = (String)packageDescr.getPreferredPkgUUID().get();
        String expectedRule = "PACKAGE_NAME/Rules" + pkgUUID + ".java";
        Assert.assertTrue((boolean)retrieved.stream().anyMatch(generatedFile -> generatedFile.getPath().equals(expectedRule)));
        String expectedDomain = "PACKAGE_NAME/DomainClassesMetadata" + pkgUUID + ".java";
        Assert.assertTrue((boolean)retrieved.stream().anyMatch(generatedFile -> generatedFile.getPath().equals(expectedDomain)));
    }

    private void commonVerifyRulesSourcesMap(Map<String, String> toVerify, PackageDescr packageDescr, String rootPath) {
        packageDescr.getTypeDeclarations().forEach(typeDeclarationDescr -> {
            String expectedPath = rootPath + typeDeclarationDescr.getTypeName();
            Assert.assertTrue((boolean)toVerify.keySet().stream().anyMatch(className -> className.equals(expectedPath)));
        });
        String pkgUUID = (String)packageDescr.getPreferredPkgUUID().get();
        String expectedRule = rootPath + "Rules" + pkgUUID;
        Assert.assertTrue((boolean)toVerify.keySet().stream().anyMatch(className -> className.equals(expectedRule)));
        String expectedDomain = rootPath + "DomainClassesMetadata" + pkgUUID;
        Assert.assertTrue((boolean)toVerify.keySet().stream().anyMatch(className -> className.equals(expectedDomain)));
    }

    private void commonVerifyPackageDescr(PackageDescr toVerify, String expectedPackageName) {
        Assert.assertEquals((Object)expectedPackageName, (Object)toVerify.getName());
    }

    private void commonVerifyKiePMMLDroolsAST(KiePMMLDroolsAST toVerify, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap) {
        Assert.assertNotNull((Object)toVerify);
        Assert.assertTrue((boolean)(toVerify instanceof KiePMMLDroolsASTTest));
        KiePMMLDroolsASTTest toVerifyTest = (KiePMMLDroolsASTTest)toVerify;
        Assert.assertEquals((Object)pmml.getDataDictionary(), (Object)toVerifyTest.dataDictionary);
        Assert.assertEquals((Object)scorecard, (Object)toVerifyTest.model);
        if (fieldTypeMap != null) {
            Assert.assertEquals(fieldTypeMap, toVerifyTest.fieldTypeMap);
        }
        this.commonVerifyTypesList(toVerify.getTypes(), pmml.getDataDictionary().getDataFields(), pmml.getTransformationDictionary().getDerivedFields(), scorecard.getLocalTransformations().getDerivedFields());
    }

    private void commonVerifyTypesList(List<KiePMMLDroolsType> toVerify, List<DataField> dataFields, List<DerivedField> transformationsFields, List<DerivedField> localTransformationsFields) {
        int expectedEntries = dataFields.size() + transformationsFields.size() + localTransformationsFields.size();
        Assert.assertEquals((long)expectedEntries, (long)toVerify.size());
        dataFields.forEach(dataField -> this.commonVerifyTypesList((DataField)dataField, toVerify));
        transformationsFields.forEach(derivedField -> this.commonVerifyTypesList((DerivedField)derivedField, toVerify));
        localTransformationsFields.forEach(derivedField -> this.commonVerifyTypesList((DerivedField)derivedField, toVerify));
    }

    private void commonVerifyTypesList(DataField toVerify, List<KiePMMLDroolsType> types) {
        Assert.assertTrue((boolean)types.stream().anyMatch(type -> {
            String expectedName = KiePMMLModelUtils.getSanitizedClassName((String)toVerify.getName().getValue().toUpperCase());
            if (!expectedName.equals(type.getName())) {
                return false;
            }
            String expectedType = DATA_TYPE.byName((String)toVerify.getDataType().value()).getMappedClass().getSimpleName();
            Assert.assertEquals((Object)expectedType, (Object)type.getType());
            return true;
        }));
    }

    private void commonVerifyTypesList(DerivedField toVerify, List<KiePMMLDroolsType> types) {
        Assert.assertTrue((boolean)types.stream().anyMatch(type -> {
            String expectedName = KiePMMLModelUtils.getSanitizedClassName((String)toVerify.getName().getValue().toUpperCase());
            if (!expectedName.equals(type.getName())) {
                return false;
            }
            String expectedType = DATA_TYPE.byName((String)toVerify.getDataType().value()).getMappedClass().getSimpleName();
            Assert.assertEquals((Object)expectedType, (Object)type.getType());
            return true;
        }));
    }

    private void commonVerifyFieldTypeMap(Map<String, KiePMMLOriginalTypeGeneratedType> toVerify, List<DataField> dataFields, List<DerivedField> transformationsFields, List<DerivedField> localTransformationsFields) {
        int expectedEntries = dataFields.size() + transformationsFields.size() + localTransformationsFields.size();
        Assert.assertEquals((long)expectedEntries, (long)toVerify.size());
        dataFields.forEach(dataField -> this.commonVerifyFieldTypeMap((DataField)dataField, toVerify));
        transformationsFields.forEach(derivedField -> this.commonVerifyFieldTypeMap((DerivedField)derivedField, toVerify));
        localTransformationsFields.forEach(derivedField -> this.commonVerifyFieldTypeMap((DerivedField)derivedField, toVerify));
    }

    private void commonVerifyFieldTypeMap(DataField toVerify, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap) {
        Assert.assertTrue((boolean)fieldTypeMap.entrySet().stream().anyMatch(entry -> {
            if (!((String)entry.getKey()).equals(toVerify.getName().getValue())) {
                return false;
            }
            KiePMMLOriginalTypeGeneratedType value = (KiePMMLOriginalTypeGeneratedType)entry.getValue();
            Assert.assertEquals((Object)toVerify.getDataType().value(), (Object)value.getOriginalType());
            String expectedGeneratedType = KiePMMLModelUtils.getSanitizedClassName((String)toVerify.getName().getValue().toUpperCase());
            Assert.assertEquals((Object)expectedGeneratedType, (Object)value.getGeneratedType());
            return true;
        }));
    }

    private void commonVerifyFieldTypeMap(DerivedField toVerify, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap) {
        Assert.assertTrue((boolean)fieldTypeMap.entrySet().stream().anyMatch(entry -> {
            if (!((String)entry.getKey()).equals(toVerify.getName().getValue())) {
                return false;
            }
            KiePMMLOriginalTypeGeneratedType value = (KiePMMLOriginalTypeGeneratedType)entry.getValue();
            Assert.assertEquals((Object)toVerify.getDataType().value(), (Object)value.getOriginalType());
            String expectedGeneratedType = KiePMMLModelUtils.getSanitizedClassName((String)toVerify.getName().getValue().toUpperCase());
            Assert.assertEquals((Object)expectedGeneratedType, (Object)value.getGeneratedType());
            return true;
        }));
    }

    private static class KiePMMLDroolsASTTest
    extends KiePMMLDroolsAST {
        final DataDictionary dataDictionary;
        final Scorecard model;
        final Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap;

        public KiePMMLDroolsASTTest(DataDictionary dataDictionary, Scorecard model, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap, List<KiePMMLDroolsType> types) {
            super(types, Collections.emptyList());
            this.dataDictionary = dataDictionary;
            this.model = model;
            this.fieldTypeMap = fieldTypeMap;
        }
    }

    private static class KiePMMLDroolsModelTest
    extends KiePMMLDroolsModel {
        final DataDictionary dataDictionary;
        final TransformationDictionary transformationDictionary;
        final Scorecard model;
        final Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap;

        public KiePMMLDroolsModelTest(DataDictionary dataDictionary, TransformationDictionary transformationDictionary, Scorecard model, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap) {
            super(DroolsModelProviderTest.PACKAGE_NAME, Collections.emptyList());
            this.dataDictionary = dataDictionary;
            this.transformationDictionary = transformationDictionary;
            this.model = model;
            this.fieldTypeMap = fieldTypeMap;
        }
    }
}

