/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.ast.factories;

import java.util.ArrayList;
import java.util.Collections;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.True;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.api.enums.ResultCode;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsRule;
import org.kie.pmml.models.drools.ast.factories.KiePMMLTruePredicateASTFactory;
import org.kie.pmml.models.drools.ast.factories.PredicateASTFactoryData;
import org.kie.pmml.models.drools.utils.KiePMMLASTTestUtils;

public class KiePMMLTruePredicateASTFactoryTest {
    @Test
    public void declareRuleFromTruePredicateNotFinalLeaf() {
        String parentPath = "_will play";
        String currentRule = "_will play_will play";
        ArrayList<KiePMMLDroolsRule> rules = new ArrayList<KiePMMLDroolsRule>();
        True truePredicate = new True();
        PredicateASTFactoryData predicateASTFactoryData = KiePMMLASTTestUtils.getPredicateASTFactoryData((Predicate)truePredicate, Collections.emptyList(), rules, parentPath, currentRule, Collections.emptyMap());
        KiePMMLTruePredicateASTFactory.factory((PredicateASTFactoryData)predicateASTFactoryData).declareRuleFromTruePredicateWithResult((Object)"DONE", false);
        Assert.assertEquals((long)1L, (long)rules.size());
        KiePMMLDroolsRule retrieved = (KiePMMLDroolsRule)rules.get(0);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)currentRule, (Object)retrieved.getName());
        Assert.assertEquals((Object)currentRule, (Object)retrieved.getStatusToSet());
        Assert.assertEquals((Object)String.format("status == \"%s\"", parentPath), (Object)retrieved.getStatusConstraint());
        Assert.assertNull((Object)retrieved.getAndConstraints());
        Assert.assertNull((Object)retrieved.getResultCode());
    }

    @Test
    public void declareRuleFromTruePredicateFinalLeaf() {
        String parentPath = "_will play";
        String currentRule = "_will play_will play";
        ArrayList<KiePMMLDroolsRule> rules = new ArrayList<KiePMMLDroolsRule>();
        String statusToSet = "DONE";
        True truePredicate = new True();
        PredicateASTFactoryData predicateASTFactoryData = KiePMMLASTTestUtils.getPredicateASTFactoryData((Predicate)truePredicate, Collections.emptyList(), rules, parentPath, currentRule, Collections.emptyMap());
        KiePMMLTruePredicateASTFactory.factory((PredicateASTFactoryData)predicateASTFactoryData).declareRuleFromTruePredicateWithResult((Object)statusToSet, true);
        Assert.assertEquals((long)1L, (long)rules.size());
        KiePMMLDroolsRule retrieved = (KiePMMLDroolsRule)rules.get(0);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)currentRule, (Object)retrieved.getName());
        Assert.assertEquals((Object)statusToSet, (Object)retrieved.getStatusToSet());
        Assert.assertEquals((Object)String.format("status == \"%s\"", parentPath), (Object)retrieved.getStatusConstraint());
        Assert.assertNull((Object)retrieved.getAndConstraints());
        Assert.assertEquals((Object)"DONE", (Object)retrieved.getResult());
        Assert.assertEquals((Object)ResultCode.OK, (Object)retrieved.getResultCode());
    }
}

