/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.ast.factories;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.Field;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.api.CommonTestingUtils;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsType;
import org.kie.pmml.models.drools.ast.factories.KiePMMLDataDictionaryASTFactory;
import org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType;
import org.kie.pmml.models.drools.utils.KiePMMLASTTestUtils;

public class KiePMMLDataDictionaryASTFactoryTest {
    @Test
    public void declareTypes() {
        List<DataField> dataFields = Arrays.asList(KiePMMLASTTestUtils.getTypeDataField(), KiePMMLASTTestUtils.getDottedTypeDataField(), KiePMMLASTTestUtils.getTypeDataField(), KiePMMLASTTestUtils.getDottedTypeDataField());
        DataDictionary dataDictionary = new DataDictionary(dataFields);
        HashMap fieldTypeMap = new HashMap();
        List retrieved = KiePMMLDataDictionaryASTFactory.factory(fieldTypeMap).declareTypes(CommonTestingUtils.getFieldsFromDataDictionary((DataDictionary)dataDictionary));
        Assertions.assertThat((List)retrieved).isNotNull();
        Assert.assertEquals((long)dataFields.size(), (long)retrieved.size());
        IntStream.range(0, dataFields.size()).forEach(i -> this.commonVerifyTypeDeclarationDescr((DataField)dataFields.get(i), fieldTypeMap, (KiePMMLDroolsType)retrieved.get(i)));
    }

    @Test
    public void declareType() {
        DataField dataField = KiePMMLASTTestUtils.getTypeDataField();
        HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
        KiePMMLDroolsType retrieved = KiePMMLDataDictionaryASTFactory.factory(fieldTypeMap).declareType((Field)dataField);
        Assertions.assertThat((Object)retrieved).isNotNull();
        this.commonVerifyTypeDeclarationDescr(dataField, fieldTypeMap, retrieved);
    }

    private void commonVerifyTypeDeclarationDescr(DataField dataField, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap, KiePMMLDroolsType kiePMMLDroolsType) {
        String expectedGeneratedType = KiePMMLModelUtils.getSanitizedClassName((String)dataField.getName().getValue());
        String expectedMappedOriginalType = DATA_TYPE.byName((String)dataField.getDataType().value()).getMappedClass().getSimpleName();
        Assert.assertTrue((boolean)kiePMMLDroolsType.getName().startsWith(expectedGeneratedType));
        Assert.assertEquals((Object)expectedMappedOriginalType, (Object)kiePMMLDroolsType.getType());
        Assert.assertTrue((boolean)fieldTypeMap.containsKey(dataField.getName().getValue()));
        KiePMMLOriginalTypeGeneratedType kiePMMLOriginalTypeGeneratedType = fieldTypeMap.get(dataField.getName().getValue());
        Assert.assertEquals((Object)dataField.getDataType().value(), (Object)kiePMMLOriginalTypeGeneratedType.getOriginalType());
        Assert.assertTrue((boolean)kiePMMLOriginalTypeGeneratedType.getGeneratedType().startsWith(expectedGeneratedType));
    }
}

