/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.commons.factories;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.dmg.pmml.SimplePredicate;
import org.drools.drl.ast.descr.GlobalDescr;
import org.drools.drl.ast.descr.ImportDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.ast.descr.RuleDescr;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.api.enums.BOOLEAN_OPERATOR;
import org.kie.pmml.api.enums.OPERATOR;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsAST;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsRule;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsType;
import org.kie.pmml.models.drools.ast.KiePMMLFieldOperatorValue;
import org.kie.pmml.models.drools.commons.factories.KiePMMLDescrFactory;
import org.kie.pmml.models.drools.commons.factories.KiePMMLDescrTestUtils;
import org.kie.pmml.models.drools.executor.KiePMMLStatusHolder;
import org.kie.pmml.models.drools.tuples.KiePMMLOperatorValue;

public class KiePMMLDescrFactoryTest {
    private static final String RULE_NAME = "NAME";
    private static final String STATUS_TO_SET = "STATUS_TO_SET";
    private static final String PATTERN_TYPE = "TEMPERATURE";

    @Test
    public void getBaseDescr() {
        ArrayList<KiePMMLDroolsType> types = new ArrayList<KiePMMLDroolsType>();
        types.add(KiePMMLDescrTestUtils.getDroolsType());
        types.add(KiePMMLDescrTestUtils.getDottedDroolsType());
        List<KiePMMLFieldOperatorValue> orConstraints = Arrays.asList(new KiePMMLFieldOperatorValue(PATTERN_TYPE, BOOLEAN_OPERATOR.OR, Collections.singletonList(new KiePMMLOperatorValue(OPERATOR.LESS_THAN, (Object)35)), null), new KiePMMLFieldOperatorValue(PATTERN_TYPE, BOOLEAN_OPERATOR.AND, Collections.singletonList(new KiePMMLOperatorValue(OPERATOR.GREATER_THAN, (Object)85)), null));
        KiePMMLDroolsRule rule = KiePMMLDroolsRule.builder((String)RULE_NAME, (String)STATUS_TO_SET, Collections.emptyList()).withOrConstraints(orConstraints).build();
        ArrayList<KiePMMLDroolsRule> rules = new ArrayList<KiePMMLDroolsRule>();
        rules.add(rule);
        KiePMMLDroolsAST drooledAST = new KiePMMLDroolsAST(types, rules);
        PackageDescr packageDescr = KiePMMLDescrFactory.getBaseDescr((KiePMMLDroolsAST)drooledAST, (String)"PACKAGE_NAME");
        Assert.assertEquals((Object)"PACKAGE_NAME", (Object)packageDescr.getName());
        this.checkImports(packageDescr.getImports());
        this.checkGlobals(packageDescr.getGlobals());
        this.checkRules(packageDescr.getRules());
    }

    private void checkImports(List<ImportDescr> toCheck) {
        Assert.assertEquals((long)4L, (long)toCheck.size());
        List<String> expectedImports = Arrays.asList(KiePMMLStatusHolder.class.getName(), SimplePredicate.class.getName(), PMML4Result.class.getName());
        for (String expectedImport : expectedImports) {
            Assertions.assertThat((Object)toCheck.stream().filter(importDescr -> expectedImport.equals(importDescr.getTarget())).findFirst().orElse(null)).isNotNull();
        }
    }

    private void checkGlobals(List<GlobalDescr> toCheck) {
        Assert.assertEquals((long)2L, (long)toCheck.size());
        GlobalDescr retrieved = toCheck.get(0);
        Assert.assertEquals((Object)"$pmml4Result", (Object)retrieved.getIdentifier());
        Assert.assertEquals((Object)"PMML4Result", (Object)retrieved.getType());
        retrieved = toCheck.get(1);
        Assert.assertEquals((Object)"$outputFieldsMap", (Object)retrieved.getIdentifier());
        Assert.assertEquals((Object)"Map", (Object)retrieved.getType());
    }

    private void checkRules(List<RuleDescr> toCheck) {
        Assert.assertEquals((long)1L, (long)toCheck.size());
        RuleDescr retrieved = toCheck.get(0);
        Assert.assertEquals((Object)RULE_NAME, (Object)retrieved.getName());
    }
}

