/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.provider;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dmg.pmml.Field;
import org.dmg.pmml.Model;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.lang.descr.CompositePackageDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.parser.DroolsError;
import org.drools.modelcompiler.builder.GeneratedFile;
import org.drools.modelcompiler.builder.ModelBuilderImpl;
import org.drools.modelcompiler.builder.PackageModel;
import org.drools.modelcompiler.builder.PackageSources;
import org.drools.util.io.DescrResource;
import org.kie.api.builder.ReleaseId;
import org.kie.api.definition.KieDescr;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.CompositeKnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.commons.model.KiePMMLModelWithSources;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.compiler.api.provider.ModelImplementationProvider;
import org.kie.pmml.kie.dependencies.HasKnowledgeBuilder;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsAST;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsType;
import org.kie.pmml.models.drools.ast.factories.KiePMMLDataDictionaryASTFactory;
import org.kie.pmml.models.drools.commons.factories.KiePMMLDescrFactory;
import org.kie.pmml.models.drools.commons.model.KiePMMLDroolsModel;
import org.kie.pmml.models.drools.commons.model.KiePMMLDroolsModelWithSources;
import org.kie.pmml.models.drools.dto.DroolsCompilationDTO;
import org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType;
import org.kie.util.maven.support.ReleaseIdImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DroolsModelProvider<T extends Model, E extends KiePMMLDroolsModel>
implements ModelImplementationProvider<T, E> {
    private static final Logger logger = LoggerFactory.getLogger((String)DroolsModelProvider.class.getName());

    public E getKiePMMLModel(CompilationDTO<T> compilationDTO) {
        logger.trace("getKiePMMLModel {} {} {}", new Object[]{compilationDTO.getPackageName(), compilationDTO.getFields(), compilationDTO.getModel()});
        if (!(compilationDTO.getHasClassloader() instanceof HasKnowledgeBuilder)) {
            throw new KiePMMLException(String.format("Expecting HasKnowledgeBuilder, received %s", compilationDTO.getHasClassloader().getClass().getName()));
        }
        HasKnowledgeBuilder hasKnowledgeBuilder = (HasKnowledgeBuilder)compilationDTO.getHasClassloader();
        KnowledgeBuilderImpl knowledgeBuilder = (KnowledgeBuilderImpl)hasKnowledgeBuilder.getKnowledgeBuilder();
        HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
        KiePMMLDroolsAST kiePMMLDroolsAST = this.getKiePMMLDroolsASTCommon(compilationDTO.getFields(), compilationDTO.getModel(), fieldTypeMap);
        DroolsCompilationDTO<T> droolsCompilationDTO = DroolsCompilationDTO.fromCompilationDTO(compilationDTO, fieldTypeMap);
        E toReturn = this.getKiePMMLDroolsModel(droolsCompilationDTO);
        PackageDescr packageDescr = this.getPackageDescr(kiePMMLDroolsAST, ((KiePMMLDroolsModel)((Object)toReturn)).getKModulePackageName());
        CompositePackageDescr compositePackageDescr = new CompositePackageDescr(null, packageDescr);
        knowledgeBuilder.buildPackages(Collections.singletonList(compositePackageDescr));
        return toReturn;
    }

    public Map<String, String> getSourcesMap(CompilationDTO<T> compilationDTO) {
        throw new KiePMMLException("DroolsModelProvider.getSourcesMap is not meant to be invoked");
    }

    public KiePMMLDroolsModelWithSources getKiePMMLModelWithSources(CompilationDTO<T> compilationDTO) {
        logger.trace("getKiePMMLModelWithSources {} {} {}", new Object[]{compilationDTO.getPackageName(), compilationDTO.getFields(), compilationDTO.getModel()});
        if (!(compilationDTO.getHasClassloader() instanceof HasKnowledgeBuilder)) {
            throw new KiePMMLException(String.format("Expecting HasKnowledgeBuilder, received %s", compilationDTO.getHasClassloader().getClass().getName()));
        }
        try {
            HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
            KiePMMLDroolsAST kiePMMLDroolsAST = this.getKiePMMLDroolsASTCommon(compilationDTO.getFields(), compilationDTO.getModel(), fieldTypeMap);
            DroolsCompilationDTO<T> droolsCompilationDTO = DroolsCompilationDTO.fromCompilationDTO(compilationDTO, fieldTypeMap);
            Map<String, String> sourcesMap = this.getKiePMMLDroolsModelSourcesMap(droolsCompilationDTO);
            PackageDescr packageDescr = this.getPackageDescr(kiePMMLDroolsAST, compilationDTO.getPackageName());
            HasKnowledgeBuilder hasKnowledgeBuilder = (HasKnowledgeBuilder)compilationDTO.getHasClassloader();
            KnowledgeBuilderImpl knowledgeBuilder = (KnowledgeBuilderImpl)hasKnowledgeBuilder.getKnowledgeBuilder();
            String pkgUUID = PackageModel.getPkgUUID((ReleaseId)knowledgeBuilder.getReleaseId(), (String)compilationDTO.getPackageName());
            packageDescr.setPreferredPkgUUID(pkgUUID);
            Map<String, String> rulesSourceMap = Collections.unmodifiableMap(this.getRulesSourceMap(packageDescr));
            KiePMMLDroolsModelWithSources toReturn = new KiePMMLDroolsModelWithSources(compilationDTO.getModelName(), compilationDTO.getPackageName(), compilationDTO.getKieMiningFields(), compilationDTO.getKieOutputFields(), compilationDTO.getKieTargetFields(), sourcesMap, pkgUUID, rulesSourceMap);
            knowledgeBuilder.registerPackage(packageDescr);
            return toReturn;
        }
        catch (Exception e) {
            throw new KiePMMLException((Throwable)e);
        }
    }

    public KiePMMLModelWithSources getKiePMMLModelWithSourcesCompiled(CompilationDTO<T> compilationDTO) {
        logger.trace("getKiePMMLModelWithSourcesCompiled {} {} {}", new Object[]{compilationDTO.getPackageName(), compilationDTO.getFields(), compilationDTO.getModel()});
        if (!(compilationDTO.getHasClassloader() instanceof HasKnowledgeBuilder)) {
            throw new KiePMMLException(String.format("Expecting HasKnowledgeBuilder, received %s", compilationDTO.getHasClassloader().getClass().getName()));
        }
        try {
            HasKnowledgeBuilder hasKnowledgeBuilder = (HasKnowledgeBuilder)compilationDTO.getHasClassloader();
            KnowledgeBuilderImpl knowledgeBuilder = (KnowledgeBuilderImpl)hasKnowledgeBuilder.getKnowledgeBuilder();
            HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
            KiePMMLDroolsAST kiePMMLDroolsAST = this.getKiePMMLDroolsASTCommon(compilationDTO.getFields(), compilationDTO.getModel(), fieldTypeMap);
            DroolsCompilationDTO<T> droolsCompilationDTO = DroolsCompilationDTO.fromCompilationDTO(compilationDTO, fieldTypeMap);
            Map<String, String> sourcesMap = this.getKiePMMLDroolsModelSourcesMap(droolsCompilationDTO);
            compilationDTO.compileAndLoadClass(sourcesMap);
            PackageDescr packageDescr = this.getPackageDescr(kiePMMLDroolsAST, compilationDTO.getPackageName());
            String pkgUUID = PackageModel.getPkgUUID((ReleaseId)knowledgeBuilder.getReleaseId(), (String)compilationDTO.getPackageName());
            packageDescr.setPreferredPkgUUID(pkgUUID);
            Map<String, String> rulesSourceMap = Collections.unmodifiableMap(this.getRulesSourceMap(packageDescr));
            KiePMMLDroolsModelWithSources toReturn = new KiePMMLDroolsModelWithSources(compilationDTO.getModelName(), compilationDTO.getPackageName(), compilationDTO.getKieMiningFields(), compilationDTO.getKieOutputFields(), compilationDTO.getKieTargetFields(), sourcesMap, pkgUUID, rulesSourceMap);
            CompositePackageDescr compositePackageDescr = new CompositePackageDescr(null, packageDescr);
            knowledgeBuilder.buildPackages(Collections.singletonList(compositePackageDescr));
            return toReturn;
        }
        catch (Exception e) {
            throw new KiePMMLException((Throwable)e);
        }
    }

    public PackageDescr getPackageDescr(KiePMMLDroolsAST kiePMMLDroolsAST, String packageName) {
        return KiePMMLDescrFactory.getBaseDescr(kiePMMLDroolsAST, packageName);
    }

    public abstract E getKiePMMLDroolsModel(DroolsCompilationDTO<T> var1);

    public abstract KiePMMLDroolsAST getKiePMMLDroolsAST(List<Field<?>> var1, T var2, Map<String, KiePMMLOriginalTypeGeneratedType> var3, List<KiePMMLDroolsType> var4);

    public abstract Map<String, String> getKiePMMLDroolsModelSourcesMap(DroolsCompilationDTO<T> var1) throws IOException;

    protected KiePMMLDroolsAST getKiePMMLDroolsASTCommon(List<Field<?>> fields, T model, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap) {
        List<KiePMMLDroolsType> types = fieldTypeMap.values().stream().map(kiePMMLOriginalTypeGeneratedType -> {
            String type = DATA_TYPE.byName((String)kiePMMLOriginalTypeGeneratedType.getOriginalType()).getMappedClass().getSimpleName();
            return new KiePMMLDroolsType(kiePMMLOriginalTypeGeneratedType.getGeneratedType(), type);
        }).collect(Collectors.toList());
        types.addAll(KiePMMLDataDictionaryASTFactory.factory(fieldTypeMap).declareTypes(fields));
        return this.getKiePMMLDroolsAST(fields, model, fieldTypeMap, types);
    }

    protected Map<String, String> getRulesSourceMap(PackageDescr packageDescr) {
        List<GeneratedFile> generatedRuleFiles = this.generateRulesFiles(packageDescr);
        return generatedRuleFiles.stream().collect(Collectors.toMap(generatedFile -> generatedFile.getPath().replace('/', '.').replace(".java", ""), generatedFile -> new String(generatedFile.getData())));
    }

    protected List<GeneratedFile> generateRulesFiles(PackageDescr packageDescr) {
        ModelBuilderImpl modelBuilder = new ModelBuilderImpl(PackageSources::dumpSources, (KnowledgeBuilderConfigurationImpl)KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration((ClassLoader)this.getClass().getClassLoader()), (ReleaseId)new ReleaseIdImpl("dummy:dummy:0.0.0"), false);
        CompositeKnowledgeBuilder batch = modelBuilder.batch();
        batch.add((Resource)new DescrResource((KieDescr)packageDescr), ResourceType.DESCR);
        try {
            batch.build();
            if (modelBuilder.hasErrors()) {
                StringBuilder builder = new StringBuilder();
                for (DroolsError error : modelBuilder.getErrors().getErrors()) {
                    logger.error(error.toString());
                    builder.append(error.toString()).append(" ");
                }
                throw new KiePMMLException(builder.toString());
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            StringBuilder builder = new StringBuilder(e.getMessage()).append(" ");
            for (DroolsError error : modelBuilder.getErrors().getErrors()) {
                logger.error(error.toString());
                builder.append(error.toString()).append(" ");
            }
            throw new RuntimeException(builder.toString(), e);
        }
        return this.generateModels((ModelBuilderImpl<PackageSources>)modelBuilder).stream().map(f -> new GeneratedFile(GeneratedFile.Type.RULE, f.getPath(), new String(f.getData()))).collect(Collectors.toList());
    }

    protected List<GeneratedFile> generateModels(ModelBuilderImpl<PackageSources> modelBuilder) {
        ArrayList<GeneratedFile> toReturn = new ArrayList<GeneratedFile>();
        for (PackageSources pkgSources : modelBuilder.getPackageSources()) {
            pkgSources.collectGeneratedFiles(toReturn);
        }
        return toReturn;
    }
}

