/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.ast.factories;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.True;
import org.junit.Test;
import org.kie.pmml.api.enums.ResultCode;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsRule;
import org.kie.pmml.models.drools.ast.factories.KiePMMLTruePredicateASTFactory;
import org.kie.pmml.models.drools.ast.factories.PredicateASTFactoryData;
import org.kie.pmml.models.drools.utils.KiePMMLASTTestUtils;

public class KiePMMLTruePredicateASTFactoryTest {
    @Test
    public void declareRuleFromTruePredicateNotFinalLeaf() {
        String parentPath = "_will play";
        String currentRule = "_will play_will play";
        ArrayList<KiePMMLDroolsRule> rules = new ArrayList<KiePMMLDroolsRule>();
        True truePredicate = new True();
        PredicateASTFactoryData predicateASTFactoryData = KiePMMLASTTestUtils.getPredicateASTFactoryData((Predicate)truePredicate, Collections.emptyList(), rules, parentPath, currentRule, Collections.emptyMap());
        KiePMMLTruePredicateASTFactory.factory((PredicateASTFactoryData)predicateASTFactoryData).declareRuleFromTruePredicateWithResult((Object)"DONE", false);
        Assertions.assertThat(rules).hasSize(1);
        KiePMMLDroolsRule retrieved = (KiePMMLDroolsRule)rules.get(0);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((String)retrieved.getName()).isEqualTo(currentRule);
        Assertions.assertThat((String)retrieved.getStatusToSet()).isEqualTo(currentRule);
        Assertions.assertThat((String)retrieved.getStatusConstraint()).isEqualTo(String.format("status == \"%s\"", parentPath));
        Assertions.assertThat((List)retrieved.getAndConstraints()).isNull();
        Assertions.assertThat((Comparable)retrieved.getResultCode()).isNull();
    }

    @Test
    public void declareRuleFromTruePredicateFinalLeaf() {
        String parentPath = "_will play";
        String currentRule = "_will play_will play";
        ArrayList<KiePMMLDroolsRule> rules = new ArrayList<KiePMMLDroolsRule>();
        String statusToSet = "DONE";
        True truePredicate = new True();
        PredicateASTFactoryData predicateASTFactoryData = KiePMMLASTTestUtils.getPredicateASTFactoryData((Predicate)truePredicate, Collections.emptyList(), rules, parentPath, currentRule, Collections.emptyMap());
        KiePMMLTruePredicateASTFactory.factory((PredicateASTFactoryData)predicateASTFactoryData).declareRuleFromTruePredicateWithResult((Object)statusToSet, true);
        Assertions.assertThat(rules).hasSize(1);
        KiePMMLDroolsRule retrieved = (KiePMMLDroolsRule)rules.get(0);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((String)retrieved.getName()).isEqualTo(currentRule);
        Assertions.assertThat((String)retrieved.getStatusToSet()).isEqualTo(statusToSet);
        Assertions.assertThat((String)retrieved.getStatusConstraint()).isEqualTo(String.format("status == \"%s\"", parentPath));
        Assertions.assertThat((List)retrieved.getAndConstraints()).isNull();
        Assertions.assertThat((Object)retrieved.getResult()).isEqualTo((Object)"DONE");
        Assertions.assertThat((Comparable)retrieved.getResultCode()).isEqualTo((Object)ResultCode.OK);
    }
}

