/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.commons.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.commons.model.KiePMMLExtension;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.models.drools.commons.model.KiePMMLDroolsModel;

public class KiePMMLDroolsModelTest {
    private static final String MODEL_NAME = "MODELNAME";
    private static final String KMODULE_PACKAGE_NAME = KiePMMLModelUtils.getSanitizedPackageName((String)"MODELNAME");
    private static final List<KiePMMLExtension> EXTENSIONS = new ArrayList<KiePMMLExtension>();
    private KiePMMLDroolsModel kiePMMLDroolsModel;

    @Before
    public void setup() {
        this.kiePMMLDroolsModel = new KiePMMLDroolsModelFake(MODEL_NAME, KMODULE_PACKAGE_NAME, EXTENSIONS);
    }

    @Test
    public void constructor() {
        Assertions.assertThat((String)this.kiePMMLDroolsModel.getName()).isEqualTo(MODEL_NAME);
        Assertions.assertThat((List)this.kiePMMLDroolsModel.getExtensions()).isEqualTo(EXTENSIONS);
        Assertions.assertThat((String)this.kiePMMLDroolsModel.getKModulePackageName()).isEqualTo(KiePMMLModelUtils.getSanitizedPackageName((String)MODEL_NAME));
    }

    @Test(expected=KiePMMLException.class)
    public void evaluateNoKieBase() {
        this.kiePMMLDroolsModel.evaluate((Object)"NOT_KIE_BASE", new HashMap(), null);
    }

    private final class KiePMMLDroolsModelFake
    extends KiePMMLDroolsModel {
        protected KiePMMLDroolsModelFake(String modelName, String kModulePackageName, List<KiePMMLExtension> extensions) {
            super(modelName, extensions);
            this.kModulePackageName = kModulePackageName;
        }

        public String getKModulePackageName() {
            return super.getKModulePackageName();
        }
    }
}

