/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.tree.compiler.factories;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.PMML;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.tree.TreeModel;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.pmml.compiler.testutils.TestUtils;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsAST;
import org.kie.pmml.models.drools.tree.compiler.factories.KiePMMLTreeModelASTFactory;
import org.kie.pmml.models.drools.utils.KiePMMLASTTestUtils;

public class KiePMMLTreeModelASTFactoryTest {
    private static final String SOURCE_GOLFING = "TreeSample.pmml";
    private static final String SOURCE_IRIS = "irisTree.pmml";
    private static final String SOURCE_SIMPLESET = "SimpleSetPredicateTree.pmml";
    private PMML golfingPmml;
    private TreeModel golfingModel;
    private PMML irisPmml;
    private TreeModel irisModel;
    private PMML simpleSetPmml;
    private TreeModel simpleSetModel;

    @Before
    public void setUp() throws Exception {
        this.golfingPmml = TestUtils.loadFromFile((String)SOURCE_GOLFING);
        Assert.assertNotNull((Object)this.golfingPmml);
        Assert.assertEquals((long)1L, (long)this.golfingPmml.getModels().size());
        Assert.assertTrue((boolean)(this.golfingPmml.getModels().get(0) instanceof TreeModel));
        this.golfingModel = (TreeModel)this.golfingPmml.getModels().get(0);
        this.irisPmml = TestUtils.loadFromFile((String)SOURCE_IRIS);
        Assert.assertNotNull((Object)this.irisPmml);
        Assert.assertEquals((long)1L, (long)this.irisPmml.getModels().size());
        Assert.assertTrue((boolean)(this.irisPmml.getModels().get(0) instanceof TreeModel));
        this.irisModel = (TreeModel)this.irisPmml.getModels().get(0);
        this.simpleSetPmml = TestUtils.loadFromFile((String)SOURCE_SIMPLESET);
        Assert.assertNotNull((Object)this.simpleSetPmml);
        Assert.assertEquals((long)1L, (long)this.simpleSetPmml.getModels().size());
        Assert.assertTrue((boolean)(this.simpleSetPmml.getModels().get(0) instanceof TreeModel));
        this.simpleSetModel = (TreeModel)this.simpleSetPmml.getModels().get(0);
    }

    @Test
    public void getKiePMMLDroolsGolfingAST() {
        Map fieldTypeMap = KiePMMLASTTestUtils.getFieldTypeMap((DataDictionary)this.golfingPmml.getDataDictionary(), (TransformationDictionary)this.golfingPmml.getTransformationDictionary(), (LocalTransformations)this.golfingModel.getLocalTransformations());
        List types = Collections.emptyList();
        KiePMMLDroolsAST retrieved = KiePMMLTreeModelASTFactory.getKiePMMLDroolsAST((DataDictionary)this.golfingPmml.getDataDictionary(), (TreeModel)this.golfingModel, (Map)fieldTypeMap, types);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals(types, (Object)retrieved.getTypes());
        Assert.assertFalse((boolean)retrieved.getRules().isEmpty());
    }

    @Test
    public void getKiePMMLDroolsIrisAST() {
        Map fieldTypeMap = KiePMMLASTTestUtils.getFieldTypeMap((DataDictionary)this.irisPmml.getDataDictionary(), (TransformationDictionary)this.irisPmml.getTransformationDictionary(), (LocalTransformations)this.irisModel.getLocalTransformations());
        List types = Collections.emptyList();
        KiePMMLDroolsAST retrieved = KiePMMLTreeModelASTFactory.getKiePMMLDroolsAST((DataDictionary)this.irisPmml.getDataDictionary(), (TreeModel)this.irisModel, (Map)fieldTypeMap, types);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals(types, (Object)retrieved.getTypes());
        Assert.assertFalse((boolean)retrieved.getRules().isEmpty());
    }

    @Test
    public void getKiePMMLDroolsSimpleSetAST() {
        Map fieldTypeMap = KiePMMLASTTestUtils.getFieldTypeMap((DataDictionary)this.simpleSetPmml.getDataDictionary(), (TransformationDictionary)this.simpleSetPmml.getTransformationDictionary(), (LocalTransformations)this.simpleSetModel.getLocalTransformations());
        List types = Collections.emptyList();
        KiePMMLDroolsAST retrieved = KiePMMLTreeModelASTFactory.getKiePMMLDroolsAST((DataDictionary)this.simpleSetPmml.getDataDictionary(), (TreeModel)this.simpleSetModel, (Map)fieldTypeMap, types);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals(types, (Object)retrieved.getTypes());
        Assert.assertFalse((boolean)retrieved.getRules().isEmpty());
    }
}

