/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.tree.compiler.executor;

import java.io.Externalizable;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.tree.TreeModel;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.core.util.ClassUtils;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.commons.model.abstracts.AbstractKiePMMLComponent;
import org.kie.pmml.compiler.api.dto.CommonCompilationDTO;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.compiler.commons.mocks.ExternalizableMock;
import org.kie.pmml.compiler.commons.utils.KiePMMLUtil;
import org.kie.pmml.models.drools.commons.implementations.HasKnowledgeBuilderMock;
import org.kie.pmml.models.drools.commons.model.KiePMMLDroolsModelWithSources;
import org.kie.pmml.models.drools.tree.compiler.executor.TreeModelImplementationProvider;
import org.kie.pmml.models.drools.tree.model.KiePMMLTreeModel;
import org.kie.test.util.filesystem.FileUtils;

public class TreeModelImplementationProviderTest {
    private static final TreeModelImplementationProvider PROVIDER = new TreeModelImplementationProvider();
    private static final String SOURCE_1 = "TreeSample.pmml";

    @Test
    public void getPMMLModelType() {
        Assert.assertEquals((Object)PMML_MODEL.TREE_MODEL, (Object)PROVIDER.getPMMLModelType());
    }

    @Test
    public void getKiePMMLModel() throws Exception {
        PMML pmml = this.getPMML(SOURCE_1);
        KnowledgeBuilderImpl knowledgeBuilder = new KnowledgeBuilderImpl();
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmml, (Model)((TreeModel)pmml.getModels().get(0)), (HasClassLoader)new HasKnowledgeBuilderMock(knowledgeBuilder));
        KiePMMLTreeModel retrieved = (KiePMMLTreeModel)PROVIDER.getKiePMMLModel((CompilationDTO)compilationDTO);
        Assert.assertNotNull((Object)retrieved);
        this.commonVerifyIsDeepCloneable((AbstractKiePMMLComponent)retrieved);
    }

    @Test
    public void getKiePMMLModelWithSources() throws Exception {
        PMML pmml = this.getPMML(SOURCE_1);
        KnowledgeBuilderImpl knowledgeBuilder = new KnowledgeBuilderImpl();
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmml, (Model)((TreeModel)pmml.getModels().get(0)), (HasClassLoader)new HasKnowledgeBuilderMock(knowledgeBuilder));
        KiePMMLDroolsModelWithSources retrieved = PROVIDER.getKiePMMLModelWithSources((CompilationDTO)compilationDTO);
        Assert.assertNotNull((Object)retrieved);
        this.commonVerifyIsDeepCloneable((AbstractKiePMMLComponent)retrieved);
    }

    private PMML getPMML(String source) throws Exception {
        FileInputStream fis = FileUtils.getFileInputStream((String)source);
        PMML toReturn = KiePMMLUtil.load((InputStream)fis, (String)source);
        Assert.assertNotNull((Object)toReturn);
        Assert.assertEquals((long)1L, (long)toReturn.getModels().size());
        Assert.assertTrue((boolean)(toReturn.getModels().get(0) instanceof TreeModel));
        return toReturn;
    }

    private void commonVerifyIsDeepCloneable(AbstractKiePMMLComponent toVerify) {
        Assert.assertTrue((boolean)(toVerify instanceof Serializable));
        ExternalizableMock externalizableMock = new ExternalizableMock();
        externalizableMock.setKiePMMLComponent(toVerify);
        ClassUtils.deepClone((Externalizable)externalizableMock);
    }
}

