/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.tree.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.models.tests.AbstractPMMLTest;

@RunWith(value=Parameterized.class)
@Ignore
public class CompoundPredicateTreeTest
extends AbstractPMMLTest {
    private static final String FILE_NAME = "CompoundPredicatesTree.pmml";
    private static final String MODEL_NAME = "CompoundPredicatesTreeModel";
    private static final String TARGET_FIELD = "Predicted_result";
    private static PMMLRuntime pmmlRuntime;
    private double input1;
    private double input2;
    private double input3;
    private String expectedResult;

    public CompoundPredicateTreeTest(double input1, double input2, double input3, String expectedResult) {
        this.input1 = input1;
        this.input2 = input2;
        this.input3 = input3;
        this.expectedResult = expectedResult;
    }

    @BeforeClass
    public static void setupClass() {
        pmmlRuntime = CompoundPredicateTreeTest.getPMMLRuntime((String)FILE_NAME);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({7.1, 7.1, 7.1, "classRootNode"}, {-5.01, 0, 0, "classOrAndNestedNode"}, {105, -5.5, 0, "classOrAndNestedNode"}, {2, 2, 2, "classOrNode"}, {2.1, 3.5, 2.1, "classOrNode"}, {0.1, 10, 10, "classAndNode"}, {6, 7.1, 7.1, "classXorNode"}, {6, 6.5, 7.1, "classRootNode"}, {3, 6.5, 7.7, "classXorNode"});
    }

    @Test
    public void testCompoundPredicate() {
        HashMap<String, Double> inputData = new HashMap<String, Double>();
        inputData.put("input1", this.input1);
        inputData.put("input2", this.input2);
        inputData.put("input3", this.input3);
        PMML4Result pmml4Result = this.evaluate(pmmlRuntime, inputData, MODEL_NAME);
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isNotNull();
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isEqualTo((Object)this.expectedResult);
    }
}

