/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.tree.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.models.tests.AbstractPMMLTest;

@RunWith(value=Parameterized.class)
public class PlanActivityTreeTest
extends AbstractPMMLTest {
    private static final String FILE_NAME = "PlanActivityTree.pmml";
    private static final String MODEL_NAME = "PlanActivityTreeModel";
    private static final String TARGET_FIELD = "Predicted_activity";
    private static PMMLRuntime pmmlRuntime;
    private String workToDo;
    private String weather;
    private boolean friendsAvailable;
    private String activity;

    public PlanActivityTreeTest(String workToDo, String weather, boolean friendsAvailable, String activity) {
        this.workToDo = workToDo;
        this.weather = weather;
        this.friendsAvailable = friendsAvailable;
        this.activity = activity;
    }

    @BeforeClass
    public static void setupClass() {
        pmmlRuntime = PlanActivityTreeTest.getPMMLRuntime((String)FILE_NAME);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({"YES", "sunny", false, "stay in"}, {"YES", "rainy", true, "stay in"}, {"NO", "sunny", true, "go to beach"}, {"NO", "overcast", false, "go running"}, {"NO", "rainy", true, "stay in"}, {"NO", "rainy", false, "go to movie"});
    }

    @Test
    public void testPlanActivity() {
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("workToDo", this.workToDo);
        inputData.put("weather", this.weather);
        inputData.put("friendsAvailable", this.friendsAvailable);
        PMML4Result pmml4Result = this.evaluate(pmmlRuntime, inputData, MODEL_NAME);
        Object result = pmml4Result.getResultVariables().get(TARGET_FIELD);
        Assertions.assertThat(result).isNotNull();
        Assertions.assertThat(result).isEqualTo((Object)this.activity);
    }
}

