/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.mining.model.enums;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.Stream;
import org.kie.pmml.commons.exceptions.KieEnumException;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;
import org.kie.pmml.commons.model.tuples.KiePMMLValueWeight;

public enum MULTIPLE_MODEL_METHOD {
    MAJORITY_VOTE("majorityVote", inputData -> {
        Map groupedValues = MULTIPLE_MODEL_METHOD.objectStream(inputData.values().stream()).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        Object toReturn = null;
        long currentMax = 0L;
        for (Map.Entry entry : groupedValues.entrySet()) {
            if (entry.getValue() <= currentMax) continue;
            toReturn = entry.getKey();
            currentMax = entry.getValue();
        }
        if (toReturn == null) {
            throw new KieEnumException("Failed to retrieve MAJORITY_VOTE");
        }
        return toReturn;
    }),
    WEIGHTED_MAJORITY_VOTE("weightedMajorityVote", inputData -> {
        throw new KieEnumException("WEIGHTED_MAJORITY_VOTE not implemented, yet");
    }),
    AVERAGE("average", inputData -> MULTIPLE_MODEL_METHOD.doubleStream(inputData.values().stream(), "AVERAGE").average().orElseThrow(() -> new KieEnumException("Failed to get AVERAGE"))),
    WEIGHTED_AVERAGE("weightedAverage", inputData -> {
        AtomicReference<Double> weightedSum = new AtomicReference<Double>(0.0);
        AtomicReference<Double> weights = new AtomicReference<Double>(0.0);
        MULTIPLE_MODEL_METHOD.valueWeightStream(inputData.values().stream(), "WEIGHTED_AVERAGE").forEach(elem -> {
            weightedSum.accumulateAndGet(elem.weightedValue(), Double::sum);
            weights.accumulateAndGet(elem.getWeight(), Double::sum);
        });
        return weightedSum.get() / weights.get();
    }),
    MEDIAN("median", inputData -> {
        DoubleStream sortedValues = MULTIPLE_MODEL_METHOD.doubleStream(inputData.values().stream(), "MEDIAN").sorted();
        OptionalDouble toReturn = inputData.size() % 2 == 0 ? sortedValues.skip((long)(inputData.size() / 2) - 1L).limit(2L).average() : sortedValues.skip(inputData.size() / 2).findFirst();
        return toReturn.orElseThrow(() -> new KieEnumException("Failed to get MEDIAN"));
    }),
    WEIGHTED_MEDIAN("x-weightedMedian", inputData -> {
        List kiePMMLValueWeights = MULTIPLE_MODEL_METHOD.valueWeightStream(inputData.values().stream(), "WEIGHTED_MEDIAN").sorted((o1, o2) -> {
            int toReturn = 0;
            if (o1.getValue() > o2.getValue()) {
                toReturn = 1;
            } else if (o1.getValue() < o2.getValue()) {
                toReturn = -1;
            }
            return toReturn;
        }).collect(Collectors.toList());
        double weightsSum = kiePMMLValueWeights.stream().map(KiePMMLValueWeight::getWeight).reduce(Double::sum).orElseThrow(() -> new KieEnumException("Failed to get WEIGHTED_MEDIAN"));
        double weightsMedian = weightsSum / 2.0;
        double weightedMedianSum = 0.0;
        for (KiePMMLValueWeight kiePMMLValueWeight : kiePMMLValueWeights) {
            if (!((weightedMedianSum += kiePMMLValueWeight.getWeight()) > weightsMedian)) continue;
            return kiePMMLValueWeight.getValue();
        }
        throw new KieEnumException("Failed to get WEIGHTED_MEDIAN");
    }),
    MAX("max", inputData -> MULTIPLE_MODEL_METHOD.doubleStream(inputData.values().stream(), "MAX").max().orElseThrow(() -> new KieEnumException("Failed to get MAX"))),
    SUM("sum", inputData -> MULTIPLE_MODEL_METHOD.doubleStream(inputData.values().stream(), "SUM").sum()),
    WEIGHTED_SUM("x-weightedSum", inputData -> MULTIPLE_MODEL_METHOD.valueWeightStream(inputData.values().stream(), "WEIGHTED_SUM").mapToDouble(KiePMMLValueWeight::weightedValue).sum()),
    SELECT_FIRST("selectFirst", inputData -> {
        if (inputData.entrySet().iterator().hasNext()) {
            Object toReturn = ((KiePMMLNameValue)inputData.entrySet().iterator().next().getValue()).getValue();
            if (toReturn instanceof KiePMMLValueWeight) {
                toReturn = ((KiePMMLValueWeight)toReturn).getValue();
            }
            return toReturn;
        }
        throw new KieEnumException("Failed to SELECT_FIRST");
    }),
    SELECT_ALL("selectAll", inputData -> MULTIPLE_MODEL_METHOD.objectStream(inputData.values().stream()).filter(Objects::nonNull).map(value -> {
        if (value instanceof KiePMMLValueWeight) {
            return ((KiePMMLValueWeight)value).getValue();
        }
        return value;
    }).collect(Collectors.toList())),
    MODEL_CHAIN("modelChain", inputData -> {
        throw new KieEnumException("MODEL_CHAIN not implemented, yet");
    });

    private final String name;
    private final Function<LinkedHashMap<String, KiePMMLNameValue>, Object> function;

    private MULTIPLE_MODEL_METHOD(String v, Function<LinkedHashMap<String, KiePMMLNameValue>, Object> function) {
        this.name = v;
        this.function = function;
    }

    private static Stream<Object> objectStream(Stream<KiePMMLNameValue> toUnwrap) {
        return toUnwrap.map(KiePMMLNameValue::getValue);
    }

    private static Stream<KiePMMLValueWeight> valueWeightStream(Stream<KiePMMLNameValue> toUnwrap, String enumName) {
        return toUnwrap.map(KiePMMLNameValue::getValue).map(elem -> {
            if (!(elem instanceof KiePMMLValueWeight)) {
                throw new KieEnumException("Failed to get " + enumName + ". Expecting KiePMMLValueWeight, found " + elem.getClass().getSimpleName());
            }
            return (KiePMMLValueWeight)elem;
        });
    }

    private static DoubleStream doubleStream(Stream<KiePMMLNameValue> toUnwrap, String enumName) {
        return MULTIPLE_MODEL_METHOD.valueWeightStream(toUnwrap, enumName).mapToDouble(KiePMMLValueWeight::getValue);
    }

    public static MULTIPLE_MODEL_METHOD byName(String name) {
        return Arrays.stream(MULTIPLE_MODEL_METHOD.values()).filter(value -> name.equals(value.name)).findFirst().orElseThrow(() -> new KieEnumException("Failed to find MULTIPLE_MODEL_METHOD with name: " + name));
    }

    public String getName() {
        return this.name;
    }

    public Object apply(LinkedHashMap<String, KiePMMLNameValue> inputData) {
        return this.function.apply(inputData);
    }
}

