/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.mining.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.evaluator.api.executor.PMMLRuntime;
import org.kie.pmml.mining.tests.AbstractPMMLMiningTest;

@RunWith(value=Parameterized.class)
@Ignore(value="DROOLS-5638")
public class SegmentationMajorityVoteMiningTest
extends AbstractPMMLMiningTest {
    private static final String MODEL_NAME = "SegmentationClassificationMajorityVote";
    private static final String TARGET_FIELD = "result";
    private static PMMLRuntime pmmlRuntime;
    private double input1;
    private double input2;
    private double input3;
    private String result;

    public SegmentationMajorityVoteMiningTest(double input1, double input2, double input3, String result) {
        this.input1 = input1;
        this.input2 = input2;
        this.input3 = input3;
        this.result = result;
    }

    @BeforeClass
    public static void setupClass() {
        pmmlRuntime = SegmentationMajorityVoteMiningTest.getPMMLRuntime(MODEL_NAME);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({-15.5, -51, 12, "classB"}, {-15.5, -51, 1001, "classB"}, {705, -51, 11, "classB"}, {-15.5, -40, 12, "classB"}, {0, -42, 50, "classA"}, {-17, -42, 50, "classA"}, {0, 1000, 50, "classA"}, {0, -42, -1000, "classA"}, {90, -5, 210, "classC"}, {-50, -5, 210, "classC"}, {90, -2000, 210, "classC"}, {90, -5, 195, "classC"});
    }

    @Test
    public void testSegmentationMajorityVoteTest() {
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("input1", this.input1);
        inputData.put("input2", this.input2);
        inputData.put("input3", this.input3);
        PMML4Result pmml4Result = this.evaluate(pmmlRuntime, inputData, MODEL_NAME);
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isNotNull();
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isEqualTo((Object)this.result);
    }
}

