/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.mining.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.pmml.api.models.PMMLStep;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.evaluator.core.implementations.PMMLRuntimeStep;
import org.kie.pmml.models.tests.AbstractPMMLTest;

@RunWith(value=Parameterized.class)
public class MiningListenerTest
extends AbstractPMMLTest {
    private static final String FILE_NAME = "MultipleMining.pmml";
    private static final String MODEL_NAME = "MixedMining";
    private static PMMLRuntime pmmlRuntime;
    private String categoricalX;
    private String categoricalY;
    private double age;
    private String occupation;
    private String residenceState;
    private boolean validLicense;

    public MiningListenerTest(String categoricalX, String categoricalY, double age, String occupation, String residenceState, boolean validLicense) {
        this.categoricalX = categoricalX;
        this.categoricalY = categoricalY;
        this.age = age;
        this.occupation = occupation;
        this.residenceState = residenceState;
        this.validLicense = validLicense;
    }

    @BeforeClass
    public static void setupClass() {
        pmmlRuntime = MiningListenerTest.getPMMLRuntime((String)FILE_NAME);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({"red", "classA", 25.0, "ASTRONAUT", "AP", true}, {"blue", "classA", 2.3, "PROGRAMMER", "KN", true}, {"yellow", "classC", 333.56, "INSTRUCTOR", "TN", false}, {"orange", "classB", 0.12, "ASTRONAUT", "KN", true}, {"green", "classC", 122.12, "TEACHER", "TN", false}, {"green", "classB", 11.33, "INSTRUCTOR", "AP", false}, {"orange", "classB", 423.2, "SKYDIVER", "KN", true});
    }

    @Test
    public void testMixedMining() {
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("categoricalX", this.categoricalX);
        inputData.put("categoricalY", this.categoricalY);
        inputData.put("age", this.age);
        inputData.put("occupation", this.occupation);
        inputData.put("residenceState", this.residenceState);
        inputData.put("validLicense", this.validLicense);
        Set pmmlListeners = IntStream.range(0, 3).mapToObj(i -> this.getPMMLListener()).collect(Collectors.toSet());
        this.evaluate(pmmlRuntime, inputData, MODEL_NAME, pmmlListeners);
        List retrieved = ((AbstractPMMLTest.PMMLListenerTest)pmmlListeners.iterator().next()).getSteps();
        retrieved.stream().filter(pmmlStep -> !(pmmlStep instanceof PMMLRuntimeStep)).collect(Collectors.toList()).forEach(this::commonValidateStep);
        this.commonValidateListeners(pmmlListeners, retrieved);
    }

    private void commonValidateStep(PMMLStep toValidate) {
        Map retrieved = toValidate.getInfo();
        Assertions.assertThat((boolean)retrieved.containsKey("SEGMENT")).isTrue();
        Assertions.assertThat((boolean)retrieved.containsKey("RESULT CODE")).isTrue();
        Assertions.assertThat((boolean)retrieved.containsKey("MODEL")).isTrue();
        Assertions.assertThat((boolean)retrieved.containsKey("RESULT")).isTrue();
    }
}

