/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.mining.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.models.tests.AbstractPMMLTest;

@RunWith(value=Parameterized.class)
public class MiningModelChainTest
extends AbstractPMMLTest {
    private static final String FILE_NAME = "MiningModelChain.pmml";
    private static final String MODEL_NAME = "SampleModelChainMine";
    private static final String TARGET_FIELD = "qualificationLevel";
    private final String AGE = "age";
    private final String OCCUPATION = "occupation";
    private final String RESIDENCESTATE = "residenceState";
    private final String VALIDLICENSE = "validLicense";
    private double age;
    private String occupation;
    private String residenceState;
    private boolean validLicense;
    private static PMMLRuntime pmmlRuntime;
    private String expectedResult;

    public MiningModelChainTest(double age, String occupation, String residenceState, boolean validLicense, String expectedResult) {
        this.age = age;
        this.occupation = occupation;
        this.residenceState = residenceState;
        this.validLicense = validLicense;
        this.expectedResult = expectedResult;
    }

    @BeforeClass
    public static void setupClass() {
        pmmlRuntime = MiningModelChainTest.getPMMLRuntime((String)FILE_NAME);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({25.0, "ASTRONAUT", "AP", true, "Barely"}, {2.3, "PROGRAMMER", "KN", true, "Unqualified"}, {333.56, "INSTRUCTOR", "TN", false, "Well"}, {0.12, "ASTRONAUT", "KN", true, "Unqualified"}, {122.12, "TEACHER", "TN", false, "Well"}, {11.33, "INSTRUCTOR", "AP", false, "Unqualified"}, {423.2, "SKYDIVER", "KN", true, "Barely"});
    }

    @Test
    public void testMiningModelChain() throws Exception {
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("age", this.age);
        inputData.put("occupation", this.occupation);
        inputData.put("residenceState", this.residenceState);
        inputData.put("validLicense", this.validLicense);
        PMML4Result pmml4Result = this.evaluate(pmmlRuntime, inputData, MODEL_NAME);
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isNotNull();
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isEqualTo((Object)this.expectedResult);
    }
}

