/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.regression.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.models.tests.AbstractPMMLTest;

public class PredictorTermRegressionTest
extends AbstractPMMLTest {
    private static final String FILE_NAME_NO_SUFFIX = "PredictorTermRegression";
    private static final String MODEL_NAME = "PredictorTermRegression";
    private static final String TARGET_FIELD = "result";
    private static PMMLRuntime pmmlRuntime;
    private double x;
    private double y;
    private double z;

    public void initPredictorTermRegressionTest(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @BeforeAll
    public static void setupClass() {
        pmmlRuntime = PredictorTermRegressionTest.getPMMLRuntime((String)"PredictorTermRegression");
    }

    public static Collection<Object[]> data() {
        return Arrays.asList({0, 0, 0}, {-1, 2, 3}, {0.5, -2.5, 4}, {3, 1, 2}, {25, 50, 15}, {-100, 250, -10}, {-100.1, 800, 105}, {-8, 12.5, 230}, {-1001, -500, 8}, {-1701, 508, 9});
    }

    private static double regressionFunction(double x, double y, double z) {
        return 2.0 * x + y + 5.0 * z * z + 4.0 * y * z - 2.5 * x * y * z + 5.0;
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void testPredictorTermRegression(double x, double y, double z) {
        this.initPredictorTermRegressionTest(x, y, z);
        HashMap<String, Double> inputData = new HashMap<String, Double>();
        inputData.put("x", x);
        inputData.put("y", y);
        inputData.put("z", z);
        PMML4Result pmml4Result = this.evaluate(pmmlRuntime, inputData, "PredictorTermRegression", "PredictorTermRegression");
        Assertions.assertThat((Object)pmml4Result).isNotNull();
        Assertions.assertThat((Map)pmml4Result.getResultVariables()).containsKey((Object)TARGET_FIELD);
        Assertions.assertThat((Double)((Double)pmml4Result.getResultVariables().get(TARGET_FIELD))).isEqualTo(PredictorTermRegressionTest.regressionFunction(x, y, z));
    }
}

