/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.tests;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.kie.api.pmml.PMML4Result;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.pmml.api.PMMLRuntimeFactory;
import org.kie.pmml.api.models.PMMLStep;
import org.kie.pmml.api.runtime.PMMLContext;
import org.kie.pmml.api.runtime.PMMLListener;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.evaluator.assembler.factories.PMMLRuntimeFactoryImpl;
import org.kie.pmml.evaluator.core.PMMLContextImpl;
import org.kie.pmml.evaluator.core.utils.PMMLRequestDataBuilder;
import org.kie.test.util.filesystem.FileUtils;

public class AbstractPMMLTest {
    private static final PMMLRuntimeFactory PMML_RUNTIME_FACTORY = new PMMLRuntimeFactoryImpl();

    protected static PMMLRuntime getPMMLRuntime(String fileName) {
        File pmmlFile = FileUtils.getFile((String)fileName);
        return PMML_RUNTIME_FACTORY.getPMMLRuntimeFromFile(pmmlFile);
    }

    protected static PMMLRequestData getPMMLRequestData(String modelName, Map<String, Object> parameters) {
        String correlationId = "CORRELATION_ID";
        PMMLRequestDataBuilder pmmlRequestDataBuilder = new PMMLRequestDataBuilder(correlationId, modelName);
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            Object pValue = entry.getValue();
            Class<?> class1 = pValue.getClass();
            pmmlRequestDataBuilder.addParameter(entry.getKey(), pValue, class1);
        }
        return pmmlRequestDataBuilder.build();
    }

    protected PMML4Result evaluate(PMMLRuntime pmmlRuntime, Map<String, Object> inputData, String modelName) {
        PMMLRequestData pmmlRequestData = AbstractPMMLTest.getPMMLRequestData(modelName, inputData);
        return pmmlRuntime.evaluate(modelName, (PMMLContext)new PMMLContextImpl(pmmlRequestData));
    }

    protected PMML4Result evaluate(PMMLRuntime pmmlRuntime, Map<String, Object> inputData, String modelName, Set<PMMLListener> pmmlListeners) {
        PMMLRequestData pmmlRequestData = AbstractPMMLTest.getPMMLRequestData(modelName, inputData);
        return pmmlRuntime.evaluate(modelName, (PMMLContext)new PMMLContextImpl(pmmlRequestData, pmmlListeners));
    }

    protected PMMLListenerTest getPMMLListener() {
        return new PMMLListenerTest();
    }

    protected void commonValidateListeners(Set<PMMLListener> toValidate, List<PMMLStep> expectedSteps) {
        toValidate.forEach(listener -> this.commonValidateListener((PMMLListenerTest)listener, expectedSteps));
    }

    private void commonValidateListener(PMMLListenerTest toValidate, List<PMMLStep> expectedSteps) {
        Assert.assertEquals(expectedSteps, toValidate.getSteps());
    }

    protected static class PMMLListenerTest
    implements PMMLListener {
        private List<PMMLStep> steps = new ArrayList<PMMLStep>();

        protected PMMLListenerTest() {
        }

        public List<PMMLStep> getSteps() {
            return this.steps;
        }

        public void stepExecuted(PMMLStep step) {
            this.steps.add(step);
        }
    }
}

