/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.tree.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.models.tests.AbstractPMMLTest;

@RunWith(value=Parameterized.class)
public class SampleMineTreeModelWithTransformationsTest
extends AbstractPMMLTest {
    private static final String FILE_NAME = "SampleMineTreeModelWithTransformations.pmml";
    private static final String MODEL_NAME = "SampleMineTreeModelWithTransformations";
    private static final String TARGET_FIELD = "decision";
    private static final String OUT_DER_TEMPERATURE = "out_der_temperature";
    private static final String OUT_DER_FUN_HUMIDITY_APPLY = "out_der_fun_humidity_apply";
    private static final String OUT_DER_CONSTANT = "out_der_constant";
    private static final String CONSTANT = "constant";
    private static final String WEATHERDECISION = "weatherdecision";
    private static final String OUT_NORMDISCRETE_FIELD = "out_normdiscrete_field";
    private static final String OUT_DISCRETIZE_FIELD = "out_discretize_field";
    private static final String OUT_MAPVALUED_FIELD = "out_mapvalued_field";
    private static final String OUT_TEXT_INDEX_NORMALIZATION_FIELD = "out_text_index_normalization_field";
    private static final String TEXT_INPUT = "Testing the app for a few days convinced me the interfaces are excellent!";
    private static PMMLRuntime pmmlRuntime;
    private double temperature;
    private double humidity;
    private String expectedResult;

    public SampleMineTreeModelWithTransformationsTest(double temperature, double humidity, String expectedResult) {
        this.temperature = temperature;
        this.humidity = humidity;
        this.expectedResult = expectedResult;
    }

    @BeforeClass
    public static void setupClass() {
        pmmlRuntime = SampleMineTreeModelWithTransformationsTest.getPMMLRuntime((String)FILE_NAME);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({30.0, 10.0, "sunglasses"}, {5.0, 70.0, "umbrella"}, {10.0, 15.0, "nothing"});
    }

    @Test
    public void testSampleMineTreeModelWithTransformations() throws Exception {
        String expected;
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("temperature", this.temperature);
        inputData.put("humidity", this.humidity);
        inputData.put("text_input", TEXT_INPUT);
        inputData.put("input3", 34.1);
        PMML4Result pmml4Result = this.evaluate(pmmlRuntime, inputData, MODEL_NAME);
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isNotNull();
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isEqualTo((Object)this.expectedResult);
        Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_DER_TEMPERATURE)).isEqualTo((Object)this.temperature);
        Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_DER_FUN_HUMIDITY_APPLY)).isEqualTo((Object)this.humidity);
        Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_DER_CONSTANT)).isEqualTo((Object)CONSTANT);
        Assertions.assertThat(pmml4Result.getResultVariables().get(WEATHERDECISION)).isEqualTo((Object)this.expectedResult);
        Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_NORMDISCRETE_FIELD)).isNotNull();
        if (this.expectedResult.equals("umbrella")) {
            Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_NORMDISCRETE_FIELD)).isEqualTo((Object)"1.0");
        } else {
            Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_NORMDISCRETE_FIELD)).isEqualTo((Object)"0.0");
        }
        Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_DISCRETIZE_FIELD)).isNotNull();
        if (this.temperature > 4.2 && this.temperature < 9.8) {
            Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_DISCRETIZE_FIELD)).isEqualTo((Object)"abc");
        } else if (this.temperature >= 15.4 && this.temperature < 32.1) {
            Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_DISCRETIZE_FIELD)).isEqualTo((Object)"def");
        } else {
            Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_DISCRETIZE_FIELD)).isEqualTo((Object)"defaultValue");
        }
        Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_MAPVALUED_FIELD)).isNotNull();
        switch (this.expectedResult) {
            case "sunglasses": {
                expected = "sun";
                break;
            }
            case "umbrella": {
                expected = "rain";
                break;
            }
            case "nothing": {
                expected = "dunno";
                break;
            }
            default: {
                throw new Exception("Unexpected expectedResult " + this.expectedResult);
            }
        }
        Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_MAPVALUED_FIELD)).isEqualTo((Object)expected);
        Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_TEXT_INDEX_NORMALIZATION_FIELD)).isNotNull();
        Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_TEXT_INDEX_NORMALIZATION_FIELD)).isEqualTo((Object)1.0);
    }

    @Test(expected=KiePMMLException.class)
    public void testSampleMineTreeModelWithTransformationsWithoutRequired() {
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("temperature", this.temperature);
        inputData.put("humidity", this.humidity);
        inputData.put("text_input", TEXT_INPUT);
        this.evaluate(pmmlRuntime, inputData, MODEL_NAME);
    }

    @Test
    public void testSampleMineTreeModelWithTransformationsConvertible() {
        HashMap<String, String> inputData = new HashMap<String, String>();
        inputData.put("temperature", String.valueOf(this.temperature));
        inputData.put("humidity", String.valueOf(this.humidity));
        inputData.put("text_input", TEXT_INPUT);
        inputData.put("input3", "34.1");
        Assertions.assertThat((Object)this.evaluate(pmmlRuntime, inputData, MODEL_NAME)).isNotNull();
    }

    @Test(expected=KiePMMLException.class)
    public void testSampleMineTreeModelWithTransformationsNotConvertible() {
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("temperature", this.temperature);
        inputData.put("humidity", this.humidity);
        inputData.put("text_input", TEXT_INPUT);
        inputData.put("input3", true);
        this.evaluate(pmmlRuntime, inputData, MODEL_NAME);
    }

    @Test(expected=KiePMMLException.class)
    public void testSampleMineTreeModelWithTransformationsInvalidValue() {
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("temperature", this.temperature);
        inputData.put("humidity", this.humidity);
        inputData.put("text_input", TEXT_INPUT);
        inputData.put("input3", 4.1);
        this.evaluate(pmmlRuntime, inputData, MODEL_NAME);
    }
}

