/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.tree.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.models.tests.AbstractPMMLTest;

@RunWith(value=Parameterized.class)
public class TestTreeTest
extends AbstractPMMLTest {
    private static final String FILE_NAME = "TestTree.pmml";
    private static final String MODEL_NAME = "SampleMine";
    private static final String TARGET_FIELD = "decision";
    private static PMMLRuntime pmmlRuntime;
    private double temperature;
    private double humidity;
    private String expectedResult;

    public TestTreeTest(double temperature, double humidity, String expectedResult) {
        this.temperature = temperature;
        this.humidity = humidity;
        this.expectedResult = expectedResult;
    }

    @BeforeClass
    public static void setupClass() {
        pmmlRuntime = TestTreeTest.getPMMLRuntime((String)FILE_NAME);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{{30.0, 10.0, "sunglasses"}});
    }

    @Test
    public void testIrisTree() {
        HashMap<String, Double> inputData = new HashMap<String, Double>();
        inputData.put("temperature", this.temperature);
        inputData.put("humidity", this.humidity);
        PMML4Result pmml4Result = this.evaluate(pmmlRuntime, inputData, MODEL_NAME);
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isNotNull();
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isEqualTo((Object)this.expectedResult);
    }
}

