/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.tree.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.models.tests.AbstractPMMLTest;

public class TestTreeTest
extends AbstractPMMLTest {
    private static final String FILE_NAME_NO_SUFFIX = "TestTree";
    private static final String MODEL_NAME = "SampleMine";
    private static final String TARGET_FIELD = "decision";
    private static PMMLRuntime pmmlRuntime;
    private double temperature;
    private double humidity;
    private String expectedResult;

    public void initTestTreeTest(double temperature, double humidity, String expectedResult) {
        this.temperature = temperature;
        this.humidity = humidity;
        this.expectedResult = expectedResult;
    }

    @BeforeAll
    public static void setupClass() {
        pmmlRuntime = TestTreeTest.getPMMLRuntime((String)FILE_NAME_NO_SUFFIX);
    }

    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{{30.0, 10.0, "sunglasses"}});
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void testIrisTree(double temperature, double humidity, String expectedResult) {
        this.initTestTreeTest(temperature, humidity, expectedResult);
        HashMap<String, Double> inputData = new HashMap<String, Double>();
        inputData.put("temperature", temperature);
        inputData.put("humidity", humidity);
        PMML4Result pmml4Result = this.evaluate(pmmlRuntime, inputData, FILE_NAME_NO_SUFFIX, MODEL_NAME);
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isNotNull();
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isEqualTo((Object)expectedResult);
    }
}

