/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.tree.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.models.tests.AbstractPMMLTest;

public class SimpleClassificationTreeTest
extends AbstractPMMLTest {
    private static final String FILE_NAME_NO_SUFFIX = "SimpleClassificationTree";
    private static final String MODEL_NAME = "SimpleClassificationTreeModel";
    private static final String TARGET_FIELD = "result";
    private static PMMLRuntime pmmlRuntime;
    private double input1;
    private double input2;
    private double input3;
    private String expectedResult;

    public void initSimpleClassificationTreeTest(double input1, double input2, double input3, String expectedResult) {
        this.input1 = input1;
        this.input2 = input2;
        this.input3 = input3;
        this.expectedResult = expectedResult;
    }

    @BeforeAll
    public static void setupClass() {
        pmmlRuntime = SimpleClassificationTreeTest.getPMMLRuntime((String)FILE_NAME_NO_SUFFIX);
    }

    public static Collection<Object[]> data() {
        return Arrays.asList({5, 0, 0, "classA"}, {2, -5, 0, "classB"}, {2, 7, 0, "classC"}, {10, 7, 0, "classB"}, {10, -7, 10, "classC"});
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void testSimpleClassificationTree(double input1, double input2, double input3, String expectedResult) {
        this.initSimpleClassificationTreeTest(input1, input2, input3, expectedResult);
        HashMap<String, Double> inputData = new HashMap<String, Double>();
        inputData.put("input1", input1);
        inputData.put("input2", input2);
        inputData.put("input3", input3);
        PMML4Result pmml4Result = this.evaluate(pmmlRuntime, inputData, FILE_NAME_NO_SUFFIX, MODEL_NAME);
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isNotNull();
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isEqualTo((Object)expectedResult);
    }
}

