/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Queue;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.remote.DroolsExecutor;

public class DroolsExecutorTest {
    private static final int ITERATIONS = 3;
    private static final String[] TEST_SIDE_EFFECTS = new String[]{"effect1", "effect2"};

    @Test
    public void testGetMaster() {
        DroolsExecutor master = DroolsExecutorTest.getMasterExecutor();
        Assertions.assertThat((Object)master).isInstanceOf(DroolsExecutor.Leader.class);
    }

    @Test
    public void testGetSlave() {
        DroolsExecutor slave = DroolsExecutorTest.getSlaveExecutor();
        Assertions.assertThat((Object)slave).isInstanceOf(DroolsExecutor.Slave.class);
    }

    @Test
    public void testExecuteRunnableOnMaster() {
        DroolsExecutor master = DroolsExecutorTest.getMasterExecutor();
        for (int i = 0; i < 3; ++i) {
            master.execute((Runnable)new DummyRunnable());
        }
        Queue results = master.getAndReset();
        Assertions.assertThat((Iterable)results).isNotNull();
        Assertions.assertThat((int)results.size()).isEqualTo(3);
        Assertions.assertThat((Iterable)results).containsOnly(new Object[]{DroolsExecutor.EmptyResult.INSTANCE});
        Assertions.assertThat((Iterable)master.getAndReset()).isEmpty();
    }

    @Test
    public void testExecuteSupplierOnMaster() {
        DroolsExecutor master = DroolsExecutorTest.getMasterExecutor();
        String testString = "test string";
        String resultString = (String)master.execute(() -> "test string");
        Assertions.assertThat((String)resultString).isEqualTo("test string");
        Queue results = master.getAndReset();
        Assertions.assertThat((Iterable)results).isNotNull();
        Assertions.assertThat((Iterable)results).hasSize(1);
        Assertions.assertThat(results.poll()).isEqualTo((Object)"test string");
        Assertions.assertThat((Iterable)master.getAndReset()).isEmpty();
    }

    @Test
    public void testExecuteOnSlave() {
        DroolsExecutor slave = DroolsExecutorTest.getSlaveExecutor();
        ArrayDeque<String> sideEffects = new ArrayDeque<String>(Arrays.asList(TEST_SIDE_EFFECTS));
        slave.appendSideEffects(sideEffects);
        slave.execute((Runnable)new DummyRunnable());
        ((AbstractStringAssert)Assertions.assertThat((String)((String)slave.execute(() -> "test"))).isNotNull()).isEqualTo(TEST_SIDE_EFFECTS[1]);
        Assertions.assertThat((String)((String)slave.execute(() -> "test"))).isNull();
    }

    private static DroolsExecutor getMasterExecutor() {
        DroolsExecutor.setAsLeader();
        return DroolsExecutor.getInstance();
    }

    private static DroolsExecutor getSlaveExecutor() {
        DroolsExecutor.setAsReplica();
        return DroolsExecutor.getInstance();
    }

    private class DummyRunnable
    implements Runnable {
        private DummyRunnable() {
        }

        @Override
        public void run() {
        }
    }
}

