/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.UrlMatchingStrategy;
import com.github.tomakehurst.wiremock.client.WireMock;
import javax.ws.rs.core.MediaType;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.kie.server.client.BaseKieServicesClientTest;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesClientException;
import org.kie.server.client.SerializationException;

public class KieServicesClientErrorHandlingTest
extends BaseKieServicesClientTest {
    private static BaseMatcher<SerializationException> serializationExceptionMatcher = new BaseMatcher<SerializationException>(){

        public boolean matches(Object o) {
            return o instanceof SerializationException;
        }

        public void describeTo(Description description) {
            description.appendText("SerializationException");
        }
    };
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();

    @Test
    public void testError404Handling() {
        this.expectedEx.expect(KieServicesClientException.class);
        this.expectedEx.expectMessage("Error code: 404");
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/containers")).withHeader("Accept", WireMock.equalTo((String)"application/xml")).willReturn(WireMock.aResponse().withStatus(404).withBody("Resource not found!")));
        KieServicesClient client = new KieServicesClient(this.mockServerBaseUri);
        client.listContainers();
    }

    @Test
    public void testError500Handling() {
        this.expectedEx.expect(KieServicesClientException.class);
        this.expectedEx.expectMessage("Error code: 500");
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/containers")).withHeader("Accept", WireMock.equalTo((String)"application/xml")).willReturn(WireMock.aResponse().withStatus(500).withBody("Internal server error!")));
        KieServicesClient client = new KieServicesClient(this.mockServerBaseUri);
        client.listContainers();
    }

    @Test
    public void testXmlDeserializationErrorHandling() {
        this.expectedEx.expect(KieServicesClientException.class);
        this.expectedEx.expectCause(serializationExceptionMatcher);
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/containers")).withHeader("Accept", WireMock.equalTo((String)"application/xml")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/xml").withBody("Some gibberish that can't be parsed by client!")));
        KieServicesClient client = new KieServicesClient(this.mockServerBaseUri);
        client.listContainers();
    }

    @Test
    public void testJsonDeserializationErrorHandling() {
        this.expectedEx.expect(KieServicesClientException.class);
        this.expectedEx.expectCause(serializationExceptionMatcher);
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/containers")).withHeader("Accept", WireMock.equalTo((String)"application/json")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/json").withBody("Some gibberish that can't be parsed by client!")));
        KieServicesClient client = new KieServicesClient(this.mockServerBaseUri, MediaType.APPLICATION_JSON_TYPE);
        client.listContainers();
    }
}

