/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.UrlMatchingStrategy;
import com.github.tomakehurst.wiremock.client.WireMock;
import org.junit.Assert;
import org.junit.Test;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.client.BaseKieServicesClientTest;
import org.kie.server.client.KieServicesClient;

public class KieServicesClientTest
extends BaseKieServicesClientTest {
    @Test
    public void testGetServerInfo() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/")).withHeader("Accept", WireMock.equalTo((String)"application/xml")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/xml").withBody("<response type=\"SUCCESS\" msg=\"Kie Server info\">\n  <kie-server-info>\n    <version>1.2.3</version>\n  </kie-server-info>\n</response>")));
        KieServicesClient client = new KieServicesClient(this.mockServerBaseUri);
        ServiceResponse response = client.getServerInfo();
        this.assertSuccess(response);
        Assert.assertEquals((String)"Server version", (Object)"1.2.3", (Object)((KieServerInfo)response.getResult()).getVersion());
    }

    @Test
    public void testListContainers() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/containers")).withHeader("Accept", WireMock.equalTo((String)"application/xml")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/xml").withBody("<response type=\"SUCCESS\" msg=\"List of created containers\">\n  <kie-containers>\n    <kie-container container-id=\"kjar1\" status=\"FAILED\"/>\n    <kie-container container-id=\"kjar2\" status=\"FAILED\"/>  </kie-containers></response>")));
        KieServicesClient client = new KieServicesClient(this.mockServerBaseUri);
        ServiceResponse response = client.listContainers();
        this.assertSuccess(response);
        Assert.assertEquals((String)"Number of listed containers", (long)2L, (long)((KieContainerResourceList)response.getResult()).getContainers().size());
    }

    @Test
    public void testCreateContainer() {
        WireMock.stubFor((MappingBuilder)WireMock.put((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/containers/kie1")).withHeader("Accept", WireMock.equalTo((String)"application/xml")).willReturn(WireMock.aResponse().withStatus(201).withHeader("Content-Type", "application/xml").withBody("<response type=\"SUCCESS\" msg=\"Container successfully deployed\">\n  <kie-container container-id=\"kie1\" status=\"STARTED\">\n    <release-id>\n      <group-id>org.kie.server.testing</group-id>\n      <artifact-id>kjar2</artifact-id>\n      <version>1.0-SNAPSHOT</version>\n    </release-id>\n    <resolved-release-id>\n      <group-id>org.kie.server.testing</group-id>\n      <artifact-id>kjar2</artifact-id>\n      <version>1.0-SNAPSHOT</version>\n    </resolved-release-id>\n  </kie-container>\n</response>")));
        KieServicesClient client = new KieServicesClient(this.mockServerBaseUri);
        ReleaseId releaseId = new ReleaseId("org.kie.server.testing", "kjar2", "1.0-SNAPSHOT");
        KieContainerResource resource = new KieContainerResource("kie1", releaseId);
        ServiceResponse response = client.createContainer("kie1", resource);
        this.assertSuccess(response);
        KieContainerResource container = (KieContainerResource)response.getResult();
        Assert.assertEquals((String)"Container id", (Object)"kie1", (Object)container.getContainerId());
        Assert.assertEquals((String)"Release id", (Object)releaseId, (Object)container.getReleaseId());
        Assert.assertEquals((String)"Resolved release Id", (Object)releaseId, (Object)container.getResolvedReleaseId());
    }

    private void assertSuccess(ServiceResponse<?> response) {
        Assert.assertEquals((String)"Response type", (Object)ServiceResponse.ResponseType.SUCCESS, (Object)response.getType());
    }
}

