/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.kie.remote.common.rest.KieRemoteHttpRequest;
import org.kie.remote.common.rest.KieRemoteHttpResponse;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.ServiceResponsesList;
import org.kie.server.client.JaxbSerializationProvider;
import org.kie.server.client.JsonSerializationProvider;
import org.kie.server.client.KieServicesClientException;
import org.kie.server.client.SerializationException;
import org.kie.server.client.SerializationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieServicesClient {
    private static Logger logger = LoggerFactory.getLogger(KieServicesClient.class);
    public static final long DEFAULT_REQUEST_TIMEOUT_MILLIS = 30000L;
    private final String baseURI;
    private final String username;
    private final String password;
    private final MediaType mediaType;
    private final long requestTimeoutMillis;
    private final SerializationProvider serializationProvider;

    public KieServicesClient(String baseURI) {
        this(baseURI, null, null, MediaType.APPLICATION_XML_TYPE);
    }

    public KieServicesClient(String baseURI, MediaType mediaType) {
        this(baseURI, null, null, mediaType);
    }

    public KieServicesClient(String baseURI, String username, String password) {
        this(baseURI, username, password, MediaType.APPLICATION_XML_TYPE);
    }

    public KieServicesClient(String baseURI, String username, String password, MediaType mediaType) {
        this(baseURI, username, password, mediaType, 30000L);
    }

    public KieServicesClient(String baseURI, String username, String password, MediaType mediaType, long requestTimeoutMillis) {
        this.baseURI = baseURI;
        this.username = username;
        this.password = password;
        this.mediaType = mediaType;
        this.requestTimeoutMillis = requestTimeoutMillis;
        if (MediaType.APPLICATION_XML_TYPE.equals((Object)mediaType)) {
            this.serializationProvider = new JaxbSerializationProvider();
        } else if (MediaType.APPLICATION_JSON_TYPE.equals((Object)mediaType)) {
            this.serializationProvider = new JsonSerializationProvider();
        } else {
            throw new RuntimeException("Unsupported media type '" + mediaType + "' specified!");
        }
    }

    public ServiceResponse<KieServerInfo> getServerInfo() {
        return this.makeHttpGetRequestAndCreateServiceResponse(this.baseURI, KieServerInfo.class);
    }

    public ServiceResponse<KieContainerResourceList> listContainers() {
        return this.makeHttpGetRequestAndCreateServiceResponse(this.baseURI + "/containers", KieContainerResourceList.class);
    }

    public ServiceResponse<KieContainerResource> createContainer(String id, KieContainerResource resource) {
        return this.makeHttpPutRequestAndCreateServiceResponse(this.baseURI + "/containers/" + id, resource, KieContainerResource.class);
    }

    public ServiceResponse<KieContainerResource> getContainerInfo(String id) {
        return this.makeHttpGetRequestAndCreateServiceResponse(this.baseURI + "/containers/" + id, KieContainerResource.class);
    }

    public ServiceResponse<Void> disposeContainer(String id) {
        return this.makeHttpDeleteRequestAndCreateServiceResponse(this.baseURI + "/containers/" + id, Void.class);
    }

    public ServiceResponse<String> executeCommands(String id, String payload) {
        return this.makeHttpPostRequestAndCreateServiceResponse(this.baseURI + "/containers/" + id, payload, String.class);
    }

    public ServiceResponsesList executeScript(CommandScript script) {
        return this.makeHttpPostRequestAndCreateCustomResult(this.baseURI, script, ServiceResponsesList.class);
    }

    public ServiceResponse<KieScannerResource> getScannerInfo(String id) {
        return this.makeHttpGetRequestAndCreateServiceResponse(this.baseURI + "/containers/" + id + "/scanner", KieScannerResource.class);
    }

    public ServiceResponse<KieScannerResource> updateScanner(String id, KieScannerResource resource) {
        return this.makeHttpPostRequestAndCreateServiceResponse(this.baseURI + "/containers/" + id + "/scanner", resource, KieScannerResource.class);
    }

    public ServiceResponse<ReleaseId> updateReleaseId(String id, ReleaseId releaseId) {
        return this.makeHttpPostRequestAndCreateServiceResponse(this.baseURI + "/containers/" + id + "/release-id", releaseId, ReleaseId.class);
    }

    private <T> ServiceResponse<T> makeHttpGetRequestAndCreateServiceResponse(String uri, Class<T> resultType) {
        KieRemoteHttpRequest request = this.newRequest(uri).get();
        KieRemoteHttpResponse response = request.response();
        if (response.code() == Response.Status.OK.getStatusCode()) {
            ServiceResponse serviceResponse = this.deserialize(response.body(), ServiceResponse.class);
            this.checkResultType(serviceResponse, resultType);
            return serviceResponse;
        }
        throw this.createExceptionForUnexpectedResponseCode(request, response);
    }

    private <T> ServiceResponse<T> makeHttpPostRequestAndCreateServiceResponse(String uri, Object bodyObject, Class<T> resultType) {
        return this.makeHttpPostRequestAndCreateServiceResponse(uri, this.serialize(bodyObject), resultType);
    }

    private <T> ServiceResponse<T> makeHttpPostRequestAndCreateServiceResponse(String uri, String body, Class<T> resultType) {
        KieRemoteHttpRequest request = this.newRequest(uri).body((CharSequence)body).post();
        KieRemoteHttpResponse response = request.response();
        if (response.code() == Response.Status.OK.getStatusCode()) {
            ServiceResponse serviceResponse = this.deserialize(response.body(), ServiceResponse.class);
            this.checkResultType(serviceResponse, resultType);
            return serviceResponse;
        }
        throw this.createExceptionForUnexpectedResponseCode(request, response);
    }

    private <T> T makeHttpPostRequestAndCreateCustomResult(String uri, Object bodyObject, Class<T> resultType) {
        return this.makeHttpPostRequestAndCreateCustomResult(uri, this.serialize(bodyObject), resultType);
    }

    private <T> T makeHttpPostRequestAndCreateCustomResult(String uri, String body, Class<T> resultType) {
        KieRemoteHttpRequest request = this.newRequest(uri).body((CharSequence)body).post();
        KieRemoteHttpResponse response = request.response();
        if (response.code() == Response.Status.OK.getStatusCode()) {
            return this.deserialize(response.body(), resultType);
        }
        throw this.createExceptionForUnexpectedResponseCode(request, response);
    }

    private <T> ServiceResponse<T> makeHttpPutRequestAndCreateServiceResponse(String uri, Object bodyObject, Class<T> resultType) {
        return this.makeHttpPutRequestAndCreateServiceResponse(uri, this.serialize(bodyObject), resultType);
    }

    private <T> ServiceResponse<T> makeHttpPutRequestAndCreateServiceResponse(String uri, String body, Class<T> resultType) {
        KieRemoteHttpRequest request = this.newRequest(uri).body((CharSequence)body).put();
        KieRemoteHttpResponse response = request.response();
        if (response.code() == Response.Status.CREATED.getStatusCode() || response.code() == Response.Status.BAD_REQUEST.getStatusCode()) {
            ServiceResponse serviceResponse = this.deserialize(response.body(), ServiceResponse.class);
            this.checkResultType(serviceResponse, resultType);
            return serviceResponse;
        }
        throw this.createExceptionForUnexpectedResponseCode(request, response);
    }

    private <T> ServiceResponse<T> makeHttpDeleteRequestAndCreateServiceResponse(String uri, Class<T> resultType) {
        KieRemoteHttpRequest request = this.newRequest(uri).delete();
        KieRemoteHttpResponse response = request.response();
        if (response.code() == Response.Status.OK.getStatusCode()) {
            ServiceResponse serviceResponse = this.deserialize(response.body(), ServiceResponse.class);
            this.checkResultType(serviceResponse, resultType);
            return serviceResponse;
        }
        throw this.createExceptionForUnexpectedResponseCode(request, response);
    }

    private KieRemoteHttpRequest newRequest(String uri) {
        KieRemoteHttpRequest httpRequest = KieRemoteHttpRequest.newRequest((String)uri).followRedirects(true).timeout(this.requestTimeoutMillis);
        httpRequest.accept(this.mediaType.toString());
        if (this.username != null && this.password != null) {
            httpRequest.basicAuthorization(this.username, this.password);
        }
        return httpRequest;
    }

    private String serialize(Object object) {
        try {
            return this.serializationProvider.serialize(object);
        }
        catch (SerializationException e) {
            throw new KieServicesClientException("Error while serializing request data!", e);
        }
    }

    private <T> T deserialize(String content, Class<T> type) {
        try {
            return this.serializationProvider.deserialize(content, type);
        }
        catch (SerializationException e) {
            throw new KieServicesClientException("Error while deserializing data received from server!", e);
        }
    }

    private void checkResultType(ServiceResponse<?> serviceResponse, Class<?> expectedResultType) {
        Object actualResult = serviceResponse.getResult();
        if (actualResult != null && !expectedResultType.isInstance(actualResult)) {
            throw new KieServicesClientException("Error while creating service response! The actual result type " + serviceResponse.getResult().getClass() + " does not match the expected type " + expectedResultType + "!");
        }
    }

    private RuntimeException createExceptionForUnexpectedResponseCode(KieRemoteHttpRequest request, KieRemoteHttpResponse response) {
        String summaryMessage = "Unexpected HTTP response code when requesting URI '" + request.getUri() + "'! Error code: " + response.code() + ", message: " + response.message();
        logger.debug(summaryMessage + ", response body: " + response.body());
        return new KieServicesClientException(summaryMessage);
    }
}

