/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.impl;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.ClientResponseFailure;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.plugins.server.tjws.TJWSEmbeddedJaxrsServer;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.GenericType;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.command.BatchExecutionCommand;
import org.kie.api.command.Command;
import org.kie.api.command.KieCommands;
import org.kie.api.runtime.ExecutionResults;
import org.kie.internal.runtime.helper.BatchExecutionHelper;
import org.kie.scanner.MavenRepository;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.api.commands.CallContainerCommand;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.commands.CreateContainerCommand;
import org.kie.server.api.commands.DisposeContainerCommand;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.api.model.KieServerCommand;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.client.KieServicesClient;
import org.kie.server.services.rest.KieServerRestImpl;

public class KieServerTest {
    private static final int PORT = KieServerTest.findFreePort();
    public static final String BASE_URI = "http://localhost:" + PORT + "/server";
    private static MavenRepository repository;
    private static ReleaseId releaseId1;
    private static ReleaseId releaseId2;
    private TJWSEmbeddedJaxrsServer server;
    private KieServicesClient client;

    @BeforeClass
    public static void initialize() throws Exception {
        KieServerTest.createAndDeployKJar(releaseId1);
        KieServerTest.createAndDeployKJar(releaseId2);
        RegisterBuiltin.register((ResteasyProviderFactory)ResteasyProviderFactory.getInstance());
    }

    @AfterClass
    public static void destroy() throws Exception {
    }

    @Before
    public void setup() throws Exception {
        this.startServer();
        this.startClient();
    }

    @After
    public void tearDown() {
        this.server.stop();
    }

    @Test
    public void testGetServerInfo() throws Exception {
        ServiceResponse reply = this.client.getServerInfo();
        Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)reply.getType());
        KieServerInfo info = (KieServerInfo)reply.getResult();
        Assert.assertEquals((Object)KieServerEnvironment.getVersion().toString(), (Object)info.getVersion());
        System.out.println(reply.getResult());
    }

    @Test
    public void testCreateContainer() throws Exception {
        ServiceResponse reply = this.client.createContainer("kie1", new KieContainerResource("kie1", releaseId1));
        Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)reply.getType());
    }

    @Test
    public void testCreateContainerNonExistingGAV() throws Exception {
        ServiceResponse reply = this.client.createContainer("kie1", new KieContainerResource("kie1", new ReleaseId("foo", "bar", "0.0.0")));
        Assert.assertEquals((Object)ServiceResponse.ResponseType.FAILURE, (Object)reply.getType());
    }

    @Test
    public void testCreateContainerNonExistingGAV2() throws Exception {
        KieContainerResource resource = new KieContainerResource("kie1", new ReleaseId("foo", "bar", "0.0.0"));
        ClientResponse response = null;
        try {
            ClientRequest clientRequest = new ClientRequest(BASE_URI + "/containers/" + resource.getContainerId());
            response = clientRequest.body(MediaType.APPLICATION_XML_TYPE, (Object)resource).put((GenericType)new GenericType<ServiceResponse<KieContainerResource>>(){});
            Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
            Assert.assertEquals((Object)ServiceResponse.ResponseType.FAILURE, (Object)((ServiceResponse)response.getEntity()).getType());
        }
        catch (Exception e) {
            throw new ClientResponseFailure("Unexpected exception creating container: " + resource.getContainerId() + " with release-id " + resource.getReleaseId(), (Throwable)e, response);
        }
    }

    @Test
    public void testCreateContainerEmptyBody() throws Exception {
        ClientResponse response = null;
        try {
            ClientRequest clientRequest = new ClientRequest(BASE_URI + "/containers/kie1");
            response = clientRequest.body(MediaType.APPLICATION_XML_TYPE, (Object)"").put((GenericType)new GenericType<ServiceResponse<KieContainerResource>>(){});
            Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        }
        catch (Exception e) {
            throw new ClientResponseFailure("Unexpected exception on empty body", (Throwable)e, response);
        }
    }

    @Test
    public void testGetContainerInfo() throws Exception {
        this.client.createContainer("kie1", new KieContainerResource("kie1", releaseId1));
        ServiceResponse reply = this.client.getContainerInfo("kie1");
        Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)reply.getType());
        KieContainerResource info = (KieContainerResource)reply.getResult();
        Assert.assertEquals((Object)KieContainerStatus.STARTED, (Object)info.getStatus());
    }

    @Test
    public void testGetContainerInfoNonExisting() throws Exception {
        ServiceResponse reply = this.client.getContainerInfo("kie1");
        Assert.assertEquals((Object)ServiceResponse.ResponseType.FAILURE, (Object)reply.getType());
    }

    @Test
    public void testListContainers() throws Exception {
        this.client.createContainer("kie1", new KieContainerResource("kie1", releaseId1));
        this.client.createContainer("kie2", new KieContainerResource("kie2", releaseId1));
        ServiceResponse reply = this.client.listContainers();
        Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)reply.getType());
        Assert.assertEquals((long)2L, (long)((KieContainerResourceList)reply.getResult()).getContainers().size());
    }

    @Test
    public void testDisposeContainer() throws Exception {
        this.client.createContainer("kie1", new KieContainerResource("kie1", releaseId1));
        ServiceResponse reply = this.client.disposeContainer("kie1");
        Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)reply.getType());
    }

    @Test
    public void testCallContainer() throws Exception {
        this.client.createContainer("kie1", new KieContainerResource("kie1", releaseId1));
        String payload = "<batch-execution lookup=\"defaultKieSession\">\n  <insert out-identifier=\"message\">\n    <org.pkg1.Message>\n      <text>Hello World</text>\n    </org.pkg1.Message>\n  </insert>\n  <fire-all-rules/>\n</batch-execution>";
        ServiceResponse reply = this.client.executeCommands("kie1", payload);
        Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)reply.getType());
    }

    @Test
    public void testUpdateVersion() throws Exception {
        this.client.createContainer("kie1", new KieContainerResource("kie1", releaseId1));
        ServiceResponse v = this.client.updateReleaseId("kie1", releaseId2);
        Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)v.getType());
        Assert.assertEquals((Object)releaseId2, (Object)v.getResult());
        ServiceResponse reply = this.client.disposeContainer("kie1");
        Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)reply.getType());
    }

    @Test
    public void testCallContainerMarshallCommands() throws Exception {
        this.client.createContainer("kie1", new KieContainerResource("kie1", releaseId1));
        KieServices ks = KieServices.Factory.get();
        File jar = MavenRepository.getMavenRepository().resolveArtifact((org.kie.api.builder.ReleaseId)releaseId1).getFile();
        URLClassLoader cl = new URLClassLoader(new URL[]{jar.toURI().toURL()});
        Class<?> messageClass = cl.loadClass("org.pkg1.Message");
        Object message = messageClass.newInstance();
        Method setter = messageClass.getMethod("setText", String.class);
        Method getter = messageClass.getMethod("getText", new Class[0]);
        setter.invoke(message, "HelloWorld");
        KieCommands kcmd = ks.getCommands();
        Command insert = kcmd.newInsert(message, "message");
        Command fire = kcmd.newFireAllRules();
        BatchExecutionCommand batch = kcmd.newBatchExecution(Arrays.asList(insert, fire), "defaultKieSession");
        String payload = BatchExecutionHelper.newXStreamMarshaller().toXML((Object)batch);
        ServiceResponse reply = this.client.executeCommands("kie1", payload);
        Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)reply.getType());
        XStream xs = BatchExecutionHelper.newXStreamMarshaller();
        xs.setClassLoader((ClassLoader)cl);
        ExecutionResults results = (ExecutionResults)xs.fromXML((String)reply.getResult());
        Object value = results.getValue("message");
        Assert.assertEquals((Object)"echo:HelloWorld", (Object)getter.invoke(value, new Object[0]));
    }

    @Test
    public void testCommandScript() throws Exception {
        KieServices ks = KieServices.Factory.get();
        File jar = MavenRepository.getMavenRepository().resolveArtifact((org.kie.api.builder.ReleaseId)releaseId1).getFile();
        URLClassLoader cl = new URLClassLoader(new URL[]{jar.toURI().toURL()});
        Class<?> messageClass = cl.loadClass("org.pkg1.Message");
        Object message = messageClass.newInstance();
        Method setter = messageClass.getMethod("setText", String.class);
        setter.invoke(message, "HelloWorld");
        KieCommands kcmd = ks.getCommands();
        Command insert = kcmd.newInsert(message, "message");
        Command fire = kcmd.newFireAllRules();
        BatchExecutionCommand batch = kcmd.newBatchExecution(Arrays.asList(insert, fire), "defaultKieSession");
        String payload = BatchExecutionHelper.newXStreamMarshaller().toXML((Object)batch);
        CreateContainerCommand create = new CreateContainerCommand(new KieContainerResource("kie1", releaseId1, null));
        CallContainerCommand call = new CallContainerCommand("kie1", payload);
        DisposeContainerCommand dispose = new DisposeContainerCommand("kie1");
        List<KieServerCommand> cmds = Arrays.asList(create, call, dispose);
        CommandScript script = new CommandScript(cmds);
        List reply = this.client.executeScript(script);
        for (ServiceResponse r : reply) {
            Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)r.getType());
        }
    }

    @Test
    public void testCallContainerLookupError() throws Exception {
        this.client.createContainer("kie1", new KieContainerResource("kie1", releaseId1));
        String payload = "<batch-execution lookup=\"xyz\">\n  <insert out-identifier=\"message\">\n    <org.pkg1.Message>\n      <text>Hello World</text>\n    </org.pkg1.Message>\n  </insert>\n</batch-execution>";
        ServiceResponse reply = this.client.executeCommands("kie1", payload);
        Assert.assertEquals((Object)ServiceResponse.ResponseType.FAILURE, (Object)reply.getType());
    }

    @Test
    public void testScanner() throws Exception {
        this.client.createContainer("kie1", new KieContainerResource("kie1", releaseId1));
        ServiceResponse reply = this.client.getContainerInfo("kie1");
        Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)reply.getType());
        ServiceResponse si = this.client.getScannerInfo("kie1");
        Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)si.getType());
        KieScannerResource info = (KieScannerResource)si.getResult();
        Assert.assertEquals((Object)KieScannerStatus.DISPOSED, (Object)info.getStatus());
        si = this.client.updateScanner("kie1", new KieScannerResource(KieScannerStatus.STARTED, Long.valueOf(10000L)));
        Assert.assertEquals((String)si.getMsg(), (Object)ServiceResponse.ResponseType.SUCCESS, (Object)si.getType());
        info = (KieScannerResource)si.getResult();
        Assert.assertEquals((Object)KieScannerStatus.STARTED, (Object)info.getStatus());
        si = this.client.getScannerInfo("kie1");
        Assert.assertEquals((String)si.getMsg(), (Object)ServiceResponse.ResponseType.SUCCESS, (Object)si.getType());
        info = (KieScannerResource)si.getResult();
        Assert.assertEquals((Object)KieScannerStatus.STARTED, (Object)info.getStatus());
        si = this.client.updateScanner("kie1", new KieScannerResource(KieScannerStatus.STOPPED, Long.valueOf(10000L)));
        Assert.assertEquals((String)si.getMsg(), (Object)ServiceResponse.ResponseType.SUCCESS, (Object)si.getType());
        info = (KieScannerResource)si.getResult();
        Assert.assertEquals((Object)KieScannerStatus.STOPPED, (Object)info.getStatus());
        si = this.client.getScannerInfo("kie1");
        Assert.assertEquals((String)si.getMsg(), (Object)ServiceResponse.ResponseType.SUCCESS, (Object)si.getType());
        info = (KieScannerResource)si.getResult();
        Assert.assertEquals((Object)KieScannerStatus.STOPPED, (Object)info.getStatus());
        si = this.client.updateScanner("kie1", new KieScannerResource(KieScannerStatus.DISPOSED, Long.valueOf(10000L)));
        Assert.assertEquals((String)si.getMsg(), (Object)ServiceResponse.ResponseType.SUCCESS, (Object)si.getType());
        info = (KieScannerResource)si.getResult();
        Assert.assertEquals((Object)KieScannerStatus.DISPOSED, (Object)info.getStatus());
        si = this.client.getScannerInfo("kie1");
        Assert.assertEquals((String)si.getMsg(), (Object)ServiceResponse.ResponseType.SUCCESS, (Object)si.getType());
        info = (KieScannerResource)si.getResult();
        Assert.assertEquals((Object)KieScannerStatus.DISPOSED, (Object)info.getStatus());
    }

    public static byte[] createAndDeployJar(KieServices ks, ReleaseId releaseId, String ... drls) {
        KieFileSystem kfs = ks.newKieFileSystem().generateAndWritePomXML((org.kie.api.builder.ReleaseId)releaseId);
        for (int i = 0; i < drls.length; ++i) {
            if (drls[i] == null) continue;
            kfs.write("src/main/resources/org/pkg1/r" + i + ".drl", drls[i]);
        }
        byte[] pom = kfs.read("pom.xml");
        KieBuilder kb = ks.newKieBuilder(kfs).buildAll();
        Assert.assertFalse((String)kb.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).toString(), (boolean)kb.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR}));
        InternalKieModule kieModule = (InternalKieModule)ks.getRepository().getKieModule((org.kie.api.builder.ReleaseId)releaseId);
        byte[] jar = kieModule.getBytes();
        try {
            FileOutputStream fos = new FileOutputStream("target/baz-2.1.0.GA.jar");
            fos.write(jar);
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        repository = MavenRepository.getMavenRepository();
        repository.deployArtifact((org.kie.api.builder.ReleaseId)releaseId, jar, pom);
        return jar;
    }

    private void startServer() throws Exception {
        this.server = new TJWSEmbeddedJaxrsServer();
        this.server.setPort(PORT);
        this.server.start();
        this.server.getDeployment().getRegistry().addSingletonResource((Object)new KieServerRestImpl());
    }

    private void startClient() throws Exception {
        this.client = new KieServicesClient(BASE_URI);
    }

    private static void createAndDeployKJar(ReleaseId releaseId) {
        String drl = "package org.pkg1\nglobal java.util.List list;declare Message\n    text : String\nend\nrule echo dialect \"mvel\"\nwhen\n    $m : Message()\nthen\n    $m.text = \"echo:\" + $m.text;\nend\nrule X when\n    msg : String()\nthen\n    list.add(msg);\nend\n";
        KieServices ks = KieServices.Factory.get();
        KieServerTest.createAndDeployJar(ks, releaseId, drl);
        ks.getRepository().removeKieModule((org.kie.api.builder.ReleaseId)releaseId);
    }

    public static int findFreePort() {
        int port = 0;
        try {
            ServerSocket server = new ServerSocket(0);
            port = server.getLocalPort();
            server.close();
        }
        catch (IOException e) {
            port = 9789;
        }
        System.out.println("Allocating port: " + port);
        return port;
    }

    static {
        releaseId1 = new ReleaseId("foo.bar", "baz", "2.1.0.GA");
        releaseId2 = new ReleaseId("foo.bar", "baz", "2.1.1.GA");
    }
}

