/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl;

import org.drools.compiler.kie.builder.impl.InternalKieContainer;
import org.drools.compiler.kie.builder.impl.InternalKieScanner;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.ReleaseId;

public class KieContainerInstance {
    private KieContainerResource resource;
    private InternalKieContainer kieContainer;
    private InternalKieScanner scanner;

    public KieContainerInstance(String containerId, KieContainerStatus status) {
        this(containerId, status, null);
    }

    public KieContainerInstance(String containerId, KieContainerStatus status, InternalKieContainer kieContainer) {
        this.resource = new KieContainerResource(containerId, kieContainer != null ? new ReleaseId(kieContainer.getContainerReleaseId()) : null, status);
        this.kieContainer = kieContainer;
    }

    public String getContainerId() {
        return this.resource.getContainerId();
    }

    public void setContainerId(String containerId) {
        this.resource.setContainerId(containerId);
    }

    public InternalKieContainer getKieContainer() {
        return this.kieContainer;
    }

    public void setKieContainer(InternalKieContainer kieContainer) {
        this.kieContainer = kieContainer;
        this.updateReleaseId(kieContainer);
    }

    public KieContainerStatus getStatus() {
        return this.resource.getStatus();
    }

    public void setStatus(KieContainerStatus status) {
        this.resource.setStatus(status);
    }

    public KieContainerResource getResource() {
        this.updateReleaseId(this.kieContainer);
        return this.resource;
    }

    public void setResource(KieContainerResource resource) {
        this.resource = resource;
    }

    public void setScanner(InternalKieScanner scanner) {
        this.scanner = scanner;
    }

    public InternalKieScanner getScanner() {
        return this.scanner;
    }

    private void updateReleaseId(InternalKieContainer kieContainer) {
        if (kieContainer != null) {
            this.resource.setReleaseId(new ReleaseId(kieContainer.getContainerReleaseId()));
            this.resource.setResolvedReleaseId(new ReleaseId(kieContainer.getReleaseId()));
        }
    }

    public String toString() {
        return this.resource.toString();
    }
}

