/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.rest;

import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.services.api.KieServer;
import org.kie.server.services.impl.KieServerImpl;

@Path(value="/server")
public class KieServerRestImpl
implements KieServer {
    private KieServerImpl server;

    public KieServerRestImpl() {
        this.server = new KieServerImpl();
    }

    public KieServerRestImpl(KieServerImpl server) {
        this.server = server;
    }

    public KieServerImpl getServer() {
        return this.server;
    }

    public void setServer(KieServerImpl server) {
        this.server = server;
    }

    public Response getInfo() {
        return Response.ok((Object)this.server.getInfo()).build();
    }

    public Response execute(CommandScript command) {
        return Response.ok((Object)new /* Unavailable Anonymous Inner Class!! */).build();
    }

    public Response listContainers() {
        return Response.ok((Object)this.server.listContainers()).build();
    }

    public Response createContainer(String id, KieContainerResource container) {
        ServiceResponse response = this.server.createContainer(id, container);
        if (response.getType() == ServiceResponse.ResponseType.SUCCESS) {
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)response).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)response).build();
    }

    public Response getContainerInfo(String id) {
        return Response.ok((Object)this.server.getContainerInfo(id)).build();
    }

    public Response disposeContainer(String id) {
        return Response.ok((Object)this.server.disposeContainer(id)).build();
    }

    public Response execute(String id, String cmdPayload) {
        return Response.ok((Object)this.server.callContainer(id, cmdPayload)).build();
    }

    public Response getScannerInfo(String id) {
        return Response.ok((Object)this.server.getScannerInfo(id)).build();
    }

    public Response updateScanner(String id, KieScannerResource resource) {
        return Response.ok((Object)this.server.updateScanner(id, resource)).build();
    }

    public Response getReleaseId(String id) {
        return Response.ok((Object)this.server.getContainerReleaseId(id)).build();
    }

    public Response updateReleaseId(String id, ReleaseId releaseId) {
        return Response.ok((Object)this.server.updateContainerReleaseId(id, releaseId)).build();
    }
}

