/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl;

import com.thoughtworks.xstream.XStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.compiler.kie.builder.impl.InternalKieContainer;
import org.drools.compiler.kie.builder.impl.InternalKieScanner;
import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.runtime.BatchExecutionCommandImpl;
import org.kie.api.KieServices;
import org.kie.api.builder.Message;
import org.kie.api.builder.Results;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.command.Command;
import org.kie.api.runtime.ExecutionResults;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.api.Version;
import org.kie.server.api.commands.CallContainerCommand;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.commands.CreateContainerCommand;
import org.kie.server.api.commands.DisposeContainerCommand;
import org.kie.server.api.commands.ListContainersCommand;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.api.model.KieServerCommand;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.services.impl.KieContainerInstance;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.impl.XStreamXml;
import org.kie.server.services.rest.KieServerRestImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.io.IOService;
import org.uberfire.io.impl.IOServiceNio2WrapperImpl;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class KieServerImpl {
    private static final String CONTAINER_STATE_FILE = "container.xml";
    private static final Pattern LOOKUP = Pattern.compile("[\"']?lookup[\"']?\\s*[:=]\\s*[\"']([^\"']+)[\"']");
    private static final Logger logger = LoggerFactory.getLogger(KieServerRestImpl.class);
    private final KieContainersRegistryImpl context = new KieContainersRegistryImpl();
    private IOService ios = null;
    private FileSystem fs = null;

    private IOService initializeIOService() {
        IOServiceNio2WrapperImpl ios = new IOServiceNio2WrapperImpl();
        return ios;
    }

    private FileSystem initializeSystemFS(IOService ios) {
        URI uri = URI.create("git://system-repo");
        FileSystem fs = null;
        try {
            fs = ios.getFileSystem(uri);
            if (fs == null) {
                fs = ios.newFileSystem(uri, (Map)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        catch (Exception e) {
            fs = ios.newFileSystem(uri, (Map)new /* Unavailable Anonymous Inner Class!! */);
        }
        return fs;
    }

    public List<ServiceResponse<? extends Object>> executeScript(CommandScript commands) {
        ArrayList<ServiceResponse<? extends Object>> response = new ArrayList<ServiceResponse<? extends Object>>();
        if (commands != null) {
            for (KieServerCommand command : commands.getCommands()) {
                if (command instanceof CreateContainerCommand) {
                    response.add((ServiceResponse<? extends Object>)this.createContainer(((CreateContainerCommand)command).getContainer().getContainerId(), ((CreateContainerCommand)command).getContainer()));
                    continue;
                }
                if (command instanceof ListContainersCommand) {
                    response.add((ServiceResponse<? extends Object>)this.listContainers());
                    continue;
                }
                if (command instanceof CallContainerCommand) {
                    response.add((ServiceResponse<? extends Object>)this.callContainer(((CallContainerCommand)command).getContainerId(), ((CallContainerCommand)command).getPayload()));
                    continue;
                }
                if (!(command instanceof DisposeContainerCommand)) continue;
                response.add((ServiceResponse<? extends Object>)this.disposeContainer(((DisposeContainerCommand)command).getContainerId()));
            }
        }
        return response;
    }

    public ServiceResponse<KieServerInfo> getInfo() {
        try {
            Version version = KieServerEnvironment.getVersion();
            String versionStr = version != null ? version.toString() : "Unknown-Version";
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Kie Server info", (Object)new KieServerInfo(versionStr));
        }
        catch (Exception e) {
            logger.error("Error retrieving server info:", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error retrieving kie server info: " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServiceResponse<KieContainerResource> createContainer(String containerId, KieContainerResource container) {
        if (container == null || container.getReleaseId() == null) {
            logger.error("Error creating container. Release Id is null: " + container);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Failed to create container " + containerId + ". Release Id is null: " + container + ".");
        }
        ReleaseId releaseId = container.getReleaseId();
        try {
            KieContainerInstance ci = new KieContainerInstance(containerId, KieContainerStatus.CREATING);
            KieContainerInstance previous = null;
            KieContainerInstance kieContainerInstance = ci;
            synchronized (kieContainerInstance) {
                previous = this.context.addIfDoesntExist(containerId, ci);
                if (previous != null) {
                    return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Container " + containerId + " already exists.", (Object)previous.getResource());
                }
                try {
                    KieServices ks = KieServices.Factory.get();
                    InternalKieContainer kieContainer = (InternalKieContainer)ks.newKieContainer((org.kie.api.builder.ReleaseId)releaseId);
                    if (kieContainer != null) {
                        ci.setKieContainer(kieContainer);
                        ci.getResource().setStatus(KieContainerStatus.STARTED);
                        ServiceResponse serviceResponse = new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Container " + containerId + " successfully deployed with module " + releaseId + ".", (Object)ci.getResource());
                        return serviceResponse;
                    }
                    ci.getResource().setStatus(KieContainerStatus.FAILED);
                    ServiceResponse serviceResponse = new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Failed to create container " + containerId + " with module " + releaseId + ".");
                    return serviceResponse;
                }
                catch (Exception e) {
                    logger.error("Error creating container '" + containerId + "' for module '" + releaseId + "'", (Throwable)e);
                    ci.getResource().setStatus(KieContainerStatus.FAILED);
                    ServiceResponse serviceResponse = new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Failed to create container " + containerId + " with module " + releaseId + ": " + e.getClass().getName() + ": " + e.getMessage());
                    return serviceResponse;
                }
                finally {
                    this.persistContainer(ci);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error creating container '" + containerId + "' for module '" + releaseId + "'", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error creating container " + containerId + " with module " + releaseId + ": " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public ServiceResponse<KieContainerResourceList> listContainers() {
        try {
            ArrayList<KieContainerResource> containers = new ArrayList<KieContainerResource>();
            for (KieContainerInstance instance : this.context.getContainers()) {
                containers.add(instance.getResource());
            }
            KieContainerResourceList cil = new KieContainerResourceList(containers);
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "List of created containers", (Object)cil);
        }
        catch (Exception e) {
            logger.error("Error retrieving list of containers", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error listing containers: " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public ServiceResponse<KieContainerResource> getContainerInfo(String id) {
        try {
            KieContainerInstance ci = this.context.getContainer(id);
            if (ci != null) {
                return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Info for container " + id, (Object)ci.getResource());
            }
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Container " + id + " is not instantiated.");
        }
        catch (Exception e) {
            logger.error("Error retrieving info for container '" + id + "'", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error retrieving container info: " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public ServiceResponse<String> callContainer(String containerId, String payload) {
        if (payload == null) {
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error calling container " + containerId + ". Empty payload. ");
        }
        try {
            KieContainerInstance kci = this.context.getContainer(containerId);
            if (kci != null && kci.getKieContainer() != null) {
                String sessionId = null;
                Matcher m = LOOKUP.matcher(payload);
                if (m.find()) {
                    sessionId = m.group(1);
                }
                KieSession ks = null;
                if (sessionId != null) {
                    KieSessionModel ksm = kci.getKieContainer().getKieSessionModel(sessionId);
                    if (ksm != null) {
                        switch (4.$SwitchMap$org$kie$api$builder$model$KieSessionModel$KieSessionType[ksm.getType().ordinal()]) {
                            case 1: {
                                ks = kci.getKieContainer().getKieSession(sessionId);
                                break;
                            }
                            case 2: {
                                ks = kci.getKieContainer().getStatelessKieSession(sessionId);
                            }
                        }
                    }
                } else {
                    ks = kci.getKieContainer().getKieSession();
                }
                if (ks != null) {
                    ClassLoader moduleClassLoader = kci.getKieContainer().getClassLoader();
                    XStream xs = XStreamXml.newXStreamMarshaller((ClassLoader)moduleClassLoader);
                    Command cmd = (Command)xs.fromXML(payload);
                    if (cmd == null) {
                        return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Body of in message not of the expected type '" + Command.class.getName() + "'");
                    }
                    if (!(cmd instanceof BatchExecutionCommandImpl)) {
                        cmd = new BatchExecutionCommandImpl(Arrays.asList((GenericCommand)cmd));
                    }
                    ExecutionResults results = (ExecutionResults)ks.execute((Command)((BatchExecutionCommandImpl)cmd));
                    String result = xs.toXML((Object)results);
                    return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Container " + containerId + " successfully called.", (Object)result);
                }
                return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Session '" + sessionId + "' not found on container '" + containerId + "'.");
            }
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Container " + containerId + " is not instantiated.");
        }
        catch (Exception e) {
            logger.error("Error calling container '" + containerId + "'", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error calling container " + containerId + ": " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceResponse<Void> disposeContainer(String containerId) {
        try {
            KieContainerInstance kci = this.context.removeContainer(containerId);
            if (kci != null) {
                KieContainerInstance kieContainerInstance = kci;
                synchronized (kieContainerInstance) {
                    kci.setStatus(KieContainerStatus.DISPOSING);
                    if (kci.getKieContainer() != null) {
                        InternalKieContainer kieContainer = kci.getKieContainer();
                        kci.setKieContainer(null);
                        try {
                            kieContainer.dispose();
                        }
                        catch (Exception e) {
                            logger.warn("Container '" + containerId + "' disposed, but an unexpected exception was raised", (Throwable)e);
                            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Container " + containerId + " disposed, but exception was raised: " + e.getClass().getName() + ": " + e.getMessage());
                        }
                        return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Container " + containerId + " successfully disposed.");
                    }
                    return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Container " + containerId + " was not instantiated.");
                }
            }
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Container " + containerId + " was not instantiated.");
        }
        catch (Exception e) {
            logger.error("Error disposing Container '" + containerId + "'", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error disposing container " + containerId + ": " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public ServiceResponse<KieScannerResource> getScannerInfo(String id) {
        try {
            KieContainerInstance kci = this.context.getContainer(id);
            if (kci != null && kci.getKieContainer() != null) {
                InternalKieScanner scanner = kci.getScanner();
                KieScannerResource info = null;
                info = scanner != null ? new KieScannerResource(this.mapStatus(scanner.getStatus())) : new KieScannerResource(KieScannerStatus.DISPOSED);
                return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Scanner info successfully retrieved", (Object)info);
            }
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Unknown container " + id + ".");
        }
        catch (Exception e) {
            logger.error("Error retrieving scanner info for container '" + id + "'.", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error retrieving scanner info for container '" + id + "': " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public ServiceResponse<KieScannerResource> updateScanner(String id, KieScannerResource resource) {
        if (resource == null || resource.getStatus() == null) {
            logger.error("Error updating scanner for container " + id + ". Status is null: " + resource);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error updating scanner for container " + id + ". Status is null: " + resource);
        }
        KieScannerStatus status = resource.getStatus();
        try {
            KieContainerInstance kci = this.context.getContainer(id);
            if (kci != null && kci.getKieContainer() != null) {
                switch (4.$SwitchMap$org$kie$server$api$model$KieScannerStatus[status.ordinal()]) {
                    case 1: {
                        return this.createScanner(id, kci);
                    }
                    case 2: {
                        return this.startScanner(id, resource, kci);
                    }
                    case 3: {
                        return this.stopScanner(id, resource, kci);
                    }
                    case 4: {
                        return this.scanNow(id, resource, kci);
                    }
                    case 5: {
                        return this.disposeScanner(id, resource, kci);
                    }
                }
                return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Unknown status '" + status + "' for scanner on container " + id + ".");
            }
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Unknown container " + id + ".");
        }
        catch (Exception e) {
            logger.error("Error updating scanner for container '" + id + "': " + resource, (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error updating scanner for container '" + id + "': " + resource + ": " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private ServiceResponse<KieScannerResource> startScanner(String id, KieScannerResource resource, KieContainerInstance kci) {
        ServiceResponse response;
        if (kci.getScanner() == null && ServiceResponse.ResponseType.FAILURE.equals((Object)(response = this.createScanner(id, kci)).getType())) {
            return response;
        }
        if (KieScannerStatus.STOPPED.equals((Object)this.mapStatus(kci.getScanner().getStatus())) && resource.getPollInterval() != null) {
            kci.getScanner().start(resource.getPollInterval().longValue());
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Kie scanner successfully created.", (Object)new KieScannerResource(this.mapStatus(kci.getScanner().getStatus())));
        }
        if (!KieScannerStatus.STOPPED.equals((Object)this.mapStatus(kci.getScanner().getStatus()))) {
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Invalid kie scanner status: " + this.mapStatus(kci.getScanner().getStatus()), (Object)new KieScannerResource(this.mapStatus(kci.getScanner().getStatus())));
        }
        if (resource.getPollInterval() == null) {
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Invalid polling interval: " + resource.getPollInterval(), (Object)new KieScannerResource(this.mapStatus(kci.getScanner().getStatus())));
        }
        return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Unknown error starting scanner. Scanner was not started." + resource, (Object)new KieScannerResource(this.mapStatus(kci.getScanner().getStatus())));
    }

    private ServiceResponse<KieScannerResource> stopScanner(String id, KieScannerResource resource, KieContainerInstance kci) {
        if (kci.getScanner() == null) {
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Invalid call. Scanner is not instantiated. ", (Object)new KieScannerResource(KieScannerStatus.DISPOSED));
        }
        if (KieScannerStatus.STARTED.equals((Object)this.mapStatus(kci.getScanner().getStatus())) || KieScannerStatus.SCANNING.equals((Object)this.mapStatus(kci.getScanner().getStatus()))) {
            kci.getScanner().stop();
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Kie scanner successfully stopped.", (Object)new KieScannerResource(this.mapStatus(kci.getScanner().getStatus())));
        }
        return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Invalid kie scanner status: " + this.mapStatus(kci.getScanner().getStatus()), (Object)new KieScannerResource(this.mapStatus(kci.getScanner().getStatus())));
    }

    private ServiceResponse<KieScannerResource> scanNow(String id, KieScannerResource resource, KieContainerInstance kci) {
        if (kci.getScanner() == null) {
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Invalid call. Scanner is not instantiated. ", (Object)new KieScannerResource(KieScannerStatus.DISPOSED));
        }
        if (KieScannerStatus.STOPPED.equals((Object)this.mapStatus(kci.getScanner().getStatus()))) {
            kci.getScanner().scanNow();
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Scan successfully executed.", (Object)new KieScannerResource(this.mapStatus(kci.getScanner().getStatus())));
        }
        return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Invalid kie scanner status: " + this.mapStatus(kci.getScanner().getStatus()), (Object)new KieScannerResource(this.mapStatus(kci.getScanner().getStatus())));
    }

    private ServiceResponse<KieScannerResource> disposeScanner(String id, KieScannerResource resource, KieContainerInstance kci) {
        ServiceResponse response;
        if (kci.getScanner() == null) {
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Invalid call. Scanner already disposed. ", (Object)new KieScannerResource(KieScannerStatus.DISPOSED));
        }
        if ((KieScannerStatus.STARTED.equals((Object)this.mapStatus(kci.getScanner().getStatus())) || KieScannerStatus.SCANNING.equals((Object)this.mapStatus(kci.getScanner().getStatus()))) && ServiceResponse.ResponseType.FAILURE.equals((Object)(response = this.stopScanner(id, resource, kci)).getType())) {
            return response;
        }
        kci.getScanner().shutdown();
        kci.setScanner(null);
        return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Kie scanner successfully shutdown.", (Object)new KieScannerResource(KieScannerStatus.DISPOSED));
    }

    private ServiceResponse<KieScannerResource> createScanner(String id, KieContainerInstance kci) {
        if (kci.getScanner() == null) {
            InternalKieScanner scanner = (InternalKieScanner)KieServices.Factory.get().newKieScanner((KieContainer)kci.getKieContainer());
            kci.setScanner(scanner);
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Kie scanner successfully created.", (Object)new KieScannerResource(this.mapStatus(scanner.getStatus())));
        }
        return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error creating the scanner for container " + id + ". Scanner already exists.");
    }

    public ServiceResponse<ReleaseId> getContainerReleaseId(String id) {
        try {
            KieContainerInstance ci = this.context.getContainer(id);
            if (ci != null) {
                return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "ReleaseId for container " + id, (Object)ci.getResource().getReleaseId());
            }
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Container " + id + " is not instantiated.");
        }
        catch (Exception e) {
            logger.error("Error retrieving releaseId for container '" + id + "'", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error retrieving container releaseId: " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public ServiceResponse<ReleaseId> updateContainerReleaseId(String id, ReleaseId releaseId) {
        if (releaseId == null) {
            logger.error("Error updating releaseId for container '" + id + "'. ReleaseId is null.");
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error updating releaseId for container " + id + ". ReleaseId is null. ");
        }
        try {
            KieContainerInstance kci = this.context.getContainer(id);
            if (kci != null && kci.getKieContainer() != null) {
                Results results = kci.getKieContainer().updateToVersion((org.kie.api.builder.ReleaseId)releaseId);
                if (results.hasMessages(new Message.Level[]{Message.Level.ERROR})) {
                    logger.error("Error updating releaseId for container " + id + " to version " + releaseId + "\nMessages: " + results.getMessages());
                    return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error updating release id on container " + id + " to " + releaseId, (Object)kci.getResource().getReleaseId());
                }
                return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Release id successfully updated.", (Object)kci.getResource().getReleaseId());
            }
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Container " + id + " is not instantiated.");
        }
        catch (Exception e) {
            logger.error("Error updating releaseId for container '" + id + "'", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error updating releaseId for container " + id + ": " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private KieScannerStatus mapStatus(InternalKieScanner.Status status) {
        switch (4.$SwitchMap$org$drools$compiler$kie$builder$impl$InternalKieScanner$Status[status.ordinal()]) {
            case 1: {
                return KieScannerStatus.CREATED;
            }
            case 2: {
                return KieScannerStatus.STARTED;
            }
            case 3: 
            case 4: {
                return KieScannerStatus.SCANNING;
            }
            case 5: {
                return KieScannerStatus.STOPPED;
            }
            case 6: {
                return KieScannerStatus.DISPOSED;
            }
        }
        return KieScannerStatus.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreContainers() {
        block18: {
            DirectoryStream ds = null;
            try {
                Path containersPath = this.fs.getPath("/containers", new String[0]);
                if (!this.ios.exists(containersPath) || (ds = this.ios.newDirectoryStream(containersPath, (DirectoryStream.Filter)new /* Unavailable Anonymous Inner Class!! */)) == null) break block18;
                XStream xs = XStreamXml.newXStreamMarshaller((ClassLoader)KieServerImpl.class.getClassLoader());
                for (Path entry : ds) {
                    BufferedReader reader = null;
                    try {
                        logger.info("Restoring state of kie container '" + entry.getFileName() + "'");
                        reader = Files.newBufferedReader((Path)entry.resolve(CONTAINER_STATE_FILE), (Charset)Charset.forName("UTF-8"));
                        KieContainerResource resource = (KieContainerResource)xs.fromXML((Reader)reader);
                        this.restore(resource);
                    }
                    catch (Exception e) {
                        logger.error("Error restoring kie container state", (Throwable)e);
                    }
                    finally {
                        if (reader == null) continue;
                        try {
                            reader.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            catch (Exception e) {
                logger.error("Error restoring kie server state", (Throwable)e);
            }
            finally {
                if (ds != null) {
                    ds.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistContainer(KieContainerInstance ci) {
        if (this.fs != null) {
            BufferedWriter writer = null;
            try {
                logger.info("Persisting state for kie container '" + ci.getContainerId() + "'");
                XStream xs = XStreamXml.newXStreamMarshaller((ClassLoader)KieServerImpl.class.getClassLoader());
                Path file = this.fs.getPath("/containers/" + ci.getContainerId() + "/" + CONTAINER_STATE_FILE, new String[0]);
                writer = Files.newBufferedWriter((Path)file, (Charset)Charset.forName("UTF-8"), (OpenOption[])new OpenOption[0]);
                xs.toXML((Object)ci.getResource(), (Writer)writer);
            }
            catch (Exception e) {
                logger.error("Error persisting state for kie container '" + ci.getContainerId() + "'", (Throwable)e);
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void restore(KieContainerResource resource) {
        if (this.fs != null) {
            System.out.println(">>>>>>>>> RESTORING STATE FOR = " + resource);
        }
    }
}

