/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl;

import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.compiler.kie.builder.impl.InternalKieContainer;
import org.drools.compiler.kie.builder.impl.InternalKieScanner;
import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.runtime.BatchExecutionCommandImpl;
import org.kie.api.KieServices;
import org.kie.api.builder.Message;
import org.kie.api.builder.Results;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.command.Command;
import org.kie.api.runtime.ExecutionResults;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.api.Version;
import org.kie.server.api.commands.CallContainerCommand;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.commands.CreateContainerCommand;
import org.kie.server.api.commands.DisposeContainerCommand;
import org.kie.server.api.commands.ListContainersCommand;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.api.model.KieServerCommand;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.services.impl.KieContainerInstance;
import org.kie.server.services.impl.KieContainersRegistry;
import org.kie.server.services.impl.XStreamXml;
import org.kie.server.services.rest.KieServerRestImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieServerImpl {
    private static final String CONTAINER_STATE_FILE = "container.xml";
    private static final Pattern LOOKUP = Pattern.compile("[\"']?lookup[\"']?\\s*[:=]\\s*[\"']([^\"']+)[\"']");
    private static final Logger logger = LoggerFactory.getLogger(KieServerRestImpl.class);
    private final KieContainersRegistryImpl context = new KieContainersRegistryImpl();

    public List<ServiceResponse<? extends Object>> executeScript(CommandScript commands) {
        ArrayList<ServiceResponse<? extends Object>> response = new ArrayList<ServiceResponse<? extends Object>>();
        if (commands != null) {
            for (KieServerCommand command : commands.getCommands()) {
                if (command instanceof CreateContainerCommand) {
                    response.add(this.createContainer(((CreateContainerCommand)command).getContainer().getContainerId(), ((CreateContainerCommand)command).getContainer()));
                    continue;
                }
                if (command instanceof ListContainersCommand) {
                    response.add(this.listContainers());
                    continue;
                }
                if (command instanceof CallContainerCommand) {
                    response.add(this.callContainer(((CallContainerCommand)command).getContainerId(), ((CallContainerCommand)command).getPayload()));
                    continue;
                }
                if (!(command instanceof DisposeContainerCommand)) continue;
                response.add(this.disposeContainer(((DisposeContainerCommand)command).getContainerId()));
            }
        }
        return response;
    }

    public ServiceResponse<KieServerInfo> getInfo() {
        try {
            Version version = KieServerEnvironment.getVersion();
            String versionStr = version != null ? version.toString() : "Unknown-Version";
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Kie Server info", (Object)new KieServerInfo(versionStr));
        }
        catch (Exception e) {
            logger.error("Error retrieving server info:", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error retrieving kie server info: " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    public ServiceResponse<KieContainerResource> createContainer(String containerId, KieContainerResource container) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK], 0[TRYBLOCK], 1[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ServiceResponse<KieContainerResourceList> listContainers() {
        try {
            ArrayList<KieContainerResource> containers = new ArrayList<KieContainerResource>();
            for (KieContainerInstance instance : this.context.getContainers()) {
                containers.add(instance.getResource());
            }
            KieContainerResourceList cil = new KieContainerResourceList(containers);
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "List of created containers", (Object)cil);
        }
        catch (Exception e) {
            logger.error("Error retrieving list of containers", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error listing containers: " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public ServiceResponse<KieContainerResource> getContainerInfo(String id) {
        try {
            KieContainerInstance ci = this.context.getContainer(id);
            if (ci != null) {
                return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Info for container " + id, (Object)ci.getResource());
            }
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Container " + id + " is not instantiated.");
        }
        catch (Exception e) {
            logger.error("Error retrieving info for container '" + id + "'", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error retrieving container info: " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public ServiceResponse<String> callContainer(String containerId, String payload) {
        if (payload == null) {
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error calling container " + containerId + ". Empty payload. ");
        }
        try {
            KieContainerInstance kci = this.context.getContainer(containerId);
            if (kci != null && kci.getKieContainer() != null) {
                String sessionId = null;
                Matcher m = LOOKUP.matcher(payload);
                if (m.find()) {
                    sessionId = m.group(1);
                }
                KieSession ks = null;
                if (sessionId != null) {
                    KieSessionModel ksm = kci.getKieContainer().getKieSessionModel(sessionId);
                    if (ksm != null) {
                        switch (ksm.getType()) {
                            case STATEFUL: {
                                ks = kci.getKieContainer().getKieSession(sessionId);
                                break;
                            }
                            case STATELESS: {
                                ks = kci.getKieContainer().getStatelessKieSession(sessionId);
                            }
                        }
                    }
                } else {
                    ks = kci.getKieContainer().getKieSession();
                }
                if (ks != null) {
                    ClassLoader moduleClassLoader = kci.getKieContainer().getClassLoader();
                    XStream xs = XStreamXml.newXStreamMarshaller(moduleClassLoader);
                    Command cmd = (Command)xs.fromXML(payload);
                    if (cmd == null) {
                        return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Body of in message not of the expected type '" + Command.class.getName() + "'");
                    }
                    if (!(cmd instanceof BatchExecutionCommandImpl)) {
                        cmd = new BatchExecutionCommandImpl(Arrays.asList((GenericCommand)cmd));
                    }
                    ExecutionResults results = (ExecutionResults)ks.execute((Command)((BatchExecutionCommandImpl)cmd));
                    String result = xs.toXML((Object)results);
                    return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Container " + containerId + " successfully called.", (Object)result);
                }
                return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Session '" + sessionId + "' not found on container '" + containerId + "'.");
            }
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Container " + containerId + " is not instantiated.");
        }
        catch (Exception e) {
            logger.error("Error calling container '" + containerId + "'", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error calling container " + containerId + ": " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceResponse<Void> disposeContainer(String containerId) {
        try {
            KieContainerInstance kci = this.context.removeContainer(containerId);
            if (kci != null) {
                KieContainerInstance kieContainerInstance = kci;
                synchronized (kieContainerInstance) {
                    kci.setStatus(KieContainerStatus.DISPOSING);
                    if (kci.getKieContainer() != null) {
                        InternalKieContainer kieContainer = kci.getKieContainer();
                        kci.setKieContainer(null);
                        try {
                            kieContainer.dispose();
                        }
                        catch (Exception e) {
                            logger.warn("Container '" + containerId + "' disposed, but an unexpected exception was raised", (Throwable)e);
                            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Container " + containerId + " disposed, but exception was raised: " + e.getClass().getName() + ": " + e.getMessage());
                        }
                        return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Container " + containerId + " successfully disposed.");
                    }
                    return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Container " + containerId + " was not instantiated.");
                }
            }
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Container " + containerId + " was not instantiated.");
        }
        catch (Exception e) {
            logger.error("Error disposing Container '" + containerId + "'", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error disposing container " + containerId + ": " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public ServiceResponse<KieScannerResource> getScannerInfo(String id) {
        try {
            KieContainerInstance kci = this.context.getContainer(id);
            if (kci != null && kci.getKieContainer() != null) {
                InternalKieScanner scanner = kci.getScanner();
                KieScannerResource info = null;
                info = scanner != null ? new KieScannerResource(this.mapStatus(scanner.getStatus())) : new KieScannerResource(KieScannerStatus.DISPOSED);
                return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Scanner info successfully retrieved", (Object)info);
            }
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Unknown container " + id + ".");
        }
        catch (Exception e) {
            logger.error("Error retrieving scanner info for container '" + id + "'.", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error retrieving scanner info for container '" + id + "': " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public ServiceResponse<KieScannerResource> updateScanner(String id, KieScannerResource resource) {
        if (resource == null || resource.getStatus() == null) {
            logger.error("Error updating scanner for container " + id + ". Status is null: " + resource);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error updating scanner for container " + id + ". Status is null: " + resource);
        }
        KieScannerStatus status = resource.getStatus();
        try {
            KieContainerInstance kci = this.context.getContainer(id);
            if (kci != null && kci.getKieContainer() != null) {
                switch (status) {
                    case CREATED: {
                        return this.createScanner(id, kci);
                    }
                    case STARTED: {
                        return this.startScanner(id, resource, kci);
                    }
                    case STOPPED: {
                        return this.stopScanner(id, resource, kci);
                    }
                    case SCANNING: {
                        return this.scanNow(id, resource, kci);
                    }
                    case DISPOSED: {
                        return this.disposeScanner(id, resource, kci);
                    }
                }
                return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Unknown status '" + status + "' for scanner on container " + id + ".");
            }
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Unknown container " + id + ".");
        }
        catch (Exception e) {
            logger.error("Error updating scanner for container '" + id + "': " + resource, (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error updating scanner for container '" + id + "': " + resource + ": " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private ServiceResponse<KieScannerResource> startScanner(String id, KieScannerResource resource, KieContainerInstance kci) {
        ServiceResponse<KieScannerResource> response;
        if (kci.getScanner() == null && ServiceResponse.ResponseType.FAILURE.equals((Object)(response = this.createScanner(id, kci)).getType())) {
            return response;
        }
        if (KieScannerStatus.STOPPED.equals((Object)this.mapStatus(kci.getScanner().getStatus())) && resource.getPollInterval() != null) {
            kci.getScanner().start(resource.getPollInterval().longValue());
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Kie scanner successfully created.", (Object)new KieScannerResource(this.mapStatus(kci.getScanner().getStatus())));
        }
        if (!KieScannerStatus.STOPPED.equals((Object)this.mapStatus(kci.getScanner().getStatus()))) {
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Invalid kie scanner status: " + this.mapStatus(kci.getScanner().getStatus()), (Object)new KieScannerResource(this.mapStatus(kci.getScanner().getStatus())));
        }
        if (resource.getPollInterval() == null) {
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Invalid polling interval: " + resource.getPollInterval(), (Object)new KieScannerResource(this.mapStatus(kci.getScanner().getStatus())));
        }
        return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Unknown error starting scanner. Scanner was not started." + resource, (Object)new KieScannerResource(this.mapStatus(kci.getScanner().getStatus())));
    }

    private ServiceResponse<KieScannerResource> stopScanner(String id, KieScannerResource resource, KieContainerInstance kci) {
        if (kci.getScanner() == null) {
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Invalid call. Scanner is not instantiated. ", (Object)new KieScannerResource(KieScannerStatus.DISPOSED));
        }
        if (KieScannerStatus.STARTED.equals((Object)this.mapStatus(kci.getScanner().getStatus())) || KieScannerStatus.SCANNING.equals((Object)this.mapStatus(kci.getScanner().getStatus()))) {
            kci.getScanner().stop();
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Kie scanner successfully stopped.", (Object)new KieScannerResource(this.mapStatus(kci.getScanner().getStatus())));
        }
        return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Invalid kie scanner status: " + this.mapStatus(kci.getScanner().getStatus()), (Object)new KieScannerResource(this.mapStatus(kci.getScanner().getStatus())));
    }

    private ServiceResponse<KieScannerResource> scanNow(String id, KieScannerResource resource, KieContainerInstance kci) {
        if (kci.getScanner() == null) {
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Invalid call. Scanner is not instantiated. ", (Object)new KieScannerResource(KieScannerStatus.DISPOSED));
        }
        if (KieScannerStatus.STOPPED.equals((Object)this.mapStatus(kci.getScanner().getStatus()))) {
            kci.getScanner().scanNow();
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Scan successfully executed.", (Object)new KieScannerResource(this.mapStatus(kci.getScanner().getStatus())));
        }
        return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Invalid kie scanner status: " + this.mapStatus(kci.getScanner().getStatus()), (Object)new KieScannerResource(this.mapStatus(kci.getScanner().getStatus())));
    }

    private ServiceResponse<KieScannerResource> disposeScanner(String id, KieScannerResource resource, KieContainerInstance kci) {
        ServiceResponse<KieScannerResource> response;
        if (kci.getScanner() == null) {
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Invalid call. Scanner already disposed. ", (Object)new KieScannerResource(KieScannerStatus.DISPOSED));
        }
        if ((KieScannerStatus.STARTED.equals((Object)this.mapStatus(kci.getScanner().getStatus())) || KieScannerStatus.SCANNING.equals((Object)this.mapStatus(kci.getScanner().getStatus()))) && ServiceResponse.ResponseType.FAILURE.equals((Object)(response = this.stopScanner(id, resource, kci)).getType())) {
            return response;
        }
        kci.getScanner().shutdown();
        kci.setScanner(null);
        return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Kie scanner successfully shutdown.", (Object)new KieScannerResource(KieScannerStatus.DISPOSED));
    }

    private ServiceResponse<KieScannerResource> createScanner(String id, KieContainerInstance kci) {
        if (kci.getScanner() == null) {
            InternalKieScanner scanner = (InternalKieScanner)KieServices.Factory.get().newKieScanner((KieContainer)kci.getKieContainer());
            kci.setScanner(scanner);
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Kie scanner successfully created.", (Object)new KieScannerResource(this.mapStatus(scanner.getStatus())));
        }
        return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error creating the scanner for container " + id + ". Scanner already exists.");
    }

    public ServiceResponse<ReleaseId> getContainerReleaseId(String id) {
        try {
            KieContainerInstance ci = this.context.getContainer(id);
            if (ci != null) {
                return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "ReleaseId for container " + id, (Object)ci.getResource().getReleaseId());
            }
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Container " + id + " is not instantiated.");
        }
        catch (Exception e) {
            logger.error("Error retrieving releaseId for container '" + id + "'", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error retrieving container releaseId: " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public ServiceResponse<ReleaseId> updateContainerReleaseId(String id, ReleaseId releaseId) {
        if (releaseId == null) {
            logger.error("Error updating releaseId for container '" + id + "'. ReleaseId is null.");
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error updating releaseId for container " + id + ". ReleaseId is null. ");
        }
        try {
            KieContainerInstance kci = this.context.getContainer(id);
            if (kci != null && kci.getKieContainer() != null) {
                Results results = kci.getKieContainer().updateToVersion((org.kie.api.builder.ReleaseId)releaseId);
                if (results.hasMessages(new Message.Level[]{Message.Level.ERROR})) {
                    logger.error("Error updating releaseId for container " + id + " to version " + releaseId + "\nMessages: " + results.getMessages());
                    return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error updating release id on container " + id + " to " + releaseId, (Object)kci.getResource().getReleaseId());
                }
                return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Release id successfully updated.", (Object)kci.getResource().getReleaseId());
            }
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Container " + id + " is not instantiated.");
        }
        catch (Exception e) {
            logger.error("Error updating releaseId for container '" + id + "'", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error updating releaseId for container " + id + ": " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private KieScannerStatus mapStatus(InternalKieScanner.Status status) {
        switch (status) {
            case STARTING: {
                return KieScannerStatus.CREATED;
            }
            case RUNNING: {
                return KieScannerStatus.STARTED;
            }
            case SCANNING: 
            case UPDATING: {
                return KieScannerStatus.SCANNING;
            }
            case STOPPED: {
                return KieScannerStatus.STOPPED;
            }
            case SHUTDOWN: {
                return KieScannerStatus.DISPOSED;
            }
        }
        return KieScannerStatus.UNKNOWN;
    }

    public static class KieContainersRegistryImpl
    implements KieContainersRegistry {
        private final ConcurrentMap<String, KieContainerInstance> containers = new ConcurrentHashMap<String, KieContainerInstance>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public KieContainerInstance addIfDoesntExist(String containerId, KieContainerInstance ci) {
            ConcurrentMap<String, KieContainerInstance> concurrentMap = this.containers;
            synchronized (concurrentMap) {
                KieContainerInstance kci = this.containers.putIfAbsent(containerId, ci);
                if (kci != null && kci.getStatus() == KieContainerStatus.FAILED) {
                    this.containers.put(containerId, ci);
                    return null;
                }
                return kci;
            }
        }

        @Override
        public List<KieContainerInstance> getContainers() {
            return new ArrayList<KieContainerInstance>(this.containers.values());
        }

        @Override
        public KieContainerInstance getContainer(String containerId) {
            return (KieContainerInstance)this.containers.get(containerId);
        }

        @Override
        public KieContainerInstance removeContainer(String containerId) {
            return (KieContainerInstance)this.containers.remove(containerId);
        }
    }
}

